package com.ejianc.business.budget.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.budget.bean.BudgetProjectDetailProEntity;
import com.ejianc.business.budget.bean.BudgetProjectProEntity;
import com.ejianc.business.budget.mapper.BudgetProjectDetailProMapper;
import com.ejianc.business.budget.mapper.BudgetProjectProMapper;
import com.ejianc.business.budget.service.IBudgetProjectDetailProService;
import com.ejianc.business.budget.service.IBudgetProjectProService;
import com.ejianc.business.budget.vo.*;
import com.ejianc.business.budget.vo.comparator.BudgetDetailProComparatoeVo;
import com.ejianc.business.cost.utils.TreeNodeBUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 项目预算主实体
 *
 * @author generator
 *
 */
@Service("budgetProjectProService")
public class BudgetProjectProServiceImpl extends BaseServiceImpl<BudgetProjectProMapper, BudgetProjectProEntity> implements IBudgetProjectProService {
	@Autowired
	private BudgetProjectProMapper budgetProjectProMapper;
	@Autowired
	private IBudgetProjectDetailProService budgetProjectDetailProService;
	@Autowired
	private BudgetProjectDetailProMapper budgetProjectDetailProMapper;
	@Autowired
	private IBudgetProjectProService budgetProService;

	@Override
	public BudgetProjectProVO queryDetail(Long id) {
		BudgetProjectProEntity entity = budgetProjectProMapper.selectById(id);
		if (entity != null) {
			BudgetProjectProVO vo = BeanMapper.map(entity, BudgetProjectProVO.class);
			QueryParam queryParam = new QueryParam();
			queryParam.getParams().put("budget_id", new Parameter(QueryParam.EQ, vo.getId()));
			List<BudgetProjectDetailProEntity> detailProEntityList = budgetProjectDetailProService.queryList(queryParam, false);
			if (CollectionUtils.isNotEmpty(detailProEntityList)) {
                List<BudgetProjectDetailProVO> resultMapList = BeanMapper.mapList(detailProEntityList, BudgetProjectDetailProVO.class);
                for(BudgetProjectDetailProVO cdEntity:resultMapList){
                    cdEntity.setTid(cdEntity.getId().toString());
                    cdEntity.setTpid(cdEntity.getParentId()!= null&&cdEntity.getParentId()>0?cdEntity.getParentId().toString():"");
                    cdEntity.setRowState("edit");
                }
                //实现排序
                Collections.sort(resultMapList,new BudgetDetailProComparatoeVo());
                vo.setDetailList(TreeNodeBUtil.buildTree(resultMapList));
            }
            return vo;
        }
        return null;
    }

	@Override
	public List<BudgetProjectDetailReferenProVO> queryDetailList(Page<BudgetProjectDetailReferenProVO> page, QueryWrapper wrapper, Long projectId, String costType) {
		return budgetProjectProMapper.queryDetailList(page, wrapper, projectId, costType);
	}

	@Override
	public List<BudgetProjectDetailReferenProVO> queryOtherDetailList(Page<BudgetProjectDetailReferenProVO> page, QueryWrapper wrapper, Long projectId, String costType) {
		return budgetProjectProMapper.queryOtherDetailList(page, wrapper, projectId, costType);
	}


	/**
	 * 获取预算量价
	 *
	 * @param paramControlVO 项目预算Pro参数控制VO
	 *
	 * @return {@link BudgetProjectProQuantityAndMnyVO}
	 */
	@Override
	public BudgetProjectProQuantityAndMnyVO fetchQuantityAndMny(BudgetProjectProParamControlVO paramControlVO) {
		if (paramControlVO.getProjectId() == null) {
			return null;
		}

		BudgetProjectProQuantityAndMnyVO quantityAndMnyVO = new BudgetProjectProQuantityAndMnyVO();

		// 1、根据项目id查询已生效的预算编制单据信息，获取表头各金额和总金额数据
		LambdaQueryWrapper<BudgetProjectProEntity> lambdaQuery = Wrappers.lambdaQuery();
		lambdaQuery.eq(BudgetProjectProEntity::getProjectId, paramControlVO.getProjectId());
		lambdaQuery.in(BudgetProjectProEntity::getBillState, Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
		BudgetProjectProEntity entity = super.getOne(lambdaQuery);
		if (entity == null) {
			return null;
		}

		// 预算总金额（含税）
		quantityAndMnyVO.setBudgetTaxMny(entity.getBudgetTaxMny());
		// 预算总金额(无税)
		quantityAndMnyVO.setBudgetMny(entity.getBudgetMny());
		// 间接费(含税)
		quantityAndMnyVO.setIndirectionTaxMny(entity.getIndirectionTaxMny());
		// 间接费（无税）
		quantityAndMnyVO.setIndirectionMny(entity.getIndirectionMny());
		// 人工费（含税）
		quantityAndMnyVO.setLaborTaxMny(entity.getLaborTaxMny());
		// 人工费（无税）
		quantityAndMnyVO.setLaborMny(entity.getLaborMny());
		// 材料费（含税）
		quantityAndMnyVO.setMaterialTaxMny(entity.getMaterialTaxMny());
		// 材料费（无税）
		quantityAndMnyVO.setMaterialMny(entity.getMaterialMny());
		// 专业费（含税）
		quantityAndMnyVO.setMajorTaxMny(entity.getMajorTaxMny());
		// 专业费（无税）
		quantityAndMnyVO.setMajorMny(entity.getMajorMny());
		// 机械费(含税 )
		quantityAndMnyVO.setMechanicalTaxMny(entity.getMechanicalTaxMny());
		// 机械费（无税）
		quantityAndMnyVO.setMechanicalMny(entity.getMechanicalMny());
		//零星材料金额
		quantityAndMnyVO.setSporadicMaterialMny(entity.getSporadicMaterialMny());
		// 2、根据预算编制id和费用类型以及档案ids（可以不传），按照清单维度和档案维度查询预算清单量价（累计工程量、累计无税金额、累计含税金额）累计值
		Map<Long, BudgetProjectDetailProVO> detailProMap;
		if ((paramControlVO.getCostType() == 2 || paramControlVO.getCostType() == 4) && CollectionUtils.isNotEmpty(paramControlVO.getIds())) {
			detailProMap = budgetProjectDetailProMapper.fetchDetailProMapByQuantityAndMny(entity.getId(), paramControlVO.getCostType(), paramControlVO.getIds());
		} else {
			detailProMap = budgetProjectDetailProMapper.fetchDetailProMap(entity.getId(), paramControlVO.getCostType());
		}
		quantityAndMnyVO.setDetailProMap(detailProMap);

		return quantityAndMnyVO;
	}

	@Override
	public List<BudgetProjectDetailProVO> querySubDetailList(Page<BudgetProjectDetailProVO> page, QueryWrapper wrapper, Long projectId, String costType) {
		return budgetProjectProMapper.querySubDetailList(page, wrapper, projectId, costType);
	}

	@Override
	public void pushCostSetting(Long budgetId) {

	}

	@Override
	public List<BudgetProjectDetailProVO> queryOnlySuject(Long projectId, Integer costType, Set<Long> subjectIds) {
		return budgetProjectProMapper.queryOnlySuject(projectId,costType,subjectIds);
	}

	/**
	 * 根据项目id查询该项目的预算编制单中 物资档案的预算总量
	 * @param projectId
	 * @return
	 */
	@Override
	public Map<Long, BigDecimal> getBudgetProjectProQuantityByProjectId(Long projectId) {
		Map<Long, BigDecimal> map = new HashMap<>();
		if(projectId != null){
			List<BudgetProjectProQuantityVO> list = budgetProjectDetailProMapper.getBudgetProjectProQuantityByProjectId(projectId);
			if(CollectionUtils.isNotEmpty(list)){
				map = list.stream().collect(Collectors.toMap(BudgetProjectProQuantityVO::getMaterialId, BudgetProjectProQuantityVO::getNum, (key1, key2) -> key2));
			}
		}
		return map;

	}

	@Override
	public List<BudgetProjectDetailProVO> getBudgetProjectDetailProDataAndSum(Long projectId) {
		return budgetProjectProMapper.getBudgetProjectDetailProDataAndSum(projectId);
	}

	@Override
	public BudgetProjectProQuantityAndMnyVO fetchBudgetMny(List<Long> orgIds) {
		BudgetProjectProQuantityAndMnyVO quantityAndMnyVO = new BudgetProjectProQuantityAndMnyVO();
		LambdaQueryWrapper<BudgetProjectProEntity> lambdaQuery = Wrappers.lambdaQuery();
		lambdaQuery.in(BudgetProjectProEntity::getOrgId, orgIds);
		lambdaQuery.in(BudgetProjectProEntity::getBillState, Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
		List<BudgetProjectProEntity> list = this.list(lambdaQuery);
		if (CollectionUtils.isNotEmpty(list)) {
			for (BudgetProjectProEntity entity : list) {
				// 预算总金额（含税）
				quantityAndMnyVO.setBudgetTaxMny(ComputeUtil.safeAdd(entity.getBudgetTaxMny(), quantityAndMnyVO.getBudgetTaxMny()));
				// 间接费(含税)
				quantityAndMnyVO.setIndirectionTaxMny(ComputeUtil.safeAdd(entity.getIndirectionTaxMny(), quantityAndMnyVO.getIndirectionTaxMny()));
				// 人工费（含税）
				quantityAndMnyVO.setLaborTaxMny(ComputeUtil.safeAdd(entity.getLaborTaxMny(), quantityAndMnyVO.getLaborTaxMny()));
				// 材料费（含税）
				quantityAndMnyVO.setMaterialTaxMny(ComputeUtil.safeAdd(entity.getMaterialTaxMny(), quantityAndMnyVO.getMaterialTaxMny()));
				// 专业费（含税）
				quantityAndMnyVO.setMajorTaxMny(ComputeUtil.safeAdd(entity.getMajorTaxMny(), quantityAndMnyVO.getMajorTaxMny()));
				// 机械费(含税 )
				quantityAndMnyVO.setMechanicalTaxMny(ComputeUtil.safeAdd(entity.getMechanicalTaxMny(), quantityAndMnyVO.getMechanicalTaxMny()));
				//零星材料金额
				quantityAndMnyVO.setSporadicMaterialMny(ComputeUtil.safeAdd(entity.getSporadicMaterialMny(), quantityAndMnyVO.getSporadicMaterialMny()));
			}
		}
		return quantityAndMnyVO;
	}

	@Override
	public Map<String, BigDecimal> getProOutMny(Long projectId, Long id, String billTypeCode) {
		return budgetProjectProMapper.getProOutMny(projectId,id,billTypeCode);
	}

}
