package com.ejianc.business.invest.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 立项工作进展-详情
 * 
 * @author generator
 * 
 */
 @TableName("ejc_invest_work_progress_detail")
public class WorkProgressDetailEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编码
    @TableField(value="org_id")
    private Long orgId; // 组织id
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="bill_state")
    private Integer billState; // 单据状态（审批必须字段）
    @TableField(value="create_user_name")
    private String createUserName; // 编制人
    @TableField(value="update_user_name")
    private String updateUserName; // 修改者
    @TableField(value="description")
    private String description; // 描述
    @TableField(value="stage")
    private String stage; // 阶段(0:汇总1:报审2:调整报审)
    @TableField(value="progress")
    private String progress; // 进展(0:内部进行中1:外部进行中2:完成)
    @TableField(value="plan_finish_date")
    private Date planFinishDate; // 预计结束日期
    @TableField(value="last_track_date")
    private Date lastTrackDate; // 实际结束日期
    @TableField(value="actual_finish_date")
    private Date actualFinishDate; // 最新跟踪日期
    @TableField(value="work_list_id")
    private Long workListId; // 工作清单id
    @TableField(value="work_list_name")
    private String workListName; // 工作清单手续项
    @TableField(value="work_list_code")
    private String workListCode; // 工作清单编号
    @TableField(value="pid")
    private Long pid; // 主表id
    @TableField(value="project_id")
    private Long projectId; // 预立项项目id
    @TableField(value="project_name")
    private String projectName; // 预立项项目名称
    @TableField(value="project_code")
    private String projectCode; // 预立项项目编号

    @TableField(exist=false)
    @SubEntity(serviceName="workProgressTrackService",pidName = "workProgressDetailId")
    private List<WorkProgressTrackEntity> workProgressTrackList = new ArrayList<>(); // 立项工作进展-详情


    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }

    public List<WorkProgressTrackEntity> getWorkProgressTrackList() {
        return workProgressTrackList;
    }

    public void setWorkProgressTrackList(List<WorkProgressTrackEntity> workProgressTrackList) {
        this.workProgressTrackList = workProgressTrackList;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }
    public String getUpdateUserName() {
        return updateUserName;
    }

    public void setUpdateUserName(String updateUserName) {
        this.updateUserName = updateUserName;
    }
    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }
    public String getStage() {
        return stage;
    }

    public void setStage(String stage) {
        this.stage = stage;
    }
    public String getProgress() {
        return progress;
    }

    public void setProgress(String progress) {
        this.progress = progress;
    }
    public Date getPlanFinishDate() {
        return planFinishDate;
    }

    public void setPlanFinishDate(Date planFinishDate) {
        this.planFinishDate = planFinishDate;
    }
    public Date getLastTrackDate() {
        return lastTrackDate;
    }

    public void setLastTrackDate(Date lastTrackDate) {
        this.lastTrackDate = lastTrackDate;
    }
    public Date getActualFinishDate() {
        return actualFinishDate;
    }

    public void setActualFinishDate(Date actualFinishDate) {
        this.actualFinishDate = actualFinishDate;
    }
    public Long getWorkListId() {
        return workListId;
    }

    public void setWorkListId(Long workListId) {
        this.workListId = workListId;
    }
    public String getWorkListName() {
        return workListName;
    }

    public void setWorkListName(String workListName) {
        this.workListName = workListName;
    }
    public String getWorkListCode() {
        return workListCode;
    }

    public void setWorkListCode(String workListCode) {
        this.workListCode = workListCode;
    }
    public Long getPid() {
        return pid;
    }

    public void setPid(Long pid) {
        this.pid = pid;
    }
    
}
