package com.ejianc.business.invest.service.impl;

import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.invest.bean.ContractChangePlanEntity;
import com.ejianc.business.invest.bean.ContractHistoryPlanEntity;
import com.ejianc.business.invest.bean.ContractPlanEntity;
import com.ejianc.business.invest.service.IContractChangePlanService;
import com.ejianc.business.invest.service.IContractHistoryPlanService;
import com.ejianc.business.invest.service.IContractPlanService;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;

@Service("contractChangePlan")
public class ContractChangePlanBpmServiceImpl implements ICommonBusinessService {


    /**
     * 提交前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    ;

    /**
     * 提交完回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    /**
     * 有审批流的撤回前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {

        return CommonResponse.success();
    }

    ;

    /**
     * 有审批流的撤回后回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    ;

    /**
     * 审批节点审批中时节点审批前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    ;

    /**
     * 终审审核前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }


    @Autowired
    private IContractChangePlanService changePlanService;

    @Autowired
    private IContractPlanService planService;

    @Autowired
    private IContractHistoryPlanService historyPlanService;

    /**
     * 终审审核完回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        //变更表
        Date effectiveDate = new Date();
        ContractChangePlanEntity changeEntity = changePlanService.selectById(billId);
        LambdaUpdateWrapper<ContractChangePlanEntity> projectChangeProEntityLambdaUpdateWrapper = new LambdaUpdateWrapper<>();
        projectChangeProEntityLambdaUpdateWrapper.eq(ContractChangePlanEntity::getId, billId);
        projectChangeProEntityLambdaUpdateWrapper.set(ContractChangePlanEntity::getEffectiveDate, effectiveDate);
        changePlanService.update(projectChangeProEntityLambdaUpdateWrapper);


        ContractPlanEntity contractPlanEntity = planService.selectById(changeEntity.getPlanId());
        ContractHistoryPlanEntity historyEntity = BeanMapper.map(contractPlanEntity, ContractHistoryPlanEntity.class);
        historyEntity.setPlanId(changeEntity.getPlanId());
        historyEntity.setId(null);
        historyEntity.setCreateUserCode(null);
        historyEntity.setCreateTime(changeEntity.getEffectiveDate());
        historyEntity.setVersion(null);
        historyEntity.setUpdateTime(null);
        historyEntity.setUpdateUserCode(null);
        historyEntity.setChangeId(billId);
        historyEntity.setChangeCode(changeEntity.getBillCode());
        historyEntity.setChangeReason(changeEntity.getChangeReason());

        //同步原合同到记录表
        historyPlanService.saveOrUpdate(historyEntity, false);


        //修改合同字段
        ContractPlanEntity newContractEntity = BeanMapper.map(changeEntity, ContractPlanEntity.class);
        //变更状态-已变更
        newContractEntity.setChangeStatus(3);
        newContractEntity.setChangeCode(null);
        newContractEntity.setChangeId(null);
        //冗余变更单审批状态清空
        newContractEntity.setBillState(contractPlanEntity.getBillState());
        newContractEntity.setId(contractPlanEntity.getId());
        newContractEntity.setBillCode(contractPlanEntity.getBillCode());
        newContractEntity.setVersion(contractPlanEntity.getVersion());
        //合同初始创建信息
        newContractEntity.setCreateUserName(contractPlanEntity.getCreateUserName());
        newContractEntity.setCreateUserCode(contractPlanEntity.getCreateUserCode());
        newContractEntity.setCreateTime(contractPlanEntity.getCreateTime());
        planService.saveOrUpdate(newContractEntity);
        return CommonResponse.success();
    }

    /**
     * 弃审前事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.error("变更单暂不支持回退功能!");
    }

    /**
     * 弃审后事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        // 参数是单据类型编码字符串 根据需求是否打开下面代码
        /**CommonResponse<String> resp = billTypeApi.checkQuote(billTypeCode, billId);
         if(!resp.isSuccess()){
         return CommonResponse.error("无法撤回！"+resp.getMsg());
         }*/
        return CommonResponse.success();
    }

}
