package com.ejianc.business.budget.controller;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.budget.service.IBudgetCostReportService;
import com.ejianc.business.budget.vo.BudgetCostReportDetailVO;
import com.ejianc.business.budget.vo.BudgetCostReportVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelExport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 预算与成本报表控制类
 * 
 * @author generator
 * 
 */
@Controller
@RequestMapping("budgetCostReport")
public class BudgetCostReportController implements Serializable {
	private static final long serialVersionUID = 1L;
	
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBudgetCostReportService service;
    
    /**
     * @Description queryReport 查询详情
     * @param projectId
     */
    @RequestMapping(value = "/queryReport", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<BudgetCostReportVO> queryReport(Long projectId) {
        return service.queryReport(projectId);
    }

    @RequestMapping(value = "/excelExport", method = RequestMethod.GET)
    @ResponseBody
    public void excelExport(@RequestParam Long projectId, HttpServletResponse response) {
        CommonResponse<BudgetCostReportVO> commonResponse = service.queryReport(projectId);
        if(commonResponse.isSuccess() && commonResponse.getData() != null){
            Map<String, Object> beans = new HashMap<>();
            BudgetCostReportVO vo = commonResponse.getData();
            List<BudgetCostReportVO> list = new ArrayList<>();
            list.add(vo);
            beans.put("main", list);
            beans.put("detail", this.treeToList(vo.getDetailList()));
            ExcelExport.getInstance().export("budget-cost-report-export.xlsx", beans, response);
        }
    }

    private List<BudgetCostReportDetailVO> treeToList(List<BudgetCostReportDetailVO> values) {
        List<BudgetCostReportDetailVO> result = new ArrayList<>();
        for (BudgetCostReportDetailVO value : values) {
            result.add(value);
            if (!value.getChildren().isEmpty()) {
                List<BudgetCostReportDetailVO> child = BeanMapper.mapList(value.getChildren(),BudgetCostReportDetailVO.class );
                List<BudgetCostReportDetailVO> entityList = this.treeToList(child);
                result.addAll(entityList);
            }
        }
        if (result.size() > 0) {
            for (BudgetCostReportDetailVO value : result) {
                value.setChildren(null);
            }
        }
        return result;
    }

    @RequestMapping(value = "/queryDynamicCosts", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONObject> queryDynamicCosts(@RequestParam Long orgId) {
        return service.queryDynamicCosts(orgId);
    }

    @RequestMapping(value = "/queryInvestControl", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONObject> queryInvestControl(@RequestParam Long orgId) {
        return service.queryInvestControl(orgId);
    }

}
