package com.ejianc.business.budget.controller.api;

import com.ejianc.business.budget.service.IBudgetProjectProService;
import com.ejianc.business.budget.vo.BudgetProjectProParamControlVO;
import com.ejianc.business.budget.vo.BudgetProjectProQuantityAndMnyVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * 项目预算API接口：Pro版本
 *
 * @author baipengyan
 * @version 1.0
 * @since JDK 1.8
 */
@RestController
@RequestMapping(value = "/api/budgetProjectPro/")
public class BudgetProjectProApi {
	@Resource
	private IBudgetProjectProService service;

	/**
	 * 获取预算量价
	 *
	 * @param paramControlVO 项目预算Pro参数控制VO
	 *
	 * @return {@link CommonResponse}<{@link BudgetProjectProQuantityAndMnyVO}>
	 */
	@PostMapping(value = "/fetchQuantityAndMny")
	public CommonResponse<BudgetProjectProQuantityAndMnyVO> fetchQuantityAndMny(@Validated @RequestBody BudgetProjectProParamControlVO paramControlVO) {
		return CommonResponse.success("请求成功！", service.fetchQuantityAndMny(paramControlVO));
	}

	/**
	 * 根据项目id查询该项目的预算编制单中 物资档案的预算总量
	 * @param projectId
	 * @return
	 */
	@GetMapping(value = "getBudgetProjectProQuantityByProjectId")
	public CommonResponse<Map<Long, BigDecimal>> getBudgetProjectProQuantityByProjectId(@RequestParam(value = "projectId", required = true)  Long projectId){
		return CommonResponse.success("请求成功！", service.getBudgetProjectProQuantityByProjectId(projectId));
	}

	@PostMapping(value = "fetchBudgetMny")
	public CommonResponse<BudgetProjectProQuantityAndMnyVO> fetchBudgetMny(@RequestBody List<Long> orgIds) {
		return CommonResponse.success("请求成功！", service.fetchBudgetMny(orgIds));
	}

	/**
	 * 根据项目id查询该项目的总支出金额
	 * @param projectId
	 * @return
	 */
	@GetMapping(value = "getProOutMny")
	public CommonResponse<Map<String, BigDecimal>> getProOutMny(@RequestParam(value = "projectId") Long projectId,@RequestParam(value = "id",required = false) Long id,@RequestParam(value = "billTypeCode") String billTypeCode){
		return CommonResponse.success("请求成功！", service.getProOutMny(projectId,id,billTypeCode));
	}
}
