package com.ejianc.business.budget.mapper;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.budget.vo.BudgetCostReportDetailVO;
import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * 预算与成本报表
 * 
 * @author generator
 * 
 */
@Mapper
public interface BudgetCostReportMapper extends BaseCrudMapper<BudgetCostReportDetailVO> {

    List<BudgetCostReportDetailVO> getBudgetCostReport(@Param("projectId") Long projectId);

    List<Map> queryCostSubject(@Param("projectId")Long projectId);

    List<JSONObject> queryTargetCost(@Param("projectId")Long projectId, @Param("subjectNames")List<String> subjectNames);

    List<JSONObject> queryContract(@Param("projectId")Long projectId);

    List<JSONObject> queryBudgetCost(Long projectId, List<String> subjectNames);

    List<JSONObject> querySettle(Long projectId);
}
