package com.ejianc.business.budget.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.budget.bean.BudgetProjectEntity;
import com.ejianc.business.budget.mapper.BudgetCostReportMapper;
import com.ejianc.business.budget.service.IBudgetCostReportService;
import com.ejianc.business.budget.service.IBudgetProjectService;
import com.ejianc.business.budget.utils.DecimalUtils;
import com.ejianc.business.budget.vo.BudgetCostReportDetailVO;
import com.ejianc.business.budget.vo.BudgetCostReportVO;
import com.ejianc.business.budget.vo.comparator.BudgetCostReportDetailComparatoeVO;
import com.ejianc.business.cost.utils.ITreeNodeB;
import com.ejianc.business.cost.utils.TreeNodeBUtil;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ResultAsTree;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 预算与成本报表
 * 
 * @author generator
 * 
 */
@Service("budgetCostReportService")
public class BudgetCostReportServiceImpl extends BaseServiceImpl<BudgetCostReportMapper, BudgetCostReportDetailVO> implements IBudgetCostReportService {

    @Autowired
    private IBudgetProjectService budgetService;

    @Autowired
    private IProjectApi projectApi;

    @Override
    public CommonResponse<BudgetCostReportVO> queryReport(Long projectId) {
        LambdaQueryWrapper<BudgetProjectEntity> lambda = new LambdaQueryWrapper<>();
        lambda.eq(BudgetProjectEntity::getProjectId, projectId);
        lambda.and(wrapper -> wrapper.eq(BudgetProjectEntity::getBillState, 1).or().eq(BudgetProjectEntity::getBillState, 3));
        BudgetProjectEntity budgetEntity = budgetService.getOne(lambda);

        BudgetCostReportVO vo = new BudgetCostReportVO();
        vo.setProjectId(projectId);
        List<BudgetCostReportDetailVO> detailList = baseMapper.getBudgetCostReport(projectId);
        //实现排序
        Collections.sort(detailList, new BudgetCostReportDetailComparatoeVO());
        // 汇总成本金额与预算金额
//        BigDecimal budgetMny = null;// 预算金额
        BigDecimal costMny = null;// 成本金额
        // 考虑有可能挂到父级成本科目
        if(CollectionUtils.isNotEmpty(detailList)){
            for(BudgetCostReportDetailVO detail : detailList){
                if(detail.getLeafFlag().equals(1)){
//                    budgetMny = DecimalUtils.add(budgetMny, detail.getBudgetMny());
                    costMny = DecimalUtils.add(costMny, detail.getCostMny());
                    detail.setBudgetCostMny(DecimalUtils.subtractNull(detail.getBudgetMny(), detail.getCostMny()));// 预算-成本
                }
            }
            vo.setBudgetMny(budgetEntity != null ? budgetEntity.getBudgetMny() : null);
            vo.setCostMny(costMny);
            vo.setProjectName(detailList.get(0).getProjectName());
            // 构造树形
            List<BudgetCostReportDetailVO> treeList = TreeNodeBUtil.buildTree(detailList);
            for(BudgetCostReportDetailVO child : treeList){
                this.dealChildList(child);
            }
            vo.setDetailList(treeList);
        }
        return CommonResponse.success(vo);
    }
    @Override
    public CommonResponse<JSONObject> queryDynamicCosts(Long orgId) {
        CommonResponse<ProjectRegisterVO> projectResp = projectApi.queryProjectByProjectDepartmentId(orgId.toString());
        ProjectRegisterVO project = projectResp.getData();
        Long projectId = project.getId();
        if (null == projectId){
            throw new BusinessException("查询项目失败");
        }
        List<Map> subjectProject = baseMapper.queryCostSubject(projectId);
        List<String> subjectNames = subjectProject.stream().map(item -> item.get("subjectName").toString()).collect(Collectors.toList());


        List<JSONObject> targetCost = baseMapper.queryTargetCost(projectId,subjectNames);
        Map<Object, Object> taxPriceMap = targetCost.stream().filter(item->null!=item.get("name")&&null!=item.get("taxPrice")).collect(
                Collectors.toMap(item -> item.get("name"), item -> item.get("taxPrice")
                        ,(v1,v2)-> ComputeUtil.safeAdd(ComputeUtil.toBigDecimal(v1),ComputeUtil.toBigDecimal(v2))));

        Map<Object, Object> taxMnyMap = targetCost.stream().filter(item->null!=item.get("name")&&null!=item.get("taxMny"))
                .collect(Collectors.toMap(item -> item.get("name"), item -> item.get("taxMny")
                ,(v1,v2)-> ComputeUtil.safeAdd(ComputeUtil.toBigDecimal(v1),ComputeUtil.toBigDecimal(v2))));

        List<JSONObject> contractDate=baseMapper.queryContract(projectId);
        Map<Object, Object> contractMnyMap = contractDate.stream().filter(item->null!=item.get("subjectId")&&null!=item.get("contractMny"))
                .collect(Collectors.toMap(item -> item.get("subjectId"), item -> item.get("contractMny")
                , (v1, v2) -> v2));
        Map<Object, Object> sumChangeMny = contractDate.stream().filter(item->null!=item.get("subjectId")&&null!=item.get("sumChangeMny"))
                .collect(Collectors.toMap(item -> item.get("subjectId"), item -> item.get("sumChangeMny")
                , (v1, v2) -> v2));
        Map<Object, Object> planChangeMny = contractDate.stream().filter(item->null!=item.get("subjectId")&&null!=item.get("planChangeMny"))
                .collect(Collectors.toMap(item -> item.get("subjectId"), item -> item.get("planChangeMny")
                , (v1, v2) -> v2));

        for (Map jsonObject : subjectProject) {
            Object subjectId = jsonObject.get("id");
            Object subjectName = jsonObject.get("subjectName");
            jsonObject.put("taxPrice",ComputeUtil.scale(ComputeUtil.toBigDecimal(taxPriceMap.get(subjectName)),2));
            jsonObject.put("taxMny",ComputeUtil.scale(ComputeUtil.toBigDecimal(taxMnyMap.get(subjectName)),2));
            jsonObject.put("contractMny",ComputeUtil.scale(ComputeUtil.toBigDecimal(contractMnyMap.get(subjectId)),2));
            jsonObject.put("sumChangeMny",ComputeUtil.scale(ComputeUtil.toBigDecimal(sumChangeMny.get(subjectId)),2));
            jsonObject.put("planChangeMny",ComputeUtil.scale(ComputeUtil.toBigDecimal(planChangeMny.get(subjectId)),2));
            jsonObject.put("bqdtcb",ComputeUtil.safeAdd(ComputeUtil.toBigDecimal(jsonObject.get("contractMny"))
                    ,ComputeUtil.toBigDecimal(jsonObject.get("planChangeMny"))));
            jsonObject.put("dtcbyj",ComputeUtil.safeSub(ComputeUtil.toBigDecimal(jsonObject.get("bqdtcb"))
                    ,ComputeUtil.toBigDecimal(jsonObject.get("taxMny"))));
        }
        List<Map<String, Object>> treeData = ResultAsTree.createTreeData(subjectProject);
        for (Map<String, Object> treeDatum : treeData) {
            this.dealChildListTwo(treeDatum);
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("records", treeData);
        return CommonResponse.success("查询成功",jsonObject);
    }


    @Override
    public CommonResponse<JSONObject> queryInvestControl(Long orgId) {
        CommonResponse<ProjectRegisterVO> projectResp = projectApi.queryProjectByProjectDepartmentId(orgId.toString());
        ProjectRegisterVO project = projectResp.getData();
        Long projectId = project.getId();
        if (null == projectId){
            throw new BusinessException("查询项目失败");
        }
        List<Map> subjectProject = baseMapper.queryCostSubject(projectId);
        List<String> subjectNames = subjectProject.stream().map(item -> item.get("subjectName").toString()).collect(Collectors.toList());


        List<JSONObject> targetCost = baseMapper.queryBudgetCost(projectId,subjectNames);
        Map<Object, Object> investMnyMap = targetCost.stream().filter(item->null!=item.get("name")&&null!=item.get("investMny")).collect(
                Collectors.toMap(item -> item.get("name"), item -> item.get("investMny")));

        Map<Object, Object> planMnyMap = targetCost.stream().filter(item->null!=item.get("name")&&null!=item.get("planMny"))
                .collect(Collectors.toMap(item -> item.get("name"), item -> item.get("planMny")));

        Map<Object, Object> budgetMnyMap = targetCost.stream().filter(item->null!=item.get("name")&&null!=item.get("budgetMny"))
                .collect(Collectors.toMap(item -> item.get("name"), item -> item.get("budgetMny")));



        List<JSONObject> contractDate=baseMapper.queryContract(projectId);

        Map<Object, Object> contractMnyMap = contractDate.stream().filter(item->null!=item.get("subjectId")&&null!=item.get("contractMny"))
                .collect(Collectors.toMap(item -> item.get("subjectId"), item -> item.get("contractMny")
                        , (v1, v2) -> v2));
        Map<Object, Object> sumChangeMny = contractDate.stream().filter(item->null!=item.get("subjectId")&&null!=item.get("sumChangeMny"))
                .collect(Collectors.toMap(item -> item.get("subjectId"), item -> item.get("sumChangeMny")
                        , (v1, v2) -> v2));
        Map<Object, Object> sumPayMnyMny = contractDate.stream().filter(item->null!=item.get("subjectId")&&null!=item.get("sumPayMny"))
                .collect(Collectors.toMap(item -> item.get("subjectId"), item -> item.get("sumPayMny")
                        , (v1, v2) -> v2));

        List<JSONObject> settleDate=baseMapper.querySettle(projectId);

        Map<Object, Object> sumFinishMnyMap = settleDate.stream().filter(item->null!=item.get("subjectId")&&null!=item.get("sumFinishMny"))
                .collect(Collectors.toMap(item -> item.get("subjectId"), item -> item.get("sumFinishMny")
                        , (v1, v2) -> v2));
        Map<Object, Object> sumSettleMnyMny = settleDate.stream().filter(item->null!=item.get("subjectId")&&null!=item.get("sumPayMny"))
                .collect(Collectors.toMap(item -> item.get("subjectId"), item -> item.get("sumPayMny")
                        , (v1, v2) -> v2));

        for (Map jsonObject : subjectProject) {
            Object subjectId = jsonObject.get("id");
            Object subjectName = jsonObject.get("subjectName");
            jsonObject.put("investMny",ComputeUtil.scale(ComputeUtil.toBigDecimal(investMnyMap.get(subjectName)),2));
            jsonObject.put("planMny",ComputeUtil.scale(ComputeUtil.toBigDecimal(planMnyMap.get(subjectName)),2));
            jsonObject.put("budgetMny",ComputeUtil.scale(ComputeUtil.toBigDecimal(budgetMnyMap.get(subjectName)),2));

            jsonObject.put("contractMny",ComputeUtil.scale(ComputeUtil.toBigDecimal(contractMnyMap.get(subjectId)),2));
            jsonObject.put("sumPayMny",ComputeUtil.scale(ComputeUtil.toBigDecimal(sumPayMnyMny.get(subjectId)),2));
            jsonObject.put("sumChangeMny",ComputeUtil.scale(ComputeUtil.toBigDecimal(sumChangeMny.get(subjectId)),2));

            jsonObject.put("sumSettleMny",ComputeUtil.scale(ComputeUtil.toBigDecimal(sumSettleMnyMny.get(subjectId)),2));
            jsonObject.put("sumFinishMny",ComputeUtil.scale(ComputeUtil.toBigDecimal(sumFinishMnyMap.get(subjectId)),2));

            jsonObject.put("contractPayRatio",null!=jsonObject.get("contractMny")?ComputeUtil.getPercentage(ComputeUtil.toBigDecimal(jsonObject.get("sumPayMny"))
                    ,ComputeUtil.toBigDecimal(jsonObject.get("contractMny"))):null);
            jsonObject.put("contractSettleRatio",null!=jsonObject.get("contractMny")?ComputeUtil.getPercentage(ComputeUtil.toBigDecimal(jsonObject.get("sumSettleMny"))
                    ,ComputeUtil.toBigDecimal(jsonObject.get("contractMny"))):null);

            jsonObject.put("gusuan",ComputeUtil.safeSub(ComputeUtil.toBigDecimal(jsonObject.get("investMny"))
                    ,ComputeUtil.toBigDecimal(jsonObject.get("contractMny"))));
            jsonObject.put("gaisuan",ComputeUtil.safeSub(ComputeUtil.toBigDecimal(jsonObject.get("planMny"))
                    ,ComputeUtil.toBigDecimal(jsonObject.get("contractMny"))));
            jsonObject.put("jsjye",ComputeUtil.safeSub(ComputeUtil.toBigDecimal(jsonObject.get("contractMny"))
                    ,ComputeUtil.toBigDecimal(jsonObject.get("sumFinishMny"))));


        }
        List<Map<String, Object>> treeData = ResultAsTree.createTreeData(subjectProject);
        for (Map<String, Object> treeDatum : treeData) {
            this.dealChildListThree(treeDatum);
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("records", treeData);
        return CommonResponse.success("查询成功",jsonObject);
    }
    /**
     * 递归汇总子级
     * @param vo
     */
    private void dealChildList(BudgetCostReportDetailVO vo){
        BigDecimal budgetMny = null;// 预算金额
        BigDecimal costMny = null;// 成本金额
        if(CollectionUtils.isNotEmpty(vo.getChildren())){
            List<BudgetCostReportDetailVO> list = BeanMapper.mapList(vo.getChildren(), BudgetCostReportDetailVO.class);
            for(BudgetCostReportDetailVO child : list){
                this.dealChildList(child);
                budgetMny = DecimalUtils.add(budgetMny, child.getBudgetMny());
                costMny = DecimalUtils.add(costMny, child.getCostMny());
            }
            vo.setBudgetMny(budgetMny);
            vo.setCostMny(costMny);
            vo.setBudgetCostMny(DecimalUtils.subtractNull(budgetMny, costMny));// 预算-成本
            vo.setChildren(BeanMapper.mapList(list, ITreeNodeB.class));
        }
    }

    private void dealChildListTwo(Map<String, Object> map){
        BigDecimal taxPrice = null;
        BigDecimal taxMny = null;
        BigDecimal contractMny = null;
        BigDecimal sumChangeMny = null;
        BigDecimal planChangeMny = null;
        BigDecimal bqdtcb = null;
        BigDecimal dtcbyj = null;
        List<Map<String, Object>> children = (List<Map<String, Object>>) map.get("children");
        if(CollectionUtils.isNotEmpty(children)){
            for(Map<String, Object> child : children){
                this.dealChildListTwo(child);
                taxPrice = DecimalUtils.add(taxPrice, ComputeUtil.toBigDecimal(child.get("taxPrice")));
                taxMny = DecimalUtils.add(taxMny, ComputeUtil.toBigDecimal(child.get("taxMny")));
                contractMny = DecimalUtils.add(contractMny, ComputeUtil.toBigDecimal(child.get("contractMny")));
                sumChangeMny = DecimalUtils.add(sumChangeMny, ComputeUtil.toBigDecimal(child.get("sumChangeMny")));
                planChangeMny = DecimalUtils.add(planChangeMny, ComputeUtil.toBigDecimal(child.get("planChangeMny")));
                bqdtcb = DecimalUtils.add(bqdtcb, ComputeUtil.toBigDecimal(child.get("bqdtcb")));
                dtcbyj = DecimalUtils.add(dtcbyj, ComputeUtil.toBigDecimal(child.get("dtcbyj")));
            }
            map.put("taxMny",taxMny);
            map.put("taxPrice",taxPrice);
            map.put("contractMny",contractMny);
            map.put("sumChangeMny",sumChangeMny);
            map.put("planChangeMny",planChangeMny);
            map.put("bqdtcb",bqdtcb);
            map.put("dtcbyj",dtcbyj);
            map.put("children",children);
        }
    }

    private void dealChildListThree(Map<String, Object> map){
        BigDecimal investMny = null;
        BigDecimal planMny = null;
        BigDecimal budgetMny = null;
        BigDecimal contractMny = null;
        BigDecimal sumPayMny = null;
        BigDecimal sumChangeMny = null;
        BigDecimal sumSettleMny = null;
        BigDecimal sumFinishMny = null;
        BigDecimal gusuan = null;
        BigDecimal gaisuan = null;
        BigDecimal jsjye = null;
        List<Map<String, Object>> children = (List<Map<String, Object>>) map.get("children");
        if(CollectionUtils.isNotEmpty(children)){
            for(Map<String, Object> child : children){
                this.dealChildListThree(child);
                investMny = DecimalUtils.add(investMny, ComputeUtil.toBigDecimal(child.get("investMny")));
                planMny = DecimalUtils.add(planMny, ComputeUtil.toBigDecimal(child.get("planMny")));
                budgetMny = DecimalUtils.add(budgetMny, ComputeUtil.toBigDecimal(child.get("budgetMny")));
                contractMny = DecimalUtils.add(contractMny, ComputeUtil.toBigDecimal(child.get("contractMny")));
                sumPayMny = DecimalUtils.add(sumPayMny, ComputeUtil.toBigDecimal(child.get("sumPayMny")));
                sumChangeMny = DecimalUtils.add(sumChangeMny, ComputeUtil.toBigDecimal(child.get("sumChangeMny")));
                sumSettleMny = DecimalUtils.add(sumSettleMny, ComputeUtil.toBigDecimal(child.get("sumSettleMny")));
                sumFinishMny = DecimalUtils.add(sumFinishMny, ComputeUtil.toBigDecimal(child.get("sumFinishMny")));
                gusuan = DecimalUtils.add(gusuan, ComputeUtil.toBigDecimal(child.get("gusuan")));
                gaisuan = DecimalUtils.add(gaisuan, ComputeUtil.toBigDecimal(child.get("gaisuan")));
                jsjye = DecimalUtils.add(jsjye, ComputeUtil.toBigDecimal(child.get("jsjye")));
            }
            map.put("investMny",investMny);
            map.put("planMny",planMny);
            map.put("budgetMny",budgetMny);
            map.put("contractMny",contractMny);
            map.put("sumPayMny",sumPayMny);
            map.put("sumChangeMny",sumChangeMny);
            map.put("sumSettleMny",sumSettleMny);
            map.put("sumFinishMny",sumFinishMny);
            map.put("gusuan",gusuan);
            map.put("gaisuan",gaisuan);
            map.put("jsjye",jsjye);
            map.put("contractPayRatio",null!=map.get("contractMny")?ComputeUtil.getPercentage(ComputeUtil.toBigDecimal(map.get("sumPayMny"))
                    ,ComputeUtil.toBigDecimal(map.get("contractMny"))):null);
            map.put("contractSettleRatio",null!=map.get("contractMny")?ComputeUtil.getPercentage(ComputeUtil.toBigDecimal(map.get("sumSettleMny"))
                    ,ComputeUtil.toBigDecimal(map.get("contractMny"))):null);
            map.put("children",children);
        }
    }
}
