package com.ejianc.business.budget.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.budget.bean.BudgetProjectDetailProEntity;
import com.ejianc.business.budget.bean.BudgetProjectProEntity;
import com.ejianc.business.budget.mapper.BudgetProjectDetailProMapper;
import com.ejianc.business.budget.service.IBudgetProjectDetailProService;
import com.ejianc.business.budget.service.IBudgetProjectProService;
import com.ejianc.business.budget.utils.ExcelImportUtil;
import com.ejianc.business.budget.vo.BudgetProjectDetailChangeProVO;
import com.ejianc.business.budget.vo.BudgetProjectDetailProVO;
import com.ejianc.business.budget.vo.SubjectDetailProVO;
import com.ejianc.foundation.share.api.IMaterialApi;
import com.ejianc.foundation.share.vo.MaterialFuzzyMatchVO;
import com.ejianc.foundation.share.vo.MaterialPlusVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.util.*;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * 项目预算清单明细
 * 
 * @author generator
 * 
 */
@Service("budgetProjectDetailProService")
public class BudgetProjectDetailProServiceImpl extends BaseServiceImpl<BudgetProjectDetailProMapper, BudgetProjectDetailProEntity> implements IBudgetProjectDetailProService{

    @Autowired
    private IBillTypeApi billTypeApi;

    @Autowired
    private IMaterialApi materialApi;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBudgetProjectProService budgetProjectProService;

    @Override
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        JSONObject resp = new JSONObject();

        if (isFailed) {
            return CommonResponse.error("文件格式不合法！");
        } else {
            List<List<String>> result = ExcelReader.readExcel(mf);
            if (result != null && result.size() > 0) {
                //筛选重复序号
                Map<String, Integer> indexMap = new HashMap<>();
                List<BudgetProjectDetailProVO> detailVoList = new ArrayList<>();
                Map<String,String> tidMap = new HashMap<>();
                for (int i = 0; i < result.size(); i++) {
                    List<String> datas = result.get(i);
                    BudgetProjectDetailProVO vo = new BudgetProjectDetailProVO();
                    boolean flag = false;
                    boolean parentWarn = false;
                    String warnType = "";

                    String detailIndex = datas.get(0);
                    vo.setDetailIndex(detailIndex);
                    //维护父子关系
                    String id = UUID.randomUUID().toString().replaceAll("-", "");
                    if (StringUtils.isNotEmpty(detailIndex)) {//序号不为空
                        String[] split = detailIndex.split("[-/.]");
                        vo.setTid(id);
                        tidMap.put(detailIndex,id);
                        if (split.length > 1) {
                            vo.setTpid(detailIndex.substring(0, detailIndex.length() - split[split.length - 1].length() - 1));
                        }
                    } else {
                        vo.setTid(id);
                        vo.setTpid("");
                    }

                    if (indexMap.containsKey(detailIndex)) {//序号重复
                        return CommonResponse.error("第"+(i+2)+"行序号和第" + (indexMap.get(detailIndex)+2) + "行重复");
                    }else{
                        indexMap.put(detailIndex,i);
                    }

                    if(StringUtils.isEmpty(datas.get(1))){// 清单编码为空
                        vo.setCode(null);
                        warnType = warnType+"编码为空,";
                        flag = true;
                        parentWarn = true;
                    }else{
                        vo.setCode(datas.get(1));
                    }

                    if (StringUtils.isEmpty(datas.get(2))) {//清单名称为空
                        vo.setName(null);
                        warnType =  warnType+"清单名称为空,";
                        flag = true;
                        parentWarn = true;
                    } else {
                        String name = datas.get(2).replace(" ", "");
                        vo.setName(name);
                    }
                    if (StringUtils.isEmpty(datas.get(3))) {//费用类型为空

                    } else {
                        String costType = datas.get(3);
                        if (costType.equals("/")){
                            vo.setCostType(0);
                        }
                        if (costType.equals("人工费")){
                            vo.setCostType(1);
                        }
                        if (costType.equals("材料费")){
                            vo.setCostType(2);
                            vo.setMaterialName(vo.getName());
                        }
                        if (costType.equals("专业分包费")){
                            vo.setCostType(3);
                        }
                        if (costType.equals("机械费")){
                            vo.setCostType(4);
                            vo.setMaterialName(vo.getName());
                        }
                        if (costType.equals("间接费")){
                            vo.setCostType(5);
                        }
                    }
                    if (StringUtils.isNotEmpty(datas.get(4))){
                        String entryType = datas.get(4);
                        if (entryType.equals("档案")){
                            if (vo.getCostType()==1 || vo.getCostType()==3 || vo.getCostType()==5){
                                warnType =  warnType+"材料类型为档案时，费用类型必须为材料费或机械费!,";
                                flag = true;
                                parentWarn = true;
                            }
                            vo.setEntryType("1");
                        }
                        if (entryType.equals("手动录入")){
                            vo.setEntryType("0");
                        }
                    }
                    if (vo.getCostType()!=null && vo.getCostType()!=null && (vo.getCostType()==2 || vo.getCostType()==4) &&  StringUtils.isEmpty(datas.get(5))) {
                        String entryType = datas.get(4);
                        if ("档案".equals(entryType)){
                            vo.setCategoryName(null);
                            warnType =  warnType+"材料/设备类型为空,";
                            flag = true;
                            parentWarn = true;
                        }
                    } else {
                        if (StringUtils.isNotEmpty(datas.get(5))){
                            String categoryName =datas.get(5).replace(" ", "");
                            vo.setCategoryName(categoryName);
                        }
                        Integer costType = vo.getCostType();
                        if (costType!=null){
                            if (costType==1 || costType==3 || costType==5){
                                vo.setCategoryName(null);
                            }
                        }
                    }
                    if (vo.getCostType()!=null && (vo.getCostType()==2 || vo.getCostType()==4) && StringUtils.isEmpty(datas.get(6))) {//特征描述/规格型号
                        String entryType = datas.get(4);
                        if ("档案".equals(entryType)){
                            vo.setSpec(null);
                            warnType =  warnType+"特征描述/规格型号,";
                            flag = true;
                            parentWarn = true;
                        }
                    } else {
                        if (StringUtils.isNotEmpty(datas.get(6))){
                            String spec =datas.get(6).replace(" ", "");
                            spec=handleBlankString(spec,true);
                            if(StringUtils.isNotEmpty(spec) && spec.length() > 2000){
                                flag = true;
                                warnType = warnType + "特征描述/规格型号超过2000字,";
                            }
                            vo.setSpec(spec);
                        }
                    }
                    if (StringUtils.isNotEmpty(datas.get(7))){
                        if (StringUtils.isNotEmpty(datas.get(7))){
                            String unit =datas.get(7).replace(" ", "");
                            unit=handleBlankString(unit,true);
                            vo.setUnit(unit);
                        }
                    }
                    // 备注 //兼容下老模板没有备注的情况
                    if (datas.size() > 12) {
                        String bodyMemo = datas.get(12);
                        if (StringUtils.isNotEmpty(bodyMemo)) {
                            vo.setBodyMemo(bodyMemo);
                            if (bodyMemo.length() > 1000) {
                                flag = true;
                                warnType = warnType + "备注超过1000字,";
                            }
                        }
                    }
                    //子级才校验数量单价
                    if (vo.getCostType()!=null && !vo.getCostType().equals(0)){
                        if (StringUtils.isEmpty(datas.get(8))) {
                            vo.setNum(null);
                            warnType = warnType+"工程量为空,";
                            flag = true;
                        } else {
                            try {
                                vo.setNum(ComputeUtil.toBigDecimal(ComputeUtil.scaleStripTrailingZeros(new BigDecimal(datas.get(8)),8)));
                            } catch (Exception e) {
                                vo.setNum(null);
                                warnType = warnType+"工程量只能为数字或小数,";
                                flag = true;
                            }
                        }
                        if (StringUtils.isEmpty(datas.get(9))) {
//                            vo.setTaxPrice(null);
//                            warnType = warnType+"单价为空,";
//                            flag = true;
                        } else {
                            try {
                                vo.setTaxPrice(ComputeUtil.toBigDecimal(ComputeUtil.scaleStripTrailingZeros(new BigDecimal(datas.get(9)),8)));
                            } catch (Exception e) {
                                vo.setTaxPrice(null);
                                warnType = warnType+"综合单价只能为数字或小数,";
                                flag = true;
                            }
                        }
                        if (StringUtils.isEmpty(datas.get(10))) {
//                            vo.setTaxPrice(null);
//                            warnType = warnType+"单价为空,";
//                            flag = true;
                        } else {
                            try {
                                vo.setPrice(ComputeUtil.toBigDecimal(ComputeUtil.scaleStripTrailingZeros(new BigDecimal(datas.get(10)),8)));
                            } catch (Exception e) {
                                vo.setPrice(null);
                                warnType = warnType+"综合单价(无税)只能为数字或小数,";
                                flag = true;
                            }
                        }
                        if (StringUtils.isEmpty(datas.get(11))) {
                        } else {
                            try {
                                vo.setRate(ComputeUtil.toBigDecimal(ComputeUtil.scaleStripTrailingZeros(new BigDecimal(datas.get(11)),8)));
                            } catch (Exception e) {
                                vo.setRate(null);
                                warnType = warnType+"税率只能为数字或小数,";
                                flag = true;
                            }
                        }

                        if (null==vo.getTaxPrice()){
                            if (null==vo.getPrice()){
                            }else {
                                if (null==vo.getRate()){
                                    vo.setTaxPrice(vo.getPrice());
                                }else {
                                    BigDecimal add = ComputeUtil.safeAdd( ComputeUtil.safeDiv(vo.getRate(), new BigDecimal(100)),new BigDecimal(1));
                                    vo.setTaxPrice(vo.getPrice().multiply(add).setScale(8,4));
                                }
                            }
                        }else {
                            if (null==vo.getPrice()){
                                if (null==vo.getRate()){
                                    vo.setPrice(vo.getTaxPrice());
                                }else {
                                    BigDecimal price = ComputeUtil.safeDiv(vo.getTaxPrice(), ComputeUtil.safeAdd( ComputeUtil.safeDiv(vo.getRate(), new BigDecimal(100)),new BigDecimal(1)));
                                    vo.setPrice(ComputeUtil.toBigDecimal(ComputeUtil.scaleStripTrailingZeros(price,8)));
                                }
                            }
                        }
                    }
                    if (null != vo.getNum() &&  null != vo.getTaxPrice()) {
                        BigDecimal taxMny = ComputeUtil.safeMultiply(vo.getNum(), vo.getTaxPrice()).setScale(2,4);
                        BigDecimal mny=null;
                        vo.setTaxMny(taxMny);
                        if (vo.getRate()!=null){
//                             BigDecimal price = ComputeUtil.safeDiv(vo.getTaxPrice(), ComputeUtil.safeAdd( ComputeUtil.safeDiv(vo.getRate(), new BigDecimal(100)),new BigDecimal(1)));
//                             vo.setPrice(price);
                             mny = ComputeUtil.safeMultiply(vo.getNum(), vo.getPrice());
                            vo.setMny(mny.setScale(2,4)) ;
                        }else {
//                            vo.setPrice(vo.getTaxPrice());
                            vo.setTaxMny(taxMny);
                            vo.setMny(taxMny) ;
                        }
                        if (vo.getCostType()!=null){
                            if (vo.getCostType()==1){
                                vo.setLaborTaxMnyCost(vo.getTaxMny());
                                vo.setLaborMnyCost(vo.getMny());
                            }
                            if (vo.getCostType()==2){
                                vo.setMaterialMnyCost(vo.getMny());
                                vo.setMaterialTaxMnyCost(vo.getTaxMny());
                            }
                            if (vo.getCostType()==3){
                                vo.setMajorTaxMnyCost(vo.getTaxMny());
                                vo.setMajorMnyCost(vo.getMny());
                            }
                            if (vo.getCostType()==4){
                                vo.setMechanicalTaxMnyCost(vo.getTaxMny());
                                vo.setMechanicalMnyCost(vo.getMny());
                            }
                            if (vo.getCostType()==5){
                                vo.setIndirectionTaxMnyCost(vo.getTaxMny());
                                vo.setIndirectionMnyCost(vo.getMny());
                            }
                        }
                    }

                    vo.setImportFlag(!flag);// true=可以导入，false=不可导入
                    vo.setParentWarn(parentWarn);
                    if(flag){
                        warnType = warnType.substring(0,warnType.length()-1);
                    }
                    vo.setWarnType(warnType);
                    vo.setRowState("add");
                    vo.setArchiveFlag("2");
                    vo.setShadowId(vo.getTid());
                    String key= vo.getName()+vo.getCostType()+vo.getCategoryName()+vo.getSpec()+ vo.getUnit();
                    vo.setKey(key);
                    detailVoList.add(vo);
                }

                for(BudgetProjectDetailProVO tVo:detailVoList){
                    tVo.setTpid(tidMap.get(tVo.getTpid()));
                }
                List<Map<String, Object>> deailTreeData = ExcelImportUtil.treeData(BeanMapper.mapList(detailVoList, Map.class));
                List<Map<String, Object>> mapList = ExcelImportUtil.importFlag2(deailTreeData);
                List<Map<String, Object>> falseList = new ArrayList<>();
                List<List<Map<String, Object>>> allList = ExcelImportUtil.separate(mapList, falseList);
                List<Map<String, Object>> oldErrList = allList.get(1);

                List<Map<String, Object>> successListMap = allList.get(0);
                MaterialFuzzyMatchVO materialFuzzyMatchVO=new MaterialFuzzyMatchVO();
                HashMap<String, Boolean> materialHashMap = new HashMap<>();
                HashMap<String, Boolean> equipmentCategoryMap = new HashMap<>();

                materialFuzzyMatchVO = checkCategoryName(successListMap,materialFuzzyMatchVO,materialHashMap,equipmentCategoryMap);

                logger.info("物资设备分类是否存在:"+JSONObject.toJSONString(materialFuzzyMatchVO));
                //物资
                Map<String, Boolean> materialCategoryMap=null;
                //设备
                Map<String, Boolean> equipmentCategoryProMap=null;
                CommonResponse<MaterialFuzzyMatchVO> materialFuzzyMatchVOCommonResponse = materialApi.checkArchive(materialFuzzyMatchVO);
                if (materialFuzzyMatchVOCommonResponse.isSuccess()){
                    MaterialFuzzyMatchVO data = materialFuzzyMatchVOCommonResponse.getData();
                    materialCategoryMap = data.getMaterialCategoryMap();
                    equipmentCategoryProMap=data.getEquipmentCategoryMap();
                    //分类不存在放在newAllList中下标为一
                    List<Map<String, Object>>   newList = ExcelImportUtil.importCheckCategoryName(successListMap, materialCategoryMap,equipmentCategoryProMap);
                    List<Map<String, Object>> newfalseList = new ArrayList<>();
                    List<List<Map<String, Object>>> newAllList = ExcelImportUtil.separate(newList, newfalseList);
                    successListMap = newAllList.get(0);
                    oldErrList.addAll(newAllList.get(1));
                }
                List<Map<String, Object>> errorList=ExcelImportUtil.treeToList(oldErrList);
                //模糊查询
                MaterialFuzzyMatchVO materialNumberFuzzyMatchVO=new MaterialFuzzyMatchVO();
                HashMap<String, MaterialPlusVO> fuzzyMatchMap=new HashMap<>();
                materialNumberFuzzyMatchVO = queryNumberFuzzy(successListMap,materialNumberFuzzyMatchVO,fuzzyMatchMap);
                logger.info("物资设备模糊数量:"+JSONObject.toJSONString(materialNumberFuzzyMatchVO));
                //模糊数量
                CommonResponse<MaterialFuzzyMatchVO> materialFuzzyMatchVOCommonResponse1 = materialApi.fuzzyMatchNumber(materialNumberFuzzyMatchVO);
                Map<String, MaterialPlusVO> materialPlusMapVO=null;
                if (materialFuzzyMatchVOCommonResponse1.isSuccess()){
                    MaterialFuzzyMatchVO data = materialFuzzyMatchVOCommonResponse1.getData();
                    materialPlusMapVO = data.getFuzzyMatchMap();
                    //设置模糊匹配
                    successListMap=  setFuzzyMatch(successListMap,materialPlusMapVO);
                }else {
                    logger.info("物资设备模查询:"+materialFuzzyMatchVOCommonResponse1.isSuccess());
                }
                resp.put("successList",successListMap);
                resp.put("errorList",errorList);
                resp.put("successNum",result.size() - errorList.size());
                resp.put("errorNum",errorList.size());
                return CommonResponse.success(resp);
            }
            return CommonResponse.error("Excel为空");
        }
    }

    /**
     * 变更excel导入
     *
     * @param request
     * @param response
     */
    @Override
    public CommonResponse<JSONObject> excelImportForChange(HttpServletRequest request, HttpServletResponse response) {
        Long budgetId = Long.valueOf(request.getParameter("budgetId"));
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        JSONObject resp = new JSONObject();

        if (isFailed) {
            return CommonResponse.error("文件格式不合法！");
        } else {
            List<List<String>> result = ExcelReader.readExcel(mf);
            if (result != null && result.size() > 0) {
                //筛选重复序号
                Map<String, Integer> indexMap = new HashMap<>();
                List<BudgetProjectDetailProVO> detailVoList = new ArrayList<>();
                Map<String, String> tidMap = new HashMap<>();
                for (int i = 0; i < result.size(); i++) {
                    List<String> datas = result.get(i);
                    BudgetProjectDetailProVO vo = new BudgetProjectDetailProVO();
                    boolean flag = false;
                    boolean parentWarn = false;
                    String warnType = "";

                    String detailIndex = datas.get(0);
                    vo.setDetailIndex(detailIndex);
                    //维护父子关系
                    String id = UUID.randomUUID().toString().replaceAll("-", "");
                    if (StringUtils.isNotEmpty(detailIndex)) {//序号不为空
                        String[] split = detailIndex.split("[-/.]");
                        vo.setTid(id);
                        tidMap.put(detailIndex, id);
                        if (split.length > 1) {
                            vo.setTpid(detailIndex.substring(0, detailIndex.length() - split[split.length - 1].length() - 1));
                        }
                    } else {
                        vo.setTid(id);
                        vo.setTpid("");
                    }

                    if (indexMap.containsKey(detailIndex)) {//序号重复
                        return CommonResponse.error("第" + (i + 2) + "行序号和第" + (indexMap.get(detailIndex) + 2) + "行重复");
                    } else {
                        indexMap.put(detailIndex, i);
                    }

                    if (StringUtils.isEmpty(datas.get(1))) {// 清单编码为空
                        vo.setCode(null);
                        warnType = warnType + "编码为空,";
                        flag = true;
                        parentWarn = true;
                    } else {
                        vo.setCode(datas.get(1));
                    }

                    if (StringUtils.isEmpty(datas.get(2))) {//清单名称为空
                        vo.setName(null);
                        warnType = warnType + "清单名称为空,";
                        flag = true;
                        parentWarn = true;
                    } else {
                        String name = datas.get(2).replace(" ", "");
                        vo.setName(name);
                    }
                    if (StringUtils.isEmpty(datas.get(3))) {//费用类型为空

                    } else {
                        String costType = datas.get(3);
                        if (costType.equals("/")) {
                            vo.setCostType(0);
                        }
                        if (costType.equals("人工费")) {
                            vo.setCostType(1);
                        }
                        if (costType.equals("材料费")) {
                            vo.setCostType(2);
                            vo.setMaterialName(vo.getName());
                        }
                        if (costType.equals("专业分包费")) {
                            vo.setCostType(3);
                        }
                        if (costType.equals("机械费")) {
                            vo.setCostType(4);
                            vo.setMaterialName(vo.getName());
                        }
                        if (costType.equals("间接费")) {
                            vo.setCostType(5);
                        }
                    }
                    if (StringUtils.isNotEmpty(datas.get(4))) {
                        String entryType = datas.get(4);
                        if (entryType.equals("档案")) {
                            if (vo.getCostType() == 1 || vo.getCostType() == 3 || vo.getCostType() == 5) {
                                warnType = warnType + "材料类型为档案时，费用类型必须为材料费或机械费!,";
                                flag = true;
                                parentWarn = true;
                            }
                            vo.setEntryType("1");
                        }
                        if (entryType.equals("手动录入")) {
                            vo.setEntryType("0");
                        }
                    }
                    if (vo.getCostType() != null && vo.getCostType() != null && (vo.getCostType() == 2 || vo.getCostType() == 4) && StringUtils.isEmpty(datas.get(5))) {
                        String entryType = datas.get(4);
                        if ("档案".equals(entryType)) {
                            vo.setCategoryName(null);
                            warnType = warnType + "材料/设备类型为空,";
                            flag = true;
                            parentWarn = true;
                        }
                    } else {
                        if (StringUtils.isNotEmpty(datas.get(5))) {
                            String categoryName = datas.get(5).replace(" ", "");
                            vo.setCategoryName(categoryName);
                        }
                        Integer costType = vo.getCostType();
                        if (costType != null) {
                            if (costType == 1 || costType == 3 || costType == 5) {
                                vo.setCategoryName(null);
                            }
                        }
                    }
                    if (vo.getCostType() != null && (vo.getCostType() == 2 || vo.getCostType() == 4) && StringUtils.isEmpty(datas.get(6))) {//特征描述/规格型号
                        String entryType = datas.get(4);
                        if ("档案".equals(entryType)) {
                            vo.setSpec(null);
                            warnType = warnType + "特征描述/规格型号,";
                            flag = true;
                            parentWarn = true;
                        }
                    } else {
                        if (StringUtils.isNotEmpty(datas.get(6))) {
                            String spec = datas.get(6).replace(" ", "");
                            spec = handleBlankString(spec, true);
                            if (StringUtils.isNotEmpty(spec) && spec.length() > 2000) {
                                flag = true;
                                warnType = warnType + "特征描述/规格型号超过2000字,";
                            }
                            vo.setSpec(spec);
                        }
                    }
                    if (StringUtils.isNotEmpty(datas.get(7))) {
                        if (StringUtils.isNotEmpty(datas.get(7))) {
                            String unit = datas.get(7).replace(" ", "");
                            unit = handleBlankString(unit, true);
                            vo.setUnit(unit);
                        }
                    }
                    // 备注 //兼容下老模板没有备注的情况
                    if (datas.size() > 12) {
                        String bodyMemo = datas.get(12);
                        if (StringUtils.isNotEmpty(bodyMemo)) {
                            vo.setBodyMemo(bodyMemo);
                            if (bodyMemo.length() > 1000) {
                                flag = true;
                                warnType = warnType + "备注超过1000字,";
                            }
                        }
                    }

                    //子级才校验数量单价
                    if (vo.getCostType() != null && !vo.getCostType().equals(0)) {
                        if (StringUtils.isEmpty(datas.get(8))) {
                            vo.setNum(null);
                            warnType = warnType + "工程量为空,";
                            flag = true;
                        } else {
                            try {
                                vo.setNum(ComputeUtil.toBigDecimal(ComputeUtil.scaleStripTrailingZeros(new BigDecimal(datas.get(8)),8)));
                            } catch (Exception e) {
                                vo.setNum(null);
                                warnType = warnType + "工程量只能为数字或小数,";
                                flag = true;
                            }
                        }
                        if (StringUtils.isNotEmpty(datas.get(9))) {
                            try {
                                vo.setTaxPrice(ComputeUtil.toBigDecimal(ComputeUtil.scaleStripTrailingZeros(new BigDecimal(datas.get(9)),8)));
                            } catch (Exception e) {
                                vo.setTaxPrice(null);
                                warnType = warnType + "综合单价只能为数字或小数,";
                                flag = true;
                            }
                        }
                        if (StringUtils.isNotEmpty(datas.get(10))) {
                            try {
                                vo.setPrice(ComputeUtil.toBigDecimal(ComputeUtil.scaleStripTrailingZeros(new BigDecimal(datas.get(10)),8)));
                            } catch (Exception e) {
                                vo.setPrice(null);
                                warnType = warnType + "综合单价(无税)只能为数字或小数,";
                                flag = true;
                            }
                        }
                        if (StringUtils.isNotEmpty(datas.get(11))) {
                            try {
                                vo.setRate(ComputeUtil.toBigDecimal(ComputeUtil.scaleStripTrailingZeros(new BigDecimal(datas.get(11)),8)));
                            } catch (Exception e) {
                                vo.setRate(null);
                                warnType = warnType + "税率只能为数字或小数,";
                                flag = true;
                            }
                        }

                        if (null == vo.getTaxPrice()) {
                            if (null == vo.getPrice()) {
                            } else {
                                if (null == vo.getRate()) {
                                    vo.setTaxPrice(ComputeUtil.toBigDecimal(ComputeUtil.scaleStripTrailingZeros(vo.getPrice(),8)));
                                } else {
                                    BigDecimal add = ComputeUtil.safeAdd(ComputeUtil.safeDiv(vo.getRate(), new BigDecimal(100)), new BigDecimal(1));
                                    vo.setTaxPrice(ComputeUtil.toBigDecimal(ComputeUtil.scaleStripTrailingZeros(vo.getPrice().multiply(add),8)));
                                }
                            }
                        } else {
                            if (null == vo.getPrice()) {
                                if (null == vo.getRate()) {
                                    vo.setPrice(ComputeUtil.toBigDecimal(ComputeUtil.scaleStripTrailingZeros(vo.getTaxPrice(),8)));
                                } else {
                                    BigDecimal price = ComputeUtil.safeDiv(vo.getTaxPrice(), ComputeUtil.safeAdd(ComputeUtil.safeDiv(vo.getRate(), new BigDecimal(100)), new BigDecimal(1)));
                                    vo.setPrice(ComputeUtil.toBigDecimal(ComputeUtil.scaleStripTrailingZeros(price,8)));
                                }
                            }
                        }
                    }
                    if (null != vo.getNum() && null != vo.getTaxPrice()) {
                        BigDecimal taxMny = ComputeUtil.safeMultiply(vo.getNum(), vo.getTaxPrice()).setScale(2,4);
                        BigDecimal mny = null;
                        vo.setTaxMny(taxMny);
                        if (vo.getRate() != null) {
                            mny = ComputeUtil.safeMultiply(vo.getNum(), vo.getPrice());
                            vo.setMny(mny.setScale(2,4));
                        } else {
                            vo.setTaxMny(taxMny);
                            vo.setMny(taxMny);
                        }
                        if (vo.getCostType() != null) {
                            if (vo.getCostType() == 1) {
                                vo.setLaborTaxMnyCost(vo.getTaxMny());
                                vo.setLaborMnyCost(vo.getMny());
                            }
                            if (vo.getCostType() == 2) {
                                vo.setMaterialMnyCost(vo.getMny());
                                vo.setMaterialTaxMnyCost(vo.getTaxMny());
                            }
                            if (vo.getCostType() == 3) {
                                vo.setMajorTaxMnyCost(vo.getTaxMny());
                                vo.setMajorMnyCost(vo.getMny());
                            }
                            if (vo.getCostType() == 4) {
                                vo.setMechanicalTaxMnyCost(vo.getTaxMny());
                                vo.setMechanicalMnyCost(vo.getMny());
                            }
                            if (vo.getCostType() == 5) {
                                vo.setIndirectionTaxMnyCost(vo.getTaxMny());
                                vo.setIndirectionMnyCost(vo.getMny());
                            }
                        }
                    }

                    vo.setImportFlag(!flag);// true=可以导入，false=不可导入
                    vo.setParentWarn(parentWarn);
                    if (flag) {
                        warnType = warnType.substring(0, warnType.length() - 1);
                    }
                    vo.setWarnType(warnType);
                    vo.setRowState("add");
                    vo.setArchiveFlag("2");
                    vo.setShadowId(vo.getTid());
                    String key = vo.getName() + vo.getCostType() + vo.getCategoryName() + vo.getSpec() + vo.getUnit();
                    vo.setKey(key);
                    detailVoList.add(vo);
                }

                for (BudgetProjectDetailProVO tVo : detailVoList) {
                    tVo.setTpid(tidMap.get(tVo.getTpid()));
                }
                List<Map<String, Object>> deailTreeData = ExcelImportUtil.treeData(BeanMapper.mapList(detailVoList, Map.class));
                List<Map<String, Object>> mapList = ExcelImportUtil.importFlag2(deailTreeData);
                List<Map<String, Object>> falseList = new ArrayList<>();
                List<List<Map<String, Object>>> allList = ExcelImportUtil.separate(mapList, falseList);
                List<Map<String, Object>> oldErrList = allList.get(1);

                List<Map<String, Object>> successListMap = allList.get(0);
                MaterialFuzzyMatchVO materialFuzzyMatchVO = new MaterialFuzzyMatchVO();
                HashMap<String, Boolean> materialHashMap = new HashMap<>();
                HashMap<String, Boolean> equipmentCategoryMap = new HashMap<>();

                materialFuzzyMatchVO = checkCategoryName(successListMap, materialFuzzyMatchVO, materialHashMap, equipmentCategoryMap);

                logger.info("物资设备分类是否存在:" + JSONObject.toJSONString(materialFuzzyMatchVO));
                //物资
                Map<String, Boolean> materialCategoryMap = null;
                //设备
                Map<String, Boolean> equipmentCategoryProMap = null;
                CommonResponse<MaterialFuzzyMatchVO> materialFuzzyMatchVOCommonResponse = materialApi.checkArchive(materialFuzzyMatchVO);
                if (materialFuzzyMatchVOCommonResponse.isSuccess()) {
                    MaterialFuzzyMatchVO data = materialFuzzyMatchVOCommonResponse.getData();
                    materialCategoryMap = data.getMaterialCategoryMap();
                    equipmentCategoryProMap = data.getEquipmentCategoryMap();
                    //分类不存在放在newAllList中下标为一
                    List<Map<String, Object>> newList = ExcelImportUtil.importCheckCategoryName(successListMap, materialCategoryMap, equipmentCategoryProMap);
                    List<Map<String, Object>> newfalseList = new ArrayList<>();
                    List<List<Map<String, Object>>> newAllList = ExcelImportUtil.separate(newList, newfalseList);
                    successListMap = newAllList.get(0);
                    oldErrList.addAll(newAllList.get(1));
                }
                List<Map<String, Object>> errorList = ExcelImportUtil.treeToList(oldErrList);
                // 变更导入：数据库数据和excel数据合并，合并维度changeCompareCode（父级编码+ 自己编码） + materialId
                BudgetProjectProEntity budgetProjectProEntity = budgetProjectProService.selectById(budgetId);
                List<BudgetProjectDetailChangeProVO> detailList = BeanMapper.mapList(budgetProjectProEntity.getDetailList(), BudgetProjectDetailChangeProVO.class);
                List<BudgetProjectDetailChangeProVO> failedErrors = new LinkedList<>();
                Map<String, String> detailCodeMap = new HashMap<>();
                if (CollectionUtils.isNotEmpty(detailList)) {
                    for (BudgetProjectDetailChangeProVO tVo : detailList) {
                        tVo.setTid(tVo.getId().toString());
                        tVo.setTpid(tVo.getParentId() != null ? tVo.getParentId().toString() : null);
                    }
                    List<Map> detailListMap = BeanMapper.mapList(detailList, Map.class);
                    List<Map<String, Object>> maps = ExcelImportUtil.treeData(detailListMap);
                    Map<String, Integer> detailCodeCount = new HashMap();
                    ExcelImportUtil.getCompareCodeMapByTree(maps, detailCodeMap, null, detailCodeCount);
                }
                    //模糊查询
                MaterialFuzzyMatchVO materialNumberFuzzyMatchVO = new MaterialFuzzyMatchVO();
                HashMap<String, MaterialPlusVO> fuzzyMatchMap = new HashMap<>();
                materialNumberFuzzyMatchVO = queryNumberFuzzy(successListMap, materialNumberFuzzyMatchVO, fuzzyMatchMap);
                logger.info("物资设备模糊数量:" + JSONObject.toJSONString(materialNumberFuzzyMatchVO));
                //模糊数量
                CommonResponse<MaterialFuzzyMatchVO> materialFuzzyMatchVOCommonResponse1 = materialApi.fuzzyMatchNumber(materialNumberFuzzyMatchVO);
                Map<String, MaterialPlusVO> materialPlusMapVO = null;
                if (materialFuzzyMatchVOCommonResponse1.isSuccess()) {
                    MaterialFuzzyMatchVO data = materialFuzzyMatchVOCommonResponse1.getData();
                    materialPlusMapVO = data.getFuzzyMatchMap();
                    //设置模糊匹配
                    successListMap = setFuzzyMatch(successListMap, materialPlusMapVO);
                } else {
                    logger.info("物资设备模查询:" + materialFuzzyMatchVOCommonResponse1.isSuccess());
                }
                if (CollectionUtils.isNotEmpty(detailList)) {
                    // 导入的codemap
                    Map<String, Map<String, Object>> importCompareCodeEntityMap = new LinkedHashMap<>();
                    Map<String, Integer> importCodeCount = new HashMap();
                    ExcelImportUtil.getCompareCodeVOMapAndFlatData(successListMap, importCompareCodeEntityMap, null, new ArrayList<>(detailCodeMap.values()), importCodeCount);

                    for (BudgetProjectDetailChangeProVO cdEntity : detailList) {
                        String changeCompareCode = detailCodeMap.get(cdEntity.getId().toString());

                        Map<String, Object> importCompareCodeEntity = importCompareCodeEntityMap.get(changeCompareCode);
                        if (importCompareCodeEntity != null) {
                            boolean leafFlag = Boolean.parseBoolean(String.valueOf(importCompareCodeEntity.get("leafFlag")));
                            if(leafFlag != cdEntity.getLeafFlag()){
                                CommonResponse<String> res = billTypeApi.checkQuote("BT202210000001", cdEntity.getId());
                                if (!res.isSuccess()) {
                                    cdEntity.setWarnType("清单已被引用，不能删除或者调整级次");
                                    failedErrors.add(cdEntity);
                                }
                            }
                            importCompareCodeEntity.put("budgetDetailId", cdEntity.getId());
                            importCompareCodeEntity.put("budgetId", budgetId);
                        } else {
                            // 删除的清单是否被下游单据引用
                            CommonResponse<String> res = billTypeApi.checkQuote("BT202210000001", cdEntity.getId());
                            if (!res.isSuccess()) {
                                cdEntity.setWarnType("清单已被引用，不能删除或者调整级次!");
                                //failedErrors.add("原清单【序号：" + detailIndex + "，编号：" + code + "】已被引用，不允许删除，请调整excel重新导入！");
                                failedErrors.add(cdEntity);
                            }
                        }
                    }
                    successListMap = ExcelImportUtil.treeData(new ArrayList<>(importCompareCodeEntityMap.values()));

                    // 调试用
                    resp.put("detailCodeMap", detailCodeMap);
                    resp.put("importCompareCodeEntityMap", importCompareCodeEntityMap);
                }

                resp.put("successList", successListMap);
                resp.put("errorList", errorList);
                resp.put("failedErrors", failedErrors);
                resp.put("successNum", result.size() - errorList.size());
                resp.put("errorNum", errorList.size());
                return CommonResponse.success(resp);
            }
            return CommonResponse.error("Excel为空");
        }
    }

    @Override
    public List<SubjectDetailProVO> querySubjectDetail(Long id, Long projectId) {
        return baseMapper.querySubjectDetail(id, projectId);
    }


    static Pattern LEVEL_PATTERN = Pattern.compile("\\.");
    // 根据序号获取清单级次
    public static int getLevel(String content) {
        Matcher matcher = LEVEL_PATTERN.matcher(content);
        int count = 1;
        while (matcher.find()) {
            count++;
        }
        return count;
    }


    public MaterialFuzzyMatchVO checkCategoryName(List<Map<String, Object>> successListMap,MaterialFuzzyMatchVO materialFuzzyMatchVO, HashMap<String, Boolean> materialHashMap, HashMap<String, Boolean> equipmentCategoryMap){
        //校验分类
        if (CollectionUtils.isNotEmpty(successListMap)){
             for (Map<String, Object> stringObjectMap : successListMap) {
                 if (stringObjectMap.get("children")!=null){
                     List<Map<String, Object>> list = (List<Map<String, Object>>)stringObjectMap.get("children");
                     checkCategoryName(list,materialFuzzyMatchVO,materialHashMap,equipmentCategoryMap);
                 }else {
                     Integer costType = stringObjectMap.get("costType")!=null ? (Integer)stringObjectMap.get("costType") : null;
                     String categoryName = (String)stringObjectMap.get("categoryName");
                     String entryType = stringObjectMap.get("entryType")!=null ? (String)stringObjectMap.get("entryType") : null;
                     if (costType!=null && costType==2 && entryType!=null && entryType.equals("1")){
                         materialHashMap.put(categoryName,false);
                     }
                     else if (costType!=null && costType==4 &&  entryType!=null && entryType.equals("1")){
                         equipmentCategoryMap.put(categoryName,false);
                     }
                 }
             }
            //分类是否存在
            materialFuzzyMatchVO.setMaterialCategoryMap(materialHashMap);
            materialFuzzyMatchVO.setEquipmentCategoryMap(equipmentCategoryMap);
         }
        return materialFuzzyMatchVO;
    }


    public MaterialFuzzyMatchVO queryNumberFuzzy(List<Map<String, Object>> successListMap,MaterialFuzzyMatchVO materialNumberFuzzyMatchVO,HashMap<String, MaterialPlusVO> fuzzyMatchMap){
        if (CollectionUtils.isNotEmpty(successListMap)){
            for (Map<String, Object> stringObjectMap : successListMap) {
                if (stringObjectMap.get("children")!=null){
                    List<Map<String, Object>> list = (List<Map<String, Object>>)stringObjectMap.get("children");
                    queryNumberFuzzy(list,materialNumberFuzzyMatchVO,fuzzyMatchMap);
                }else {
                    Integer costType = stringObjectMap.get("costType")!=null ? (Integer)stringObjectMap.get("costType") : null;
                    String categoryName = (String)stringObjectMap.get("categoryName");
                    String entryType = stringObjectMap.get("entryType")!=null ? (String)stringObjectMap.get("entryType") : null;
                    if (costType!=null && costType==2 && entryType!=null && entryType.equals("1")){
                        //查询模糊数量
                        materialNumberFuzzyMatchVO.setType(1);
                        MaterialPlusVO materialPlusVO = new MaterialPlusVO();
                        materialPlusVO.setType(1);
                        materialPlusVO.setCategoryName(categoryName);
                        String spec = (String)stringObjectMap.get("spec");
                        materialPlusVO.setSpec(spec);
                        String name = (String)stringObjectMap.get("name");
                        materialPlusVO.setName(name);
                        String unit = (String)stringObjectMap.get("unit");
                        materialPlusVO.setCategoryName(categoryName);
                        materialPlusVO.setUnitName(unit);
                        fuzzyMatchMap.put(stringObjectMap.get("key").toString(),materialPlusVO);
                    }
                    else if (costType!=null && costType==4 &&  entryType!=null && entryType.equals("1")){
                        //查询模糊数量
                        MaterialPlusVO materialPlusVO = new MaterialPlusVO();
                        materialPlusVO.setType(2);
                        materialPlusVO.setCategoryName(categoryName);
                        String spec = (String)stringObjectMap.get("spec");
                        materialPlusVO.setSpec(spec);
                        String name = (String)stringObjectMap.get("name");
                        materialPlusVO.setName(name);
                        materialPlusVO.setCategoryName(categoryName);
                        String unit = (String)stringObjectMap.get("unit");
                        materialPlusVO.setUnitName(unit);
                        fuzzyMatchMap.put(stringObjectMap.get("key").toString(),materialPlusVO);
                    }
                }
            }
            //模糊数量
            materialNumberFuzzyMatchVO.setFuzzyMatchMap(fuzzyMatchMap);
        }
        return materialNumberFuzzyMatchVO;
    }

    public List<Map<String, Object>>  setFuzzyMatch(List<Map<String, Object>> successListMap,Map<String, MaterialPlusVO> materialPlusMapVO){
        if (CollectionUtils.isNotEmpty(successListMap)){
            for (Map<String, Object> stringObjectMap : successListMap) {
                if (stringObjectMap.get("children")!=null){
                    List<Map<String, Object>> list = (List<Map<String, Object>>)stringObjectMap.get("children");
                    setFuzzyMatch(list,materialPlusMapVO);
                }else {
                    Integer costType = stringObjectMap.get("costType")!=null ? (Integer)stringObjectMap.get("costType") : null;
                    String key = (String)stringObjectMap.get("key");
                        if (materialPlusMapVO!=null){
                            MaterialPlusVO materialPlusVO = materialPlusMapVO.get(key);
                            if (materialPlusVO!=null){
                                Integer matchStatus = materialPlusVO.getMatchStatus();
                                Integer type = materialPlusVO.getType();
                                if (matchStatus!=null && matchStatus==1 ){
                                    stringObjectMap.put("categoryId",materialPlusVO.getCategoryId());
                                    stringObjectMap.put("categoryName",materialPlusVO.getCategoryName());
                                    stringObjectMap.put("materialId",materialPlusVO.getId());
                                    stringObjectMap.put("materialName",materialPlusVO.getName());
                                    stringObjectMap.put("spec",materialPlusVO.getSpec());
                                    stringObjectMap.put("unit",materialPlusVO.getUnitName());
                                    stringObjectMap.put("materialCode",materialPlusVO.getCode());
                                }
                                Integer matchNumber = materialPlusVO.getMatchNumber();
                                String matchStatusDescription = materialPlusVO.getMatchStatusDescription();
                                stringObjectMap.put("matchStatus",matchStatus);
                                stringObjectMap.put("matchNumber",matchNumber);
                                stringObjectMap.put("matchStatusDescription",matchStatusDescription);
                            }
                        }
                    }
                }
            }
        return successListMap;
    }

    private static String handleBlankString(String str, boolean flag) {
        if (StringUtils.isBlank(str)) {
            return "";
        }
        if (flag) {
            // 只去除首尾空格
            return str.trim();
        } else {
            // 去除空格和空白字符
            return str.replaceAll("\\s*", "");
        }
    }
}
