package com.ejianc.business.budget.mapper;

import com.ejianc.business.budget.bean.BudgetProjectDetailProEntity;
import com.ejianc.business.budget.vo.BudgetProjectDetailProVO;
import com.ejianc.business.budget.vo.BudgetProjectProQuantityVO;
import com.ejianc.business.budget.vo.SubjectDetailProVO;
import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import org.apache.ibatis.annotations.MapKey;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * 项目预算清单明细
 *
 * @author generator
 */
@Mapper
public interface BudgetProjectDetailProMapper extends BaseCrudMapper<BudgetProjectDetailProEntity> {

    /**
     * 获取清单明细Map集合(档案专用)，key-通用id(清单id、档案id)，value-清单明细vo对象
     *
     * @param budgetId 项目预算id
     * @param costType 费用类型
     * @param ids      物料设备或者分包ids
     *
     * @return {@link Map}<{@link Long}, {@link BudgetProjectDetailProVO}>
     */
    @MapKey(value = "commonId")
    Map<Long, BudgetProjectDetailProVO> fetchDetailProMapByQuantityAndMny(@Param(value = "budgetId") Long budgetId,
                                                                          @Param(value = "costType") Integer costType,
                                                                          @Param(value = "ids") List<Long> ids);

    /**
     * 获取清单明细Map集合(非档案专用)，key-通用id(清单id、档案id)，value-清单明细vo对象
     *
     * @param budgetId 项目预算id
     * @param costType 成本类型
     *
     * @return {@link Map}<{@link Long}, {@link BudgetProjectDetailProVO}>
     */
    @MapKey(value = "commonId")
    Map<Long, BudgetProjectDetailProVO> fetchDetailProMap(@Param(value = "budgetId") Long budgetId,
                                                          @Param(value = "costType") Integer costType);

    /**
     * 根据项目id查询该项目的预算编制单中 物资档案的预算总量
     * @param projectId
     * @return
     */
    List<BudgetProjectProQuantityVO> getBudgetProjectProQuantityByProjectId(@Param(value = "projectId") Long projectId);

    List<SubjectDetailProVO> querySubjectDetail(@Param(value = "budgetId") Long budgetId, @Param(value = "projectId") Long projectId);
}
