package com.ejianc.business.invest.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 合约规划变更
 *
 * @author generator
 *
 */
@TableName("ejc_invest_contract_change_plan")
public class ContractChangePlanEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @TableField(value = "bill_code")
    private String billCode; // 单据编码
    @TableField(value = "name")
    private String name; // 合约规划名称
    @TableField(value = "plan_id")
    private Long planId; // 原计划id
    @TableField(value = "org_id")
    private Long orgId; // 组织id
    @TableField(value = "org_name")
    private String orgName; // 组织名称
    @TableField(value = "bill_state")
    private Integer billState; // 单据状态（审批必须字段）
    @TableField(value = "create_user_name")
    private String createUserName; // 编制人
    @TableField(value = "update_user_name")
    private String updateUserName; // 修改者
    @TableField(value = "project_id")
    private Long projectId; // 项目名称
    @TableField(value = "project_name")
    private String projectName; // 项目名称
    @TableField(value = "subject_id")
    private Long subjectId; // 科目名称
    @TableField(value = "subject_code")
    private String subjectCode; // 科目编码
    @TableField(value = "subject_name")
    private String subjectName; // 科目名称
    @TableField(value = "target_cost")
    private BigDecimal targetCost; // 目标成本总额
    @TableField(value = "contract_rule")
    private String contractRule; // 控制规则
    @TableField(value = "bill_type_id")
    private Long billTypeId; // 合同类型
    @TableField(value = "bill_type_name")
    private String billTypeName; // 合同类型
    @TableField(value = "general_flag")
    private String generalFlag; // 是否总包
    @TableField(value = "plan_date")
    private Date planDate; // 计划签约日期
    @TableField(value = "plan_mny")
    private BigDecimal planMny; // 合约规划金额
    @TableField(value = "bid_way")
    private String bidWay; // 招标方式
    @TableField(value = "contract_scope")
    private String contractScope; // 合约范围
    @TableField(value = "contract_desc")
    private String contractDesc; // 合约说明

    @TableField(value = "before_plan_mny")
    private BigDecimal beforePlanMny;

    /**
     * 生效日期
     */
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    @TableField(value = "effective_date")
    private Date effectiveDate;

    @TableField(value="change_reason")
    private String changeReason; // 变更原因

    public String getChangeReason() {
        return changeReason;
    }

    public void setChangeReason(String changeReason) {
        this.changeReason = changeReason;
    }

    public Date getEffectiveDate() {
        return effectiveDate;
    }

    public void setEffectiveDate(Date effectiveDate) {
        this.effectiveDate = effectiveDate;
    }

    public BigDecimal getBeforePlanMny() {
        return beforePlanMny;
    }

    public void setBeforePlanMny(BigDecimal beforePlanMny) {
        this.beforePlanMny = beforePlanMny;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Long getPlanId() {
        return planId;
    }

    public void setPlanId(Long planId) {
        this.planId = planId;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }

    public String getUpdateUserName() {
        return updateUserName;
    }

    public void setUpdateUserName(String updateUserName) {
        this.updateUserName = updateUserName;
    }

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public Long getSubjectId() {
        return subjectId;
    }

    public void setSubjectId(Long subjectId) {
        this.subjectId = subjectId;
    }

    public String getSubjectCode() {
        return subjectCode;
    }

    public void setSubjectCode(String subjectCode) {
        this.subjectCode = subjectCode;
    }

    public String getSubjectName() {
        return subjectName;
    }

    public void setSubjectName(String subjectName) {
        this.subjectName = subjectName;
    }

    public BigDecimal getTargetCost() {
        return targetCost;
    }

    public void setTargetCost(BigDecimal targetCost) {
        this.targetCost = targetCost;
    }

    public String getContractRule() {
        return contractRule;
    }

    public void setContractRule(String contractRule) {
        this.contractRule = contractRule;
    }

    public Long getBillTypeId() {
        return billTypeId;
    }

    public void setBillTypeId(Long billTypeId) {
        this.billTypeId = billTypeId;
    }

    public String getBillTypeName() {
        return billTypeName;
    }

    public void setBillTypeName(String billTypeName) {
        this.billTypeName = billTypeName;
    }

    public String getGeneralFlag() {
        return generalFlag;
    }

    public void setGeneralFlag(String generalFlag) {
        this.generalFlag = generalFlag;
    }

    public Date getPlanDate() {
        return planDate;
    }

    public void setPlanDate(Date planDate) {
        this.planDate = planDate;
    }

    public BigDecimal getPlanMny() {
        return planMny;
    }

    public void setPlanMny(BigDecimal planMny) {
        this.planMny = planMny;
    }

    public String getBidWay() {
        return bidWay;
    }

    public void setBidWay(String bidWay) {
        this.bidWay = bidWay;
    }

    public String getContractScope() {
        return contractScope;
    }

    public void setContractScope(String contractScope) {
        this.contractScope = contractScope;
    }

    public String getContractDesc() {
        return contractDesc;
    }

    public void setContractDesc(String contractDesc) {
        this.contractDesc = contractDesc;
    }

}
