package com.ejianc.business.invest.controller;

import java.io.Serializable;

import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.invest.bean.WorkListEntity;
import com.ejianc.business.invest.service.IWorkListService;
import com.ejianc.business.invest.vo.WorkListVO;

/**
 * 立项工作清单
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("workList")
public class WorkListController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private IWorkListService service;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<WorkListVO> saveOrUpdate(@RequestBody WorkListVO saveOrUpdateVO) {
    	WorkListEntity entity = BeanMapper.map(saveOrUpdateVO, WorkListEntity.class);

        QueryParam param = new QueryParam();
        param.getParams().put("billCode",new Parameter(QueryParam.EQ,entity.getBillCode()));
        List<WorkListEntity> fileCaseEntities = service.queryList(param);

    	if(entity.getId() == null || entity.getId() == 0){
            if (fileCaseEntities != null && fileCaseEntities.size()>0){
                throw new BusinessException("存在重复的编号！");
            }
        }else {
            if (fileCaseEntities != null && fileCaseEntities.size()>1){
                throw new BusinessException("存在重复的编号！");
            }
        }
    	service.saveOrUpdate(entity, false);

        /**
         * 内码生成
         */
        if (entity.getLastTypeId() != null) {
            WorkListEntity pEntity = service.selectById(entity.getLastTypeId());
            String innerCode = pEntity.getInnerCode();
            entity.setInnerCode(innerCode + "-" + entity.getId().toString());

        } else {
            entity.setInnerCode(entity.getId().toString());
        }

        service.saveOrUpdate(entity);

    	WorkListVO vo = BeanMapper.map(entity, WorkListVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<WorkListVO> queryDetail(Long id) {
    	WorkListEntity entity = service.selectById(id);
    	WorkListVO vo = BeanMapper.map(entity, WorkListVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<WorkListVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (WorkListVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(WorkListVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<WorkListVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("name");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));


        List<WorkListEntity> page = service.queryList(param,false);

        List<WorkListVO> workListVOS = BeanMapper.mapList(page, WorkListVO.class);
        /**
         * 树形显示
         */
        List<WorkListVO> parentWorkType = workListVOS.stream().filter(s -> s.getLastTypeId() == null).collect(Collectors.toList());
        for (WorkListVO fileTypeVO : parentWorkType) {
            fileTypeVO.setChildren(getWorkTypeTree(fileTypeVO.getId(), workListVOS));
        }
        IPage<WorkListVO> pageData = new Page<>(param.getPageIndex(), param.getPageSize(), parentWorkType.size());
        pageData.setRecords(parentWorkType);

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<WorkListEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("WorkList-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refWorkListData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<WorkListVO>> refWorkListData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        //param.getParams().put("", new Parameter(QueryParam.SQL, " last_type_id is null"));

        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        List<WorkListEntity> page = service.queryList(param,false);

        List<WorkListVO> workListVOS = BeanMapper.mapList(page, WorkListVO.class);
        /**
         * 树形显示
         */
        List<WorkListVO> parentWorkType = workListVOS.stream().filter(s -> s.getLastTypeId() == null).collect(Collectors.toList());
        for (WorkListVO fileTypeVO : parentWorkType) {
            fileTypeVO.setChildren(getWorkTypeTree(fileTypeVO.getId(), workListVOS));
        }
        IPage<WorkListVO> pageData = new Page<>(param.getPageIndex(), param.getPageSize(), parentWorkType.size());
        pageData.setRecords(parentWorkType);

        return CommonResponse.success("查询参照数据成功！",pageData);
     }


    /**
     * 递归放入
     */
    private List<WorkListVO> getWorkTypeTree(Long parentNodeId, List<WorkListVO> records) {
        List<WorkListVO> resultList = new ArrayList<>();
        List<WorkListVO> childrenList = records.stream().filter(s -> parentNodeId.equals(s.getLastTypeId())).collect(Collectors.toList());
        if (ListUtil.isNotEmpty(childrenList)) {
            for (WorkListVO child : childrenList) {
                child.setChildren(getWorkTypeTree(child.getId(), records));
                resultList.add(child);
            }
        }
        if (ListUtil.isNotEmpty(resultList)) {
            return resultList;
        } else {
            return null;
        }
    }
}
