package com.ejianc.business.jlcost.finance.api;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.jlcost.finance.hystrix.InvoiceReceiveHystrix;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;


/**
 * 获取合同登记下游业务 开票记录、回款记录信息rpc服务
 */
@FeignClient(name = "ejc-jlcost-web", url = "${common.env.feign-client-url}", path = "ejc-jlcost-web", fallback = InvoiceReceiveHystrix.class)
public interface IInvoiceReceiveApi {

    /**
     * 获取合同登记下游业务 开票记录、回款记录信息
     *
     */
    @GetMapping(value = "/api/invoiceReceiveApi/getInvoiceReceiveDataByContractId")
    CommonResponse<JSONObject> getInvoiceReceiveDataByContractId(@RequestParam Long contractId);

    /**
     * 获取合同登记下游业务 销售、发货、验收、执行信息
     *
     */
    @PostMapping(value = "/api/invoiceReceiveApi/getInvoiceReceiveDataByContractIdList")
    CommonResponse<JSONObject> getInvoiceReceiveDataByContractIdList(@RequestBody List<Long> ids);

    /**
     * 绩效管理  初始化  开票记录、收款记录
     *
     */
    @GetMapping(value = "/api/invoiceReceiveApi/getDataPool")
    CommonResponse<JSONObject> getDataPool();

}
