package com.ejianc.business.jlcost.finance.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 资金管理-付款单
 * 
 * @author generator
 * 
 */
public class PaymentVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 单据编号
    private Integer contractType; // 合同类别 1-外协加工合同,2-成品采购合同,3-整体外包合同,4-场地或设备租赁合同,5-外部检测合同,6-外部设计合同,7-外部产品认证合同,8-劳务分包合同,9-设备或材料采购合同,10-设备租赁合同
    private Long contractId; // 合同ID
    private String contractCode; // 合同code
    private String contractName; // 合同名称
    private String projectType; // 是否属于项目 1-项目，2-公司
    private String projectTypeName; // 是否属于项目 1-项目，2-公司
    private Long projectId; // 项目ID
    private String projectCode; // 项目code
    private String projectName; // 项目名称
    private Long customerId; // 合同甲方Id
    private String customerName; // 合同甲方名称
    private Long supplierId; // 合同乙方Id
    private String supplierName; // 合同乙方名称
    private Integer paymentType; // 付款类型 1-预付款,2-过程结算款,3-质保金,4-其他
    private String paymentMethodId; // 付款方式
    private String paymentMethodName; // 付款方式名称
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date paymentDate; // 付款日期
    private BigDecimal paymentTaxMny; // 本期付款金额(含税)
    private BigDecimal historyPaymentTaxMny; // 不含本期累计付款金额(含税)
    private BigDecimal totalPaymentTaxMny; // 累计付款金额(含税)
    private BigDecimal totalSettleTaxMny; // 累计结算金额(含税)
    private BigDecimal totalInvoiceTaxMny; // 累计收票金额(含税)
    private BigDecimal contractTaxMny; // 合同金额
    private BigDecimal totalContractTaxMny; // 合同金额
    private BigDecimal paymentRate; // 累计付款比例
    private BigDecimal projectTotalIncome; // 项目累计收款金额
    private BigDecimal projectIncomeRate; // 项目累计收款比例
    private Long orgId; // 组织ID
    private String orgCode; // 组织code
    private String orgName; // 组织名称
    private Long parentOrgId; // 项目部上级组织ID(区域名称)
    private String parentOrgCode; // 项目部上级组织code
    private String parentOrgName; // 项目部上级组织名称
    private Long employeeId; // 经办人
    private String employeeName; // 经办人名称
    private Long departmentId; // 经办部门
    private String departmentName; // 经办部门名称
    private String memo; // 备注
    private Integer billState; // 单据状态（审批必须字段）
    private String billStateName; // 单据状态翻译字段
    private String contractTypeName; // 合同类别翻译字段
    private String paymentTypeName; // 付款类型翻译字段

    private BigDecimal financeMny;

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public Integer getContractType() {
        return contractType;
    }

    public void setContractType(Integer contractType) {
        this.contractType = contractType;
    }

    @ReferSerialTransfer(referCode = "payout_contract")
    public Long getContractId() {
        return contractId;
    }

    @ReferDeserialTransfer
    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }

    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }

    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }

    public String getProjectType() {
        return projectType;
    }

    public void setProjectType(String projectType) {
        this.projectType = projectType;
    }

    public String getProjectTypeName() {
        return projectTypeName;
    }

    public void setProjectTypeName(String projectTypeName) {
        this.projectTypeName = projectTypeName;
    }

    @ReferSerialTransfer(referCode = "project-archive")
    public Long getProjectId() {
        return projectId;
    }

    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    @ReferSerialTransfer(referCode = "support-customer")
    public Long getCustomerId() {
        return customerId;
    }

    @ReferDeserialTransfer
    public void setCustomerId(Long customerId) {
        this.customerId = customerId;
    }

    public String getCustomerName() {
        return customerName;
    }

    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }

    @ReferSerialTransfer(referCode = "support-supplier")
    public Long getSupplierId() {
        return supplierId;
    }

    @ReferDeserialTransfer
    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }

    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }

    public Integer getPaymentType() {
        return paymentType;
    }

    public void setPaymentType(Integer paymentType) {
        this.paymentType = paymentType;
    }

    @ReferSerialTransfer(referCode="support-defdoc")
    public String  getPaymentMethodId() {
        return paymentMethodId;
    }

    @ReferDeserialTransfer
    public void setPaymentMethodId(String  paymentMethodId) {
        this.paymentMethodId = paymentMethodId;
    }

    public String getPaymentMethodName() {
        return paymentMethodName;
    }

    public void setPaymentMethodName(String paymentMethodName) {
        this.paymentMethodName = paymentMethodName;
    }

    public Date getPaymentDate() {
        return paymentDate;
    }

    public void setPaymentDate(Date paymentDate) {
        this.paymentDate = paymentDate;
    }

    public BigDecimal getPaymentTaxMny() {
        return paymentTaxMny;
    }

    public void setPaymentTaxMny(BigDecimal paymentTaxMny) {
        this.paymentTaxMny = paymentTaxMny;
    }

    public BigDecimal getHistoryPaymentTaxMny() {
        return historyPaymentTaxMny;
    }

    public void setHistoryPaymentTaxMny(BigDecimal historyPaymentTaxMny) {
        this.historyPaymentTaxMny = historyPaymentTaxMny;
    }

    public BigDecimal getTotalPaymentTaxMny() {
        return totalPaymentTaxMny;
    }

    public void setTotalPaymentTaxMny(BigDecimal totalPaymentTaxMny) {
        this.totalPaymentTaxMny = totalPaymentTaxMny;
    }

    public BigDecimal getTotalSettleTaxMny() {
        return totalSettleTaxMny;
    }

    public void setTotalSettleTaxMny(BigDecimal totalSettleTaxMny) {
        this.totalSettleTaxMny = totalSettleTaxMny;
    }

    public BigDecimal getTotalInvoiceTaxMny() {
        return totalInvoiceTaxMny;
    }

    public void setTotalInvoiceTaxMny(BigDecimal totalInvoiceTaxMny) {
        this.totalInvoiceTaxMny = totalInvoiceTaxMny;
    }

    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }

    public BigDecimal getTotalContractTaxMny() {
        return totalContractTaxMny;
    }

    public void setTotalContractTaxMny(BigDecimal totalContractTaxMny) {
        this.totalContractTaxMny = totalContractTaxMny;
    }

    public BigDecimal getPaymentRate() {
        return paymentRate;
    }

    public void setPaymentRate(BigDecimal paymentRate) {
        this.paymentRate = paymentRate;
    }

    public BigDecimal getProjectTotalIncome() {
        return projectTotalIncome;
    }

    public void setProjectTotalIncome(BigDecimal projectTotalIncome) {
        this.projectTotalIncome = projectTotalIncome;
    }

    public BigDecimal getProjectIncomeRate() {
        return projectIncomeRate;
    }

    public void setProjectIncomeRate(BigDecimal projectIncomeRate) {
        this.projectIncomeRate = projectIncomeRate;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }

    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }

    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }

    @ReferSerialTransfer(referCode = "idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }

    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    @ReferSerialTransfer(referCode = "idm-dept")
    public Long getDepartmentId() {
        return departmentId;
    }

    @ReferDeserialTransfer
    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }

    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public String getContractTypeName() {
        return contractTypeName;
    }

    public void setContractTypeName(String contractTypeName) {
        this.contractTypeName = contractTypeName;
    }

    public String getPaymentTypeName() {
        return paymentTypeName;
    }

    public void setPaymentTypeName(String paymentTypeName) {
        this.paymentTypeName = paymentTypeName;
    }

    public BigDecimal getFinanceMny() {
        return financeMny;
    }

    public void setFinanceMny(BigDecimal financeMny) {
        this.financeMny = financeMny;
    }
}
