package com.ejianc.business.jlcost.finance.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.business.jlcost.finance.vo.ReimburseInfoVO;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 资金管理-借款报销
 *
 * @author generator
 */
public class ReimburseVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private String billCode; // 单据编码
    private Long applyId; // 申请Id
    private String applyCode; // 申请编码
    private Long projectId; // 项目
    private String projectName; // 项目名称
    private String projectCode; // 项目编码
    private Long orgId; // 组织
    private String orgCode; // 组织编码
    private String orgName; // 组织名称
    private Long parentOrgId; // 项目部上级组织Id（区域名称）
    private String parentOrgName; // 项目部上级组织名称
    private String parentOrgCode; // 项目部上级组织编码
    private BigDecimal applyMny; // 申请金额
    private BigDecimal cumulativeMny; // 已报销金额
    private BigDecimal historyMny; // 已报销金额(不含本次)
    private BigDecimal surplusMny; // 剩余可报销金额
    private BigDecimal reimburseMny; // 本次报销金额
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date reimburseDate; // 报销日期
    private Long employeeId; // 经办人
    private String employeeName; // 经办人名称
    private Long deptId; // 经办部门
    private String deptName; // 经办部门名称
    private String memo; // 备注
    private Integer billState; // 单据状态
    private String billStateName;

    private List<ReimburseInfoVO> reimburseInfoList = new ArrayList<>(); // 资金管理-借款报销-子表

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    @ReferSerialTransfer(referCode = "LoadApplyCode")
    public Long getApplyId() {
        return applyId;
    }

    @ReferDeserialTransfer
    public void setApplyId(Long applyId) {
        this.applyId = applyId;
    }

    public String getApplyCode() {
        return applyCode;
    }

    public void setApplyCode(String applyCode) {
        this.applyCode = applyCode;
    }

    @ReferSerialTransfer(referCode = "project-archive")
    public Long getProjectId() {
        return projectId;
    }

    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }

    public BigDecimal getApplyMny() {
        return applyMny;
    }

    public void setApplyMny(BigDecimal applyMny) {
        this.applyMny = applyMny;
    }

    public BigDecimal getCumulativeMny() {
        return cumulativeMny;
    }

    public void setCumulativeMny(BigDecimal cumulativeMny) {
        this.cumulativeMny = cumulativeMny;
    }

    public BigDecimal getSurplusMny() {
        return surplusMny;
    }

    public void setSurplusMny(BigDecimal surplusMny) {
        this.surplusMny = surplusMny;
    }

    public BigDecimal getReimburseMny() {
        return reimburseMny;
    }

    public void setReimburseMny(BigDecimal reimburseMny) {
        this.reimburseMny = reimburseMny;
    }

    public Date getReimburseDate() {
        return reimburseDate;
    }

    public void setReimburseDate(Date reimburseDate) {
        this.reimburseDate = reimburseDate;
    }

    @ReferSerialTransfer(referCode = "idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }

    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    @ReferSerialTransfer(referCode = "idm-dept")
    public Long getDeptId() {
        return deptId;
    }

    @ReferDeserialTransfer
    public void setDeptId(Long deptId) {
        this.deptId = deptId;
    }

    public String getDeptName() {
        return deptName;
    }

    public void setDeptName(String deptName) {
        this.deptName = deptName;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public List<ReimburseInfoVO> getReimburseInfoList() {
        return reimburseInfoList;
    }

    public void setReimburseInfoList(List<ReimburseInfoVO> reimburseInfoList) {
        this.reimburseInfoList = reimburseInfoList;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public BigDecimal getHistoryMny() {
        return historyMny;
    }

    public void setHistoryMny(BigDecimal historyMny) {
        this.historyMny = historyMny;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }

    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }

    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
}
