package com.ejianc.business.jlcost.payout.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 支出结算-主表
 *
 * @author generator
 */
public class SettleVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private String billCode; // 单据编码
    private Long contractId; // 合同ID
    private String contractCode; // 合同编码
    private String contractName; // 合同名称
    private Long projectId; // 项目Id
    private String projectCode; // 项目code
    private String projectName; // 项目名称
    private Long orgId; // 项目部Id
    private String orgName; // 项目部名称
    private String orgCode; // 项目部编码
    private Long parentOrgId; // 项目部上级组织Id
    private String parentOrgName; // 项目部上级组织名称
    private String parentOrgCode; // 项目部上级组织编码
    private Long customerId; // 合同甲方Id
    private String customerName; // 合同甲方名称
    private Long supplierId; // 合同乙方Id
    private String supplierName; // 合同乙方名称
    private BigDecimal contractTaxMny; // 合同金额
    private BigDecimal contractMny; // 合同金额（无税）
    private BigDecimal contractTax; // 合同税额
    private BigDecimal contractTaxRate; // 合同税率
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date settleDate; // 结算日期
    private Integer settleType; // 结算类型1-过程结算2-最终结算
    private Long employeeId; // 经办人
    private String employeeName; // 经办人名称
    private Long departmentId; // 经办部门
    private String departmentName; // 经办部门名称
    private Integer billState; // 单据状态
    private BigDecimal settleMny; // 本期结算金额(无税)
    private BigDecimal settleTaxMny; // 本期结算金额
    private BigDecimal settleTax; // 本期结算税额
    private BigDecimal sumSettleMny; // 累计结算金额(不含本期)(无税)
    private BigDecimal sumSettleTaxMny; // 累计结算金额(不含本期)
    private BigDecimal sumSettleAllMny; // 累计结算金额(无税)
    private BigDecimal sumSettleAllTaxMny; // 累计结算金额
    private Long productId; // 产品ID
    private String productName; // 产品名称
    private String memo; // 备注
    private Integer settleBillType; // 结算单类型 1-外协加工,2-成品采购,3-整体外包,4-场地或设备租赁,5-外部检测,6-外部设计,7-外部产品认证,8-劳务分包,9-设备或材料采购,10-设备租赁
    private String projectType; // 是否属于项目 1-项目，2-公司
    private String billStateName;

    private List<SettleDetailVO> detailList = new ArrayList<>(); // 支出结算-明细

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    @ReferSerialTransfer(referCode = "payout_contract")
    public Long getContractId() {
        return contractId;
    }
    @ReferDeserialTransfer
    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }

    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }

    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }

    @ReferSerialTransfer(referCode = "project-archive")
    public Long getProjectId() {
        return projectId;
    }

    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }

    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }

    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }

    @ReferSerialTransfer(referCode = "support-customer")
    public Long getCustomerId() {
        return customerId;
    }
    @ReferDeserialTransfer
    public void setCustomerId(Long customerId) {
        this.customerId = customerId;
    }

    public String getCustomerName() {
        return customerName;
    }

    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }

    @ReferSerialTransfer(referCode = "support-supplier")
    public Long getSupplierId() {
        return supplierId;
    }
    @ReferDeserialTransfer
    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }

    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }

    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }

    public BigDecimal getContractMny() {
        return contractMny;
    }

    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }

    public BigDecimal getContractTax() {
        return contractTax;
    }

    public void setContractTax(BigDecimal contractTax) {
        this.contractTax = contractTax;
    }

    public BigDecimal getContractTaxRate() {
        return contractTaxRate;
    }

    public void setContractTaxRate(BigDecimal contractTaxRate) {
        this.contractTaxRate = contractTaxRate;
    }

    public Date getSettleDate() {
        return settleDate;
    }

    public void setSettleDate(Date settleDate) {
        this.settleDate = settleDate;
    }

    public Integer getSettleType() {
        return settleType;
    }

    public void setSettleType(Integer settleType) {
        this.settleType = settleType;
    }

    @ReferSerialTransfer(referCode="idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }

    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    public Long getDepartmentId() {
        return departmentId;
    }

    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }

    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public BigDecimal getSettleMny() {
        return settleMny;
    }

    public void setSettleMny(BigDecimal settleMny) {
        this.settleMny = settleMny;
    }

    public BigDecimal getSettleTaxMny() {
        return settleTaxMny;
    }

    public void setSettleTaxMny(BigDecimal settleTaxMny) {
        this.settleTaxMny = settleTaxMny;
    }

    public BigDecimal getSettleTax() {
        return settleTax;
    }

    public void setSettleTax(BigDecimal settleTax) {
        this.settleTax = settleTax;
    }

    public BigDecimal getSumSettleMny() {
        return sumSettleMny;
    }

    public void setSumSettleMny(BigDecimal sumSettleMny) {
        this.sumSettleMny = sumSettleMny;
    }

    public BigDecimal getSumSettleTaxMny() {
        return sumSettleTaxMny;
    }

    public void setSumSettleTaxMny(BigDecimal sumSettleTaxMny) {
        this.sumSettleTaxMny = sumSettleTaxMny;
    }

    public BigDecimal getSumSettleAllMny() {
        return sumSettleAllMny;
    }

    public void setSumSettleAllMny(BigDecimal sumSettleAllMny) {
        this.sumSettleAllMny = sumSettleAllMny;
    }

    public BigDecimal getSumSettleAllTaxMny() {
        return sumSettleAllTaxMny;
    }

    public void setSumSettleAllTaxMny(BigDecimal sumSettleAllTaxMny) {
        this.sumSettleAllTaxMny = sumSettleAllTaxMny;
    }

    @ReferSerialTransfer(referCode="subject-project-wbs-ref")
    public Long getProductId() {
        return productId;
    }

    @ReferDeserialTransfer
    public void setProductId(Long productId) {
        this.productId = productId;
    }

    public String getProductName() {
        return productName;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public Integer getSettleBillType() {
        return settleBillType;
    }

    public void setSettleBillType(Integer settleBillType) {
        this.settleBillType = settleBillType;
    }

    public String getProjectType() {
        return projectType;
    }

    public void setProjectType(String projectType) {
        this.projectType = projectType;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public List<SettleDetailVO> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<SettleDetailVO> detailList) {
        this.detailList = detailList;
    }
}
