package com.ejianc.business.jlcost.cost.api;

import com.ejianc.business.jlcost.cost.hystrix.TargetHystrix;
import com.ejianc.business.jlcost.cost.vo.QueryTargetDataVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;


/**
 * 目标成本数据查询服务
 */
@FeignClient(name = "ejc-jlcost-web", url = "${common.env.feign-client-url}", path = "ejc-jlcost-web", fallback = TargetHystrix.class)
public interface ITargetApi {
    /**
     * 获项目下各人工工时汇总
     * @return
     */
    @GetMapping(value = "/api/targetApi/getLaborTimeByProjectIds")
    CommonResponse<List<QueryTargetDataVO>> getLaborTimeByProjectIds(@RequestParam(value = "projectIds") List<Long> projectIds, @RequestParam(value = "productIds") List<Long> productIds);

    /**
     * 获取零件材料数据
     * @return
     */
    @GetMapping(value = "/api/targetApi/getMaterialDataByMaterialIds")
    CommonResponse<List<QueryTargetDataVO>> getMaterialDataByMaterialIds(@RequestParam(value = "projectId") Long projectId, @RequestParam(value = "productId") Long productId, @RequestParam(value = "materialIds") List<Long> materialIds);

    /**
     * 获取项目下各项目费用合计
     * @return
     */
    @GetMapping(value = "/api/targetApi/getTargetDataByProjectId")
    CommonResponse<List<QueryTargetDataVO>> getTargetDataByProjectId(@RequestParam(value = "projectId") Long projectId);


}
