package com.ejianc.business.jlcost.cost.vo;

import java.util.Date;
import java.math.*;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 成本管理-其他费用单明细
 * 
 * @author generator
 * 
 */
public class OtherDetailVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Long otherId; // 主表ID
    private Long costTypeId; // 费用类别id：0，差旅费，1、招待费，2、运输费，3、其他
    private String costTypeName; // 费用类别name
    private BigDecimal costAmount; // 费用金额
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date costDate; // 费用发生日期
    private String memo; // 备注
    

    public Long getOtherId() {
        return otherId;
    }

    public void setOtherId(Long otherId) {
        this.otherId = otherId;
    }
    @ReferSerialTransfer(referCode="support-defdoc")
    public Long getCostTypeId() {
        return costTypeId;
    }
    @ReferDeserialTransfer
    public void setCostTypeId(Long costTypeId) {
        this.costTypeId = costTypeId;
    }
    public String getCostTypeName() {
        return costTypeName;
    }

    public void setCostTypeName(String costTypeName) {
        this.costTypeName = costTypeName;
    }
    public BigDecimal getCostAmount() {
        return costAmount;
    }

    public void setCostAmount(BigDecimal costAmount) {
        this.costAmount = costAmount;
    }
    public Date getCostDate() {
        return costDate;
    }

    public void setCostDate(Date costDate) {
        this.costDate = costDate;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    
}
