package com.ejianc.business.jlcost.cost.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;


/**
 * 成本管理-工厂生产单价设置 
 * 
 * @author generator
 * 
 */
public class ProductionPriceVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Long orgId; // 组织ID
    private String orgCode; // 组织code
    private String orgName; // 组织名称
    private BigDecimal labourPrice; // 人工费平均工时单价
    private BigDecimal productionPrice; // 制作费平均工时单价
    private String memo; // 备注
    

    @ReferSerialTransfer(referCode = "idm-org")
    public Long getOrgId() {
        return orgId;
    }

    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public BigDecimal getLabourPrice() {
        return labourPrice;
    }

    public void setLabourPrice(BigDecimal labourPrice) {
        this.labourPrice = labourPrice;
    }
    public BigDecimal getProductionPrice() {
        return productionPrice;
    }

    public void setProductionPrice(BigDecimal productionPrice) {
        this.productionPrice = productionPrice;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    
}
