package com.ejianc.business.jlcost.cost.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 成本管理-项目利润分析
 * 
 * @author generator
 * 
 */
public class ProjectRecordVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private Long projectId; // 项目Id
    private String projectName; // 项目名称
    private Long orgId; // 项目部Id

    private BigDecimal contractTaxMny; // 销售合同总金额
    private BigDecimal settleTaxMny; // 对甲结算金额
    private BigDecimal costMny; // 目标成本总金额
    private BigDecimal sjMny; // 实际成本总金额
    private BigDecimal planProfitMny; // 目标利润
    private BigDecimal sjProfitMny; // 实际利润
    private BigDecimal planProfitScale; // 目标利润率(%)
    private BigDecimal sjProfitScale; // 实际利润率(%)


    private Integer projectStatus; // 项目阶段：1、商机阶段 2、投标阶段 3、未中标 4、已中标 5、合同阶段 6、生产阶段 7、供货阶段 8、结算阶段 9、完工
    private String projectStatusName; // 项目阶段：1、商机阶段 2、投标阶段 3、未中标 4、已中标 5、合同阶段 6、生产阶段 7、供货阶段 8、结算阶段 9、完工
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date projectDate; // 立项日期
    private Integer type;//类型 1-销售合同 2- 对甲结算 3-目标成本 4-实际成本
    private BigDecimal mny; // 金额

    public BigDecimal getMny() {
        return mny;
    }

    public void setMny(BigDecimal mny) {
        this.mny = mny;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }

    public BigDecimal getSettleTaxMny() {
        return settleTaxMny;
    }

    public void setSettleTaxMny(BigDecimal settleTaxMny) {
        this.settleTaxMny = settleTaxMny;
    }

    public BigDecimal getCostMny() {
        return costMny;
    }

    public void setCostMny(BigDecimal costMny) {
        this.costMny = costMny;
    }

    public BigDecimal getSjMny() {
        return sjMny;
    }

    public void setSjMny(BigDecimal sjMny) {
        this.sjMny = sjMny;
    }

    public BigDecimal getPlanProfitMny() {
        return planProfitMny;
    }

    public void setPlanProfitMny(BigDecimal planProfitMny) {
        this.planProfitMny = planProfitMny;
    }

    public BigDecimal getSjProfitMny() {
        return sjProfitMny;
    }

    public void setSjProfitMny(BigDecimal sjProfitMny) {
        this.sjProfitMny = sjProfitMny;
    }

    public BigDecimal getPlanProfitScale() {
        return planProfitScale;
    }

    public void setPlanProfitScale(BigDecimal planProfitScale) {
        this.planProfitScale = planProfitScale;
    }

    public BigDecimal getSjProfitScale() {
        return sjProfitScale;
    }

    public void setSjProfitScale(BigDecimal sjProfitScale) {
        this.sjProfitScale = sjProfitScale;
    }

    public Integer getProjectStatus() {
        return projectStatus;
    }

    public void setProjectStatus(Integer projectStatus) {
        this.projectStatus = projectStatus;
    }

    public Date getProjectDate() {
        return projectDate;
    }

    public void setProjectDate(Date projectDate) {
        this.projectDate = projectDate;
    }

    public String getProjectStatusName() {
        return projectStatusName;
    }

    public void setProjectStatusName(String projectStatusName) {
        this.projectStatusName = projectStatusName;
    }
}
