package com.ejianc.business.jlcost.cost.enums;

import com.ejianc.foundation.share.consts.ArchiveProjectStatusEnum;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 费用类型
 * 0-材料费（零件） 1-人工费（零件） 2-制作费（产品）3-专项费（产品）4-外协加工费（产品）5-外购产品费（产品）
 * 6-现场施工费（项目）7-现场制作费（项目）8-外部设计费（项目）9-运费（项目）10-整体外包费用（项目）11-其他费用（项目）
 */
public enum CostTypeEnum {

    材料费(0, "材料费（零件）"),
    人工费(1, "人工费（零件）"),
    制作费(2, "制作费（产品）"),
    专项费(3, "专项费（产品）"),
    外协加工费(4, "外协加工费（产品）"),
    外购产品费(5, "外购产品费（产品）"),
    现场施工费(6, "现场施工费（项目）"),
    现场制作费(7, "现场制作费（项目）"),
    外部设计费(8, "外部设计费（项目）"),
    运费(9, "运费（项目）"),
    整体外包费用(10, "整体外包费用（项目）"),
    其他费用(11, "其他费用（项目）");

    private Integer code;

    private String name;

    private static Map<Integer, ArchiveProjectStatusEnum> enumMap = new HashMap();

    private CostTypeEnum(Integer code, String name) {
        this.code = code;
        this.name = name;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }



    public static void setEnumMap(Map<Integer, ArchiveProjectStatusEnum> enumMap) {
        CostTypeEnum.enumMap = enumMap;
    }

    public static ArchiveProjectStatusEnum getByCode(Integer code) {
        return (ArchiveProjectStatusEnum)enumMap.get(code);
    }

    static {
        enumMap = (Map) EnumSet.allOf(ArchiveProjectStatusEnum.class).stream().collect(Collectors.toMap(ArchiveProjectStatusEnum::getCode, Function.identity(), (k1, k2) -> {
            return k2;
        }));
    }
}
