package com.ejianc.business.jlcost.cost.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;


/**
 * 成本管理-产品制作费用单明细
 * 
 * @author generator
 * 
 */
public class ProductDetailVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Long pId; // 主表ID
    private Long projectId; // 项目id
    private String projectName; // 项目名称
    private Long productId; // 产品id
    private String productName; // 产品name
    private BigDecimal laborMny; // 人工费
    private BigDecimal electricMny; // 电费
    private BigDecimal fuelMny; // 燃料费
    private BigDecimal depreciationMny; // 折旧费
    private BigDecimal otherMakeMny; // 其他制造费
    private BigDecimal interiorProcessMny; // 内协加工费
    private BigDecimal totalMny; // 合计
    private BigDecimal otherMny; // 其他费用
    private String memo; // 备注
    

    public Long getPId() {
        return pId;
    }

    public void setPId(Long pId) {
        this.pId = pId;
    }
    @ReferSerialTransfer(referCode = "project-archive")
    public Long getProjectId() {
        return projectId;
    }
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    @ReferSerialTransfer(referCode = "subject-project-wbs-ref")
    public Long getProductId() {
        return productId;
    }
    @ReferDeserialTransfer
    public void setProductId(Long productId) {
        this.productId = productId;
    }
    public String getProductName() {
        return productName;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }
    public BigDecimal getLaborMny() {
        return laborMny;
    }

    public void setLaborMny(BigDecimal laborMny) {
        this.laborMny = laborMny;
    }
    public BigDecimal getElectricMny() {
        return electricMny;
    }

    public void setElectricMny(BigDecimal electricMny) {
        this.electricMny = electricMny;
    }
    public BigDecimal getFuelMny() {
        return fuelMny;
    }

    public void setFuelMny(BigDecimal fuelMny) {
        this.fuelMny = fuelMny;
    }
    public BigDecimal getDepreciationMny() {
        return depreciationMny;
    }

    public void setDepreciationMny(BigDecimal depreciationMny) {
        this.depreciationMny = depreciationMny;
    }
    public BigDecimal getOtherMakeMny() {
        return otherMakeMny;
    }

    public void setOtherMakeMny(BigDecimal otherMakeMny) {
        this.otherMakeMny = otherMakeMny;
    }
    public BigDecimal getInteriorProcessMny() {
        return interiorProcessMny;
    }

    public void setInteriorProcessMny(BigDecimal interiorProcessMny) {
        this.interiorProcessMny = interiorProcessMny;
    }
    public BigDecimal getTotalMny() {
        return totalMny;
    }

    public void setTotalMny(BigDecimal totalMny) {
        this.totalMny = totalMny;
    }
    public BigDecimal getOtherMny() {
        return otherMny;
    }

    public void setOtherMny(BigDecimal otherMny) {
        this.otherMny = otherMny;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    
}
