package com.ejianc.business.jlcost.cost.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.business.jlcost.cost.vo.TargetChangeDetailVO;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 成本管理-目标成本-变更
 * 
 * @author generator
 * 
 */
public class TargetChangeVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Long targetId; // 目标成本主键
    private Integer billState; // 单据状态
    private String billCode; // 单据编码
    private Long projectId; // 项目Id
    private String projectCode; // 项目code
    private String projectName; // 项目名称
    private Long orgId; // 项目部Id
    private String orgName; // 项目部名称
    private String orgCode; // 项目部编码
    private Long parentOrgId; // 项目部上级组织Id（区域名称）
    private String parentOrgName; // 项目部上级组织名称
    private String parentOrgCode; // 项目部上级组织编码
    private Long employeeId; // 经办人
    private String employeeName; // 经办人名称
    private Long departmentId; // 经办部门
    private String departmentName; // 经办部门名称
    private Long changeEmployeeId; // 变更经办人id
    private String changeEmployeeName; // 变更经办人
    private Long changeDepartmentId; // 变更经办人部门id
    private String changeDepartmentName; // 变更经办人部门
    private BigDecimal contractTaxMny; // 销售合同总金额
    private BigDecimal contractMny; // 销售合同总金额（无税）
    private BigDecimal costMny; // 目标成本总金额
    private BigDecimal beforeCostMny; // 变更前目标成本总金额
    private BigDecimal planProfitMny; // 预计利润
    private BigDecimal materialMny; // 材料费
    private BigDecimal laborMny; // 人工费
    private BigDecimal makeMny; // 制作费
    private BigDecimal specialMny; // 专项费
    private BigDecimal wxjgMny; // 外协加工费
    private BigDecimal wgcpMny; // 外购产品费
    private BigDecimal xcsgMny; // 现场施工费
    private BigDecimal xczzMny; // 现场制作费
    private BigDecimal wbsjMny; // 外部设计费
    private BigDecimal transportMny; // 运费
    private BigDecimal ztwbMny; // 整体外包费
    private BigDecimal otherMny; // 其他费用
    private String memo; // 备注
    private Integer changeStatus; // 变更状态(1-未变更 2-变更中 3-已变更)
    private String changeReason; // 变更原因
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date effectiveDate; // 生效日期

    private Integer changeType; // 变更类型(0-设计变更、1-其他)

    private Long recordId;//记录id
    
    private List<TargetChangeDetailVO> detailList = new ArrayList<>(); // 成本管理-目标成本-变更子表

    public Long getTargetId() {
        return targetId;
    }

    public void setTargetId(Long targetId) {
        this.targetId = targetId;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    @ReferSerialTransfer(referCode = "project-archive")
    public Long getProjectId() {
        return projectId;
    }
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }

    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    @ReferSerialTransfer(referCode = "idm-dept")
    public Long getDepartmentId() {
        return departmentId;
    }

    @ReferDeserialTransfer
    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }

    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getChangeEmployeeId() {
        return changeEmployeeId;
    }
    @ReferDeserialTransfer
    public void setChangeEmployeeId(Long changeEmployeeId) {
        this.changeEmployeeId = changeEmployeeId;
    }
    public String getChangeEmployeeName() {
        return changeEmployeeName;
    }

    public void setChangeEmployeeName(String changeEmployeeName) {
        this.changeEmployeeName = changeEmployeeName;
    }
    @ReferSerialTransfer(referCode = "idm-dept")
    public Long getChangeDepartmentId() {
        return changeDepartmentId;
    }
    @ReferDeserialTransfer
    public void setChangeDepartmentId(Long changeDepartmentId) {
        this.changeDepartmentId = changeDepartmentId;
    }
    public String getChangeDepartmentName() {
        return changeDepartmentName;
    }

    public void setChangeDepartmentName(String changeDepartmentName) {
        this.changeDepartmentName = changeDepartmentName;
    }
    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }
    public BigDecimal getContractMny() {
        return contractMny;
    }

    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }
    public BigDecimal getCostMny() {
        return costMny;
    }

    public void setCostMny(BigDecimal costMny) {
        this.costMny = costMny;
    }
    public BigDecimal getBeforeCostMny() {
        return beforeCostMny;
    }

    public void setBeforeCostMny(BigDecimal beforeCostMny) {
        this.beforeCostMny = beforeCostMny;
    }
    public BigDecimal getPlanProfitMny() {
        return planProfitMny;
    }

    public void setPlanProfitMny(BigDecimal planProfitMny) {
        this.planProfitMny = planProfitMny;
    }
    public BigDecimal getMaterialMny() {
        return materialMny;
    }

    public void setMaterialMny(BigDecimal materialMny) {
        this.materialMny = materialMny;
    }
    public BigDecimal getLaborMny() {
        return laborMny;
    }

    public void setLaborMny(BigDecimal laborMny) {
        this.laborMny = laborMny;
    }
    public BigDecimal getMakeMny() {
        return makeMny;
    }

    public void setMakeMny(BigDecimal makeMny) {
        this.makeMny = makeMny;
    }
    public BigDecimal getSpecialMny() {
        return specialMny;
    }

    public void setSpecialMny(BigDecimal specialMny) {
        this.specialMny = specialMny;
    }
    public BigDecimal getWxjgMny() {
        return wxjgMny;
    }

    public void setWxjgMny(BigDecimal wxjgMny) {
        this.wxjgMny = wxjgMny;
    }
    public BigDecimal getWgcpMny() {
        return wgcpMny;
    }

    public void setWgcpMny(BigDecimal wgcpMny) {
        this.wgcpMny = wgcpMny;
    }
    public BigDecimal getXcsgMny() {
        return xcsgMny;
    }

    public void setXcsgMny(BigDecimal xcsgMny) {
        this.xcsgMny = xcsgMny;
    }
    public BigDecimal getXczzMny() {
        return xczzMny;
    }

    public void setXczzMny(BigDecimal xczzMny) {
        this.xczzMny = xczzMny;
    }
    public BigDecimal getWbsjMny() {
        return wbsjMny;
    }

    public void setWbsjMny(BigDecimal wbsjMny) {
        this.wbsjMny = wbsjMny;
    }
    public BigDecimal getTransportMny() {
        return transportMny;
    }

    public void setTransportMny(BigDecimal transportMny) {
        this.transportMny = transportMny;
    }
    public BigDecimal getZtwbMny() {
        return ztwbMny;
    }

    public void setZtwbMny(BigDecimal ztwbMny) {
        this.ztwbMny = ztwbMny;
    }
    public BigDecimal getOtherMny() {
        return otherMny;
    }

    public void setOtherMny(BigDecimal otherMny) {
        this.otherMny = otherMny;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Integer getChangeStatus() {
        return changeStatus;
    }

    public void setChangeStatus(Integer changeStatus) {
        this.changeStatus = changeStatus;
    }
    public String getChangeReason() {
        return changeReason;
    }

    public void setChangeReason(String changeReason) {
        this.changeReason = changeReason;
    }
    public Date getEffectiveDate() {
        return effectiveDate;
    }

    public void setEffectiveDate(Date effectiveDate) {
        this.effectiveDate = effectiveDate;
    }

    public List<TargetChangeDetailVO> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<TargetChangeDetailVO> detailList) {
        this.detailList = detailList;
    }

    public Long getRecordId() {
        return recordId;
    }

    public void setRecordId(Long recordId) {
        this.recordId = recordId;
    }

    public Integer getChangeType() {
        return changeType;
    }

    public void setChangeType(Integer changeType) {
        this.changeType = changeType;
    }
}
