package com.ejianc.business.jlcost.cost.vo;

import com.ejianc.foundation.share.utils.ITreeNodeB;
import com.ejianc.framework.skeleton.template.BaseVO;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;


/**
 * 成本管理-目标成本-子表
 * 
 * @author generator
 * 
 */
public class TargetReportDetailVO extends BaseVO implements ITreeNodeB{
    private static final long serialVersionUID = 1L;

    private Long targetId; // 目标成本主键
    private String code; // 清单编号
    private String name; // 清单名称
    private Integer costType; // 费用类型：0-材料费（零件） 1-人工费（零件） 2-制作费（产品）3-专项费（产品）4-外协加工费（产品）5-外购产品费（产品）6-现场施工费（项目）7-现场制作费（项目）8-外部设计费（项目）9-运费（项目）10-整体外包费用（项目）11-其他费用（项目）
    private String costTypeName; // 费用类型名称
    private String model; // 型号
    private String spec; // 特征/规格型号
    private String unit; // 单位
    private BigDecimal num; // 数量
    private BigDecimal price; // 单价
    private BigDecimal mny; // 目标成本金额
    private BigDecimal sjCostMny; // 实际成本金额
    private String detailMemo; // 备注
    private Long categoryId; // 分类id
    private String categoryName; // 分类名称
    private Long materialId; // 物资id
    private String materialName; // 物资名称
    private Long changeId; // 变更主键
    private Long changeBid; // 变更子表主键
    private Long sourceId; // 来源ID
    private Integer sourceType; // 来源类型0：项目wbs、1：手动新增、2：物料档案
    private Integer rowType; // 层类型：第一层 1-产品  2-项目费用  第二层 3-零件 4-产品费用  第三层 5-材料 6-人工费    7-其他
    private Integer rowLevel; // 层级：1-第一层  2-第二层 3-第三层

    private Long parentId; // 父级id
    private Boolean leafFlag; // 是否末级

    //树形转换需要字段
    private Long tid; // 前端生成树形主键
    private String tpid; // 前端生成树形父主键
    private List<ITreeNodeB> children;

    public BigDecimal getSjCostMny() {
        return sjCostMny;
    }

    public void setSjCostMny(BigDecimal sjCostMny) {
        this.sjCostMny = sjCostMny;
    }

    public Long getTargetId() {
        return targetId;
    }

    public void setTargetId(Long targetId) {
        this.targetId = targetId;
    }
    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
    public Integer getCostType() {
        return costType;
    }

    public void setCostType(Integer costType) {
        this.costType = costType;
    }
    public String getCostTypeName() {
        return costTypeName;
    }

    public void setCostTypeName(String costTypeName) {
        this.costTypeName = costTypeName;
    }
    public String getModel() {
        return model;
    }

    public void setModel(String model) {
        this.model = model;
    }
    public String getSpec() {
        return spec;
    }

    public void setSpec(String spec) {
        this.spec = spec;
    }
    public String getUnit() {
        return unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }
    public BigDecimal getNum() {
        return num;
    }

    public void setNum(BigDecimal num) {
        this.num = num;
    }
    public BigDecimal getPrice() {
        return price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }
    public BigDecimal getMny() {
        return mny;
    }

    public void setMny(BigDecimal mny) {
        this.mny = mny;
    }
    public String getDetailMemo() {
        return detailMemo;
    }

    public void setDetailMemo(String detailMemo) {
        this.detailMemo = detailMemo;
    }
    public Long getCategoryId() {
        return categoryId;
    }

    public void setCategoryId(Long categoryId) {
        this.categoryId = categoryId;
    }
    public String getCategoryName() {
        return categoryName;
    }

    public void setCategoryName(String categoryName) {
        this.categoryName = categoryName;
    }
    public Long getMaterialId() {
        return materialId;
    }

    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }
    public String getMaterialName() {
        return materialName;
    }

    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }
    public Long getParentId() {
        return parentId;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }
    public Boolean getLeafFlag() {
        return leafFlag;
    }

    public void setLeafFlag(Boolean leafFlag) {
        this.leafFlag = leafFlag;
    }
    public Long getChangeId() {
        return changeId;
    }

    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }
    public Long getChangeBid() {
        return changeBid;
    }

    public void setChangeBid(Long changeBid) {
        this.changeBid = changeBid;
    }
    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }
    public Integer getSourceType() {
        return sourceType;
    }

    public void setSourceType(Integer sourceType) {
        this.sourceType = sourceType;
    }
    public Integer getRowType() {
        return rowType;
    }

    public void setRowType(Integer rowType) {
        this.rowType = rowType;
    }
    public Integer getRowLevel() {
        return rowLevel;
    }

    public void setRowLevel(Integer rowLevel) {
        this.rowLevel = rowLevel;
    }

    @Override
    public Long getNodeID() {
        return getId();
    }

    @Override
    public Long getParentID() {
        return parentId;
    }

    @Override
    public List<ITreeNodeB> getChildren() {
        if (children == null) {
            children = new ArrayList<>();
        }
        return children;
    }

    public Long getTid() {
        return tid;
    }

    public void setTid(Long tid) {
        this.tid = tid;
    }

    public String getTpid() {
        return tpid;
    }

    public void setTpid(String tpid) {
        this.tpid = tpid;
    }
}
