package com.ejianc.business.jlcost.finance.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 资金管理-借款报销-子表
 *
 * @author generator
 */
public class ReimburseInfoVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private Long reimburseId; // 报销单主键
    private Long feeType; // 费用类别
    private String feeTypeName; // 费用类别名称
    private BigDecimal feeTaxMny; // 费用金额
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date feeHappenDate; // 费用发生日期
    private String feeMemo; // 备注


    public Long getReimburseId() {
        return reimburseId;
    }

    public void setReimburseId(Long reimburseId) {
        this.reimburseId = reimburseId;
    }

    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getFeeType() {
        return feeType;
    }

    @ReferDeserialTransfer
    public void setFeeType(Long feeType) {
        this.feeType = feeType;
    }

    public String getFeeTypeName() {
        return feeTypeName;
    }

    public void setFeeTypeName(String feeTypeName) {
        this.feeTypeName = feeTypeName;
    }

    public BigDecimal getFeeTaxMny() {
        return feeTaxMny;
    }

    public void setFeeTaxMny(BigDecimal feeTaxMny) {
        this.feeTaxMny = feeTaxMny;
    }

    public Date getFeeHappenDate() {
        return feeHappenDate;
    }

    public void setFeeHappenDate(Date feeHappenDate) {
        this.feeHappenDate = feeHappenDate;
    }

    public String getFeeMemo() {
        return feeMemo;
    }

    public void setFeeMemo(String feeMemo) {
        this.feeMemo = feeMemo;
    }

}
