package com.ejianc.business.jlcost.cost.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 成本管理-目标成本执行情况台账
 * 
 * @author generator
 * 
 */
public class TargetReportVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Long projectId; // 项目Id
    private String projectCode; // 项目code
    private String projectName; // 项目名称


    private BigDecimal contractTaxMny; // 销售合同总金额
    private BigDecimal contractMny; // 销售合同总金额（无税）
    private BigDecimal costMny; // 目标成本总金额
    private BigDecimal sjCostMny; // 实际成本总金额
    private BigDecimal planProfitMny; // 预计利润
    private BigDecimal sjProfitMny; // 实际利润


    private List<TargetReportDetailVO> detailList = new ArrayList<>(); // 目标成本执行情况

    private List<TargetReportCostVO> costList = new ArrayList<>();//费用类型汇总情况

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }

    public BigDecimal getContractMny() {
        return contractMny;
    }

    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }

    public BigDecimal getCostMny() {
        return costMny;
    }

    public void setCostMny(BigDecimal costMny) {
        this.costMny = costMny;
    }

    public BigDecimal getSjCostMny() {
        return sjCostMny;
    }

    public void setSjCostMny(BigDecimal sjCostMny) {
        this.sjCostMny = sjCostMny;
    }

    public BigDecimal getPlanProfitMny() {
        return planProfitMny;
    }

    public void setPlanProfitMny(BigDecimal planProfitMny) {
        this.planProfitMny = planProfitMny;
    }

    public BigDecimal getSjProfitMny() {
        return sjProfitMny;
    }

    public void setSjProfitMny(BigDecimal sjProfitMny) {
        this.sjProfitMny = sjProfitMny;
    }

    public List<TargetReportDetailVO> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<TargetReportDetailVO> detailList) {
        this.detailList = detailList;
    }

    public List<TargetReportCostVO> getCostList() {
        return costList;
    }

    public void setCostList(List<TargetReportCostVO> costList) {
        this.costList = costList;
    }
}
