package com.ejianc.business.jlcost.finance.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 资金管理-借款申请
 * 
 * @author generator
 * 
 */
public class LoadApplyVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 申请编号
    private Long projectId; // 项目
    private String projectName; // 项目名称
    private String projectCode; // 项目code
    private BigDecimal applyMny; // 申请金额
    private BigDecimal backedMny; // 已退还金额
    private BigDecimal cumulativeMny; // 已报销金额
    private Long applyEmployeeId; // 申请人
    private String applyEmployeeName; // 申请人名称
    private Long deptId; // 申请部门
    private String deptName; // 申请部门名称
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date applyDate; // 申请时间
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date predictUseTime; // 预计用款日期
    private String accountName; // 账户名
    private String bankAccount; // 银行账号
    private String bankName; // 开户行
    private Integer billState; // 单据状态
    private Long receiveWay; // 收款方式
    private String receiveWayName; // 收款方式名称
    private String memo; // 备注

    private String loanStatus;//借款状态
    private String billStateName;//单据状态

    private Integer status; // 借款状态（1:申请中 2:使用中 3:已结束）

    private Long orgId; // 组织ID
    private String orgName; // 组织名称
    private String orgCode; // 组织code
    private Long parentOrgId; // 项目部上级组织ID(区域名称)
    private String parentOrgCode; // 项目部上级组织code
    private String parentOrgName; // 项目部上级组织名称

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }

    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }

    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public String getLoanStatus() {
        return loanStatus;
    }

    public void setLoanStatus(String loanStatus) {
        this.loanStatus = loanStatus;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    @ReferSerialTransfer(referCode = "project-archive")
    public Long getProjectId() {
        return projectId;
    }
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public BigDecimal getApplyMny() {
        return applyMny;
    }

    public void setApplyMny(BigDecimal applyMny) {
        this.applyMny = applyMny;
    }
    public BigDecimal getBackedMny() {
        return backedMny;
    }

    public void setBackedMny(BigDecimal backedMny) {
        this.backedMny = backedMny;
    }
    public BigDecimal getCumulativeMny() {
        return cumulativeMny;
    }

    public void setCumulativeMny(BigDecimal cumulativeMny) {
        this.cumulativeMny = cumulativeMny;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getApplyEmployeeId() {
        return applyEmployeeId;
    }
    @ReferDeserialTransfer
    public void setApplyEmployeeId(Long applyEmployeeId) {
        this.applyEmployeeId = applyEmployeeId;
    }
    public String getApplyEmployeeName() {
        return applyEmployeeName;
    }

    public void setApplyEmployeeName(String applyEmployeeName) {
        this.applyEmployeeName = applyEmployeeName;
    }
    @ReferSerialTransfer(referCode = "idm-dept")
    public Long getDeptId() {
        return deptId;
    }
    @ReferDeserialTransfer
    public void setDeptId(Long deptId) {
        this.deptId = deptId;
    }
    public String getDeptName() {
        return deptName;
    }

    public void setDeptName(String deptName) {
        this.deptName = deptName;
    }
    public Date getApplyDate() {
        return applyDate;
    }

    public void setApplyDate(Date applyDate) {
        this.applyDate = applyDate;
    }
    public Date getPredictUseTime() {
        return predictUseTime;
    }

    public void setPredictUseTime(Date predictUseTime) {
        this.predictUseTime = predictUseTime;
    }
    public String getAccountName() {
        return accountName;
    }

    public void setAccountName(String accountName) {
        this.accountName = accountName;
    }
    public String getBankAccount() {
        return bankAccount;
    }

    public void setBankAccount(String bankAccount) {
        this.bankAccount = bankAccount;
    }
    public String getBankName() {
        return bankName;
    }

    public void setBankName(String bankName) {
        this.bankName = bankName;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getReceiveWay() {
        return receiveWay;
    }

    public void setReceiveWay(Long receiveWay) {
        this.receiveWay = receiveWay;
    }
    public String getReceiveWayName() {
        return receiveWayName;
    }

    public void setReceiveWayName(String receiveWayName) {
        this.receiveWayName = receiveWayName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    
}
