package com.ejianc.business.jlcost.finance.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 资金管理-费用报销单明细
 * 
 * @author generator
 * 
 */
public class PayReimburseDetailVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Long reimburseId; // 主表ID
    private Long costType; // 费用类别：0，差旅费，1、招待费，2、运输费，3、其他
    private BigDecimal costAmount; // 费用金额
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date costDate; // 费用发生日期
    private String memo; // 备注
    

    public Long getReimburseId() {
        return reimburseId;
    }

    public void setReimburseId(Long reimburseId) {
        this.reimburseId = reimburseId;
    }

    @ReferSerialTransfer(referCode="support-defdoc")
    public Long getCostType() {
        return costType;
    }
    @ReferDeserialTransfer
    public void setCostType(Long costType) {
        this.costType = costType;
    }
    public BigDecimal getCostAmount() {
        return costAmount;
    }

    public void setCostAmount(BigDecimal costAmount) {
        this.costAmount = costAmount;
    }
    public Date getCostDate() {
        return costDate;
    }

    public void setCostDate(Date costDate) {
        this.costDate = costDate;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    
}
