package com.ejianc.business.jlcost.payout.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.jlcost.payout.bean.ContractDetailEntity;
import com.ejianc.business.jlcost.payout.bean.ContractEntity;
import com.ejianc.business.jlcost.payout.enums.ChangeStatusEnum;
import com.ejianc.business.jlcost.payout.enums.ChangeTypeEnum;
import com.ejianc.business.jlcost.payout.enums.PayoutTypeEnum;
import com.ejianc.business.jlcost.payout.service.IContractDetailService;
import com.ejianc.business.jlcost.payout.service.IContractService;
import com.ejianc.business.jlcost.payout.vo.ContractChangeDetailVO;
import com.ejianc.business.jlcost.payout.vo.ContractChangeRecordVO;
import com.ejianc.business.jlcost.payout.vo.ContractChangeVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.jlcost.payout.mapper.ContractChangeMapper;
import com.ejianc.business.jlcost.payout.bean.ContractChangeEntity;
import com.ejianc.business.jlcost.payout.service.IContractChangeService;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

import static java.math.BigDecimal.ROUND_HALF_DOWN;

/**
 * 支出合同-变更-合同主表
 * 
 * @author generator
 * 
 */
@Service("contractChangeService")
public class ContractChangeServiceImpl extends BaseServiceImpl<ContractChangeMapper, ContractChangeEntity> implements IContractChangeService{
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    /** 外协加工合同 */
    private static final String WXJG_BILL_CODE = "WXJG_BILL_CODE";
    /** 成品采购合同 */
    private static final String CPCG_BILL_CODE = "CPCG_BILL_CODE";
    /** 整体外包合同 */
    private static final String ZTWB_BILL_CODE = "ZTWB_BILL_CODE";
    /** 场地或设备租赁合同 */
    private static final String CDZL_BILL_CODE = "CDZL_BILL_CODE";
    /** 外部检测合同 */
    private static final String WBJC_BILL_CODE = "WBJC_BILL_CODE";
    /** 外部设计合同 */
    private static final String WBSJ_BILL_CODE = "WBSJ_BILL_CODE";
    /** 外部产品认证合同 */
    private static final String WBRZ_BILL_CODE = "WBRZ_BILL_CODE";
    /** 劳务分包合同 */
    private static final String LWFB_BILL_CODE = "LWFB_BILL_CODE";
    /** 设备或材料采购合同 */
    private static final String CLCG_BILL_CODE = "CLCG_BILL_CODE";
    /** 设备租赁合同 */
    private static final String SBZL_BILL_CODE = "SBZL_BILL_CODE";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IContractService contractService;
    @Autowired
    private IContractDetailService contractDetailService;

    @Autowired
    private IContractChangeService changeService;
    @Override
    public CommonResponse<ContractChangeVO> saveOrUpdate(ContractChangeVO contractChangeVo) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        ContractChangeEntity entity = null;
        List<ContractEntity> entitiesc = null;
        List<ContractChangeEntity> entities = null;


        //变更合同只能存在一条未生效的
        LambdaQueryWrapper<ContractChangeEntity> lambdachange = Wrappers.<ContractChangeEntity>lambdaQuery();
        lambdachange.eq(ContractChangeEntity::getTenantId, tenantId);
        lambdachange.eq(ContractChangeEntity::getContractId,contractChangeVo.getContractId());
        if(contractChangeVo.getId() != null && contractChangeVo.getId() > 0) {
            lambdachange.ne(ContractChangeEntity::getId,contractChangeVo.getId());
        }
        lambdachange.ne(ContractChangeEntity::getBillState,BillStateEnum.PASSED_STATE.getBillStateCode());
        lambdachange.ne(ContractChangeEntity::getBillState,BillStateEnum.COMMITED_STATE.getBillStateCode());
        int num = super.count(lambdachange);
        if(num>0){
            throw new BusinessException("该合同已存在未生效的变更单!");
        }

        ContractEntity pcentity = contractService.selectById(contractChangeVo.getContractId());
        if(StringUtils.isEmpty(contractChangeVo.getBillCode())){
            // 合同编码生成
            entity.setBillCode(this.getContractBillCode(contractChangeVo));
        }
        if(contractChangeVo.getId() != null && contractChangeVo.getId() > 0 && changeService.getById(contractChangeVo.getId())!=null ) {
            //修改 校验合同编号唯一，变更单除去本单，合同  同时唯一
            LambdaQueryWrapper<ContractChangeEntity> lambda = Wrappers.<ContractChangeEntity>lambdaQuery();
            lambda.eq(ContractChangeEntity::getBillCode, contractChangeVo.getBillCode());
            lambda.eq(ContractChangeEntity::getTenantId, tenantId);
            lambda.ne(ContractChangeEntity::getContractId,contractChangeVo.getContractId());
            entities = super.list(lambda);

            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("tenant_id", new Parameter(QueryParam.EQ,tenantId));
            queryParam.getParams().put("bill_code", new Parameter(QueryParam.EQ,contractChangeVo.getBillCode()));
            queryParam.getParams().put("id", new Parameter(QueryParam.NE,contractChangeVo.getContractId()));
            entitiesc = contractService.queryList(queryParam,false);

            pcentity.setId(contractChangeVo.getContractId());

        }else{
            //校验合同编号是否重复
            LambdaQueryWrapper<ContractChangeEntity> lambda = Wrappers.<ContractChangeEntity>lambdaQuery();
            lambda.eq(ContractChangeEntity::getTenantId, tenantId);
            lambda.eq(ContractChangeEntity::getBillCode, contractChangeVo.getBillCode());
            lambda.ne(ContractChangeEntity::getContractId,contractChangeVo.getContractId());
            entities = super.list(lambda);
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("tenant_id", new Parameter(QueryParam.EQ,tenantId));
            queryParam.getParams().put("bill_code", new Parameter(QueryParam.EQ,contractChangeVo.getBillCode()));
            queryParam.getParams().put("id", new Parameter(QueryParam.NE,contractChangeVo.getContractId()));
            entitiesc = contractService.queryList(queryParam,false);
            //新增即点变更按钮穿透过来，此时ID为合同id
            pcentity.setId(contractChangeVo.getContractId());
            pcentity.setChangeVersion(contractChangeVo.getChangeVersion() + 1);
            contractChangeVo.setChangeVersion(contractChangeVo.getChangeVersion() + 1);
        }

        if(CollectionUtils.isNotEmpty(contractChangeVo.getContractChangeDetailList())){
            contractChangeVo.getContractChangeDetailList().forEach(vo -> {
                //变更类型1-增补，2-变更，3-中止
                if("add".equals(vo.getRowState())){
                    vo.setContractId(contractChangeVo.getContractId());
                }
                if (this.isInsertContractChange(contractChangeVo)) {
                    vo.setId(null);
                }
            });
        }
        if(CollectionUtils.isNotEmpty(contractChangeVo.getContractChangeClauseList())){
            contractChangeVo.getContractChangeClauseList().forEach(vo -> {
                if("add".equals(vo.getRowState())){
                    vo.setContractId(contractChangeVo.getContractId());
                }
                if (this.isInsertContractChange(contractChangeVo)) {
                    vo.setId(null);
                }
            });
        }
        if(CollectionUtils.isNotEmpty(entities) || CollectionUtils.isNotEmpty(entitiesc)) {
            throw new BusinessException("存在相同编码，不允许保存!");
        }
        entity = BeanMapper.map(contractChangeVo, ContractChangeEntity.class);
        super.saveOrUpdate(entity,false);
        //回写合同表
        pcentity.setChangeStatus(ChangeStatusEnum.变更中.getCode());
        pcentity.setChangingMny(entity.getContractMny());//修改变更中金额
        pcentity.setChangingTaxMny(entity.getContractTaxMny());
        pcentity.setChangeDate(entity.getChangeDate());
        pcentity.setChangeCode(entity.getBillCode());
        pcentity.setChangeId(entity.getId());
        pcentity.setChangeContractName(entity.getContractName());
        contractService.update(pcentity, new QueryWrapper<ContractEntity>().eq("id",pcentity.getId()),false);
        ContractChangeVO res = BeanMapper.map(entity, ContractChangeVO.class);
//        BigDecimal contractTaxMny = res.getContractTaxMny() == null ? BigDecimal.ZERO : res.getContractTaxMny();
//        BigDecimal beforeChangeTaxMny = pcentity.getBeforeChangeTaxMny() == null ? BigDecimal.ZERO : pcentity.getBeforeChangeTaxMny();
//        BigDecimal bb = contractTaxMny.subtract(beforeChangeTaxMny);
//        if(bb.compareTo(BigDecimal.ZERO)!=0&&beforeChangeTaxMny.compareTo(BigDecimal.ZERO)!=0){
//            res.setScale(new BigDecimal(100).multiply(bb.divide(beforeChangeTaxMny,8,ROUND_HALF_DOWN)));
//        }else{
//            res.setScale(BigDecimal.ZERO);
//        }
//        res.setBb(bb);
        return CommonResponse.success(res);
    }
    /**
     * 是否合同变更新增
     *
     * @param contractChangeVO 合同变更数据
     * @return 是否新增
     */
    private boolean isInsertContractChange(ContractChangeVO contractChangeVO) {
        return contractChangeVO.getId() == null || contractChangeVO.getId() == 0;
    }
    /**
     * 生成合同编码规则
     *
     * @param contractVo 合同vo
     * @return 生成结果
     */
    private String getContractBillCode(ContractChangeVO contractVo) {
        String contractBillCode;
        String billCodeStr = "";
        if (PayoutTypeEnum.外协加工合同.getCode().equals(contractVo.getContractType())) {
            billCodeStr = WXJG_BILL_CODE;
        }else if(PayoutTypeEnum.成品采购合同.getCode().equals(contractVo.getContractType())){
            billCodeStr = CPCG_BILL_CODE;
        }else if(PayoutTypeEnum.整体外包合同.getCode().equals(contractVo.getContractType())){
            billCodeStr = ZTWB_BILL_CODE;
        }else if(PayoutTypeEnum.场地或设备租赁合同.getCode().equals(contractVo.getContractType())){
            billCodeStr = CDZL_BILL_CODE;
        }else if(PayoutTypeEnum.外部检测合同.getCode().equals(contractVo.getContractType())){
            billCodeStr = WBJC_BILL_CODE;
        }else if(PayoutTypeEnum.外部设计合同.getCode().equals(contractVo.getContractType())){
            billCodeStr = WBSJ_BILL_CODE;
        }else if(PayoutTypeEnum.外部产品认证合同.getCode().equals(contractVo.getContractType())){
            billCodeStr = WBRZ_BILL_CODE;
        }else if(PayoutTypeEnum.劳务分包合同.getCode().equals(contractVo.getContractType())){
            billCodeStr = LWFB_BILL_CODE;
        }else if(PayoutTypeEnum.设备或材料采购合同.getCode().equals(contractVo.getContractType())){
            billCodeStr = CLCG_BILL_CODE;
        }else if(PayoutTypeEnum.设备租赁合同.getCode().equals(contractVo.getContractType())){
            billCodeStr = SBZL_BILL_CODE;
        }
        BillCodeParam billCodeParam = BillCodeParam
                .build(billCodeStr, InvocationInfoProxy.getTenantid(), contractVo);
        CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
        if (billCode.isSuccess()) {
            contractBillCode = billCode.getData();
        }
        else {
            throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
        }
        return contractBillCode;
    }

    @Override
    public ContractChangeVO queryDetail(Long id) {
        ContractChangeEntity entity = changeService.selectById(id);
        ContractChangeVO vo = BeanMapper.map(entity, ContractChangeVO.class);
        return vo;
    }

    @Override
    public void deleteContractChange(List<ContractChangeVO> vos) {
        ContractChangeVO changeVo = vos.get(0);
        ContractChangeEntity entity = super.selectById(changeVo.getId());
        //合同变更只有详情页有删除
        ContractEntity pcentity = contractService.selectById(entity.getContractId());
        //会写合同表
        pcentity.setId(entity.getContractId());
        pcentity.setChangeVersion(pcentity.getChangeVersion()-1);
        pcentity.setChangeStatus(ChangeStatusEnum.未变更.getCode());
        pcentity.setChangingMny(BigDecimal.ZERO);//修改变更中金额
        pcentity.setChangingTaxMny(BigDecimal.ZERO);
        pcentity.setChangeCode(null);
        pcentity.setChangeId(null);
        contractService.update(pcentity, new QueryWrapper<ContractEntity>().eq("id",pcentity.getId()),false);
        super.removeByIds(vos.stream().map(ContractChangeVO::getId).collect(Collectors.toList()),false);
    }

    @Override
    public ContractChangeVO queryDetails(Long id) {
        ContractEntity entity = contractService.selectById(id);
        ContractChangeVO changeVo = BeanMapper.map(entity, ContractChangeVO.class);
        //新增逻辑处理
        changeVo.setContractId(changeVo.getId());
        //新增即点变更按钮穿透过来，此时ID为合同id
        changeVo.setId(IdWorker.getId());
        changeVo.setBillState(null);
        changeVo.setCreateUserCode(null);
        changeVo.setCreateTime(null);
        changeVo.setUpdateUserCode(null);
        changeVo.setUpdateTime(null);
        changeVo.setChangeDate(new Date());
        changeVo.setBeforeContractName(entity.getContractName());
        changeVo.setBeforeChangeMny(entity.getContractMny());
        changeVo.setBeforeChangeTaxMny(entity.getContractTaxMny());
        changeVo.setBeforeContractName(changeVo.getContractName());

        List<ContractDetailEntity> details = null;
        LambdaQueryWrapper<ContractDetailEntity> lambda = Wrappers.<ContractDetailEntity>lambdaQuery();
        lambda.eq(ContractDetailEntity::getContractId,id);
        lambda.ne(ContractDetailEntity::getChangeType, ChangeTypeEnum.终止项);
        details = contractDetailService.list(lambda);
        if(CollectionUtils.isNotEmpty(details)){
            changeVo.setContractChangeDetailList(BeanMapper.mapList(details,ContractChangeDetailVO.class));
            changeVo.getContractChangeDetailList().forEach(vo -> {
                vo.setContractDetailId(vo.getId());
                vo.setChangeType(ChangeTypeEnum.未变更.getCode().toString());
                vo.setContractId(changeVo.getContractId());
                vo.setRowState("add");
//                vo.setId(null);
            });
        }else{
            changeVo.setContractChangeDetailList(null);
        }
        if(CollectionUtils.isNotEmpty(changeVo.getContractChangeClauseList())){
            changeVo.getContractChangeClauseList().forEach(vo -> {
                vo.setContractId(changeVo.getContractId());
                vo.setRowState("add");
//                vo.setId(null);
            });
        }
        //todo 复制附件
//        attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(id),"BT200528000000001","purchaseContractBill", String.valueOf(changeVo.getId()), "BT200604000000001","102345678");
     return changeVo;
    }

    @Override
    public ContractChangeRecordVO queryChangeRecord(Long id) {
        ContractChangeRecordVO vo = new ContractChangeRecordVO();
        ContractEntity entity = contractService.selectById(id);
        BigDecimal baseTaxMoney = entity.getBaseTaxMny()==null?BigDecimal.ZERO:entity.getBaseTaxMny();
        BigDecimal contractTaxMny = entity.getContractTaxMny()==null?BigDecimal.ZERO:entity.getContractTaxMny();
        vo.setBaseTaxMoney(baseTaxMoney);
        vo.setContractId(id);
        vo.setContractTaxMny(contractTaxMny);
        vo.setSumChangeMny(contractTaxMny.subtract(baseTaxMoney));
//        vo.setContractStatus(entity.getContractStatus());
        vo.setChangeStatus(entity.getChangeStatus());
        if(vo.getSumChangeMny().compareTo(BigDecimal.ZERO)!=0&&baseTaxMoney.compareTo(BigDecimal.ZERO)!=0){
            vo.setSumScale(new BigDecimal(100).multiply(vo.getSumChangeMny().divide(baseTaxMoney,8,ROUND_HALF_DOWN)));
        }else{
            vo.setSumScale(BigDecimal.ZERO);
        }

        if(entity.getChangeVersion()>0){
            //合同版本号>0说明会有变更记录
            LambdaQueryWrapper<ContractChangeEntity> lambda = Wrappers.<ContractChangeEntity>lambdaQuery();
            lambda.eq(ContractChangeEntity::getContractId,id);
            lambda.in(ContractChangeEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(),BillStateEnum.COMMITED_STATE.getBillStateCode());
            lambda.orderByDesc(ContractChangeEntity::getChangeVersion);
            List<ContractChangeEntity> entities = super.list(lambda);
            vo.setChangeRecord(BeanMapper.mapList(entities, ContractChangeVO.class));
        }
        return vo;
    }
}
