/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.jlcost.payout.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.jlcost.payout.bean.ContractDetailEntity;
import com.ejianc.business.jlcost.payout.bean.ContractEntity;
import com.ejianc.business.jlcost.payout.bean.SettleEntity;
import com.ejianc.business.jlcost.payout.enums.SettleSourceTypeEnum;
import com.ejianc.business.jlcost.payout.mapper.SettleMapper;
import com.ejianc.business.jlcost.payout.service.IContractService;
import com.ejianc.business.jlcost.payout.service.ISettleService;
import com.ejianc.business.jlcost.payout.vo.SettleDetailVO;
import com.ejianc.business.jlcost.payout.vo.SettleVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="settleService")
public class SettleServiceImpl
extends BaseServiceImpl<SettleMapper, SettleEntity>
implements ISettleService {
    @Autowired
    private IContractService contractService;

    @Override
    public SettleVO contToSettle(Long contractId) {
        ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.selectById(contractId));
        SettleVO settleVO = (SettleVO)BeanMapper.map((Object)((Object)contractEntity), SettleVO.class);
        settleVO.setBillCode(null);
        settleVO.setCreateTime(null);
        settleVO.setCreateUserCode(null);
        settleVO.setUpdateTime(null);
        settleVO.setUpdateUserCode(null);
        settleVO.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
        settleVO.setSettleBillType(contractEntity.getContractType());
        settleVO.setContractId(contractId);
        settleVO.setContractTaxRate(contractEntity.getTaxRate());
        settleVO.setSettleType(Integer.valueOf(1));
        if (null != contractEntity.getProjectId() && "1".equals(contractEntity.getProjectType())) {
            SettleVO result = this.querySumMny(contractId, contractEntity.getProjectId());
            settleVO.setSumSettleMny(result.getSumSettleMny());
            settleVO.setSumSettleTaxMny(result.getSumSettleTaxMny());
        }
        ArrayList<SettleDetailVO> detailList = new ArrayList<SettleDetailVO>();
        for (ContractDetailEntity detailEntity : contractEntity.getContractDetailList()) {
            SettleDetailVO detailVO = (SettleDetailVO)BeanMapper.map((Object)((Object)detailEntity), SettleDetailVO.class);
            detailVO.setCreateTime(null);
            detailVO.setCreateUserCode(null);
            detailVO.setUpdateTime(null);
            detailVO.setUpdateUserCode(null);
            detailVO.setCode(detailEntity.getMaterialCode());
            detailVO.setName(detailEntity.getMaterialName());
            detailVO.setNum(null);
            detailVO.setPrice(detailEntity.getDetailPrice());
            detailVO.setTaxPrice(detailEntity.getDetailTaxPrice());
            detailVO.setSourceId(String.valueOf(detailEntity.getId()));
            detailVO.setSourceType(String.valueOf(SettleSourceTypeEnum.\u5408\u540c\u6e05\u5355.getCode()));
            detailVO.setRowState("add");
            detailList.add(detailVO);
        }
        return settleVO;
    }

    @Override
    public SettleVO querySumMny(Long contractId, Long projectId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SettleEntity::getContractId, (Object)contractId);
        queryWrapper.eq(SettleEntity::getProjectId, (Object)projectId);
        queryWrapper.in(SettleEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        List list = this.list((Wrapper)queryWrapper);
        SettleVO settleVO = new SettleVO();
        for (SettleEntity entity : list) {
            settleVO.setSumSettleMny(ComputeUtil.safeAdd((BigDecimal)settleVO.getSettleMny(), (BigDecimal)entity.getSettleMny()));
            settleVO.setSumSettleTaxMny(ComputeUtil.safeAdd((BigDecimal)settleVO.getSettleTaxMny(), (BigDecimal)entity.getSettleTaxMny()));
        }
        return settleVO;
    }
}

