package com.ejianc.business.jlcost.payout.service;

import com.ejianc.business.jlcost.payout.bean.ContractChangeEntity;
import com.ejianc.business.jlcost.payout.vo.ContractChangeRecordVO;
import com.ejianc.business.jlcost.payout.vo.ContractChangeVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.IBaseService;

import java.util.List;

/**
 * 支出合同-变更-合同主表
 * 
 * @author generator
 * 
 */
public interface IContractChangeService extends IBaseService<ContractChangeEntity> {

    /**
     * 保存或修改信息
     *
     * @param contractChangeVO
     * @return
     */
    CommonResponse<ContractChangeVO> saveOrUpdate(ContractChangeVO contractChangeVO);

    /**
     * 根据主键ID查询详情
     *
     * @param id
     * @return
     */
    ContractChangeVO queryDetail(Long id);

    /**
     * 删除信息
     *
     * @param vos
     */
    void deleteContractChange(List<ContractChangeVO> vos);

    ContractChangeVO queryDetails(Long id);

    ContractChangeRecordVO queryChangeRecord(Long id);
    
}
