package com.ejianc.business.jlcost.finance.service.impl;

import com.ejianc.business.jlcost.finance.vo.PaymentRecordVO;
import com.ejianc.business.jlcost.finance.vo.PaymentVO;
import com.ejianc.business.jlcost.payout.bean.ContractEntity;
import com.ejianc.business.jlcost.payout.service.IContractService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.jlcost.finance.mapper.PaymentMapper;
import com.ejianc.business.jlcost.finance.bean.PaymentEntity;
import com.ejianc.business.jlcost.finance.service.IPaymentService;

/**
 * 资金管理-付款单
 * 
 * @author generator
 * 
 */
@Service("paymentService")
public class PaymentServiceImpl extends BaseServiceImpl<PaymentMapper, PaymentEntity> implements IPaymentService{
    @Autowired
    private IContractService contractService;
    @Override
    public PaymentVO addPaymentByConId(Long id) {
        PaymentVO paymentVO = new PaymentVO();
        ContractEntity entity = contractService.selectById(id);
        paymentVO.setContractId(entity.getId());
        paymentVO.setContractCode(entity.getBillCode());
        paymentVO.setContractName(entity.getContractName());
        paymentVO.setContractType(entity.getContractType());
        paymentVO.setContractTaxMny(entity.getContractTaxMny());

        return paymentVO;
    }

    @Override
    public PaymentRecordVO queryChangeRecord(Long id) {
        return null;
    }
}
