
package com.ejianc.business.jlcost.payout.enums;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 结算类型对应的单据编号枚举
 */
public enum SettleBillCodeEnum {
    外协加工(1, "SETTLE_PROCESS"),
    成品采购(2, ""),
    整体外包(3, ""),
    场地或设备租赁(4, ""),
    外部检测(5, ""),
    外部设计(6, ""),
    外部产品认证(7, ""),
    劳务分包(8, ""),
    设备或材料采购(9, ""),
    设备租赁(10, "");

    private final Integer type;
    private final String billCode;
    private static Map<Integer, SettleBillCodeEnum> enumMap = new HashMap();

    private SettleBillCodeEnum(Integer type, String billCode) {
        this.type = type;
        this.billCode = billCode;
    }

    public Integer getType() {
        return type;
    }

    public String getBillCode() {
        return billCode;
    }

    public static SettleBillCodeEnum getEnumByType(Integer type) {
        return (SettleBillCodeEnum)enumMap.get(type);
    }

    static {
        enumMap = (Map)EnumSet.allOf(SettleBillCodeEnum.class).stream().collect(Collectors.toMap(SettleBillCodeEnum::getType, Function.identity(), (k1, k2) -> {
            return k2;
        }));
    }
}
