package com.ejianc.business.jlcost.payout.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.jlcost.payout.bean.*;
import com.ejianc.business.jlcost.payout.enums.ChangeStatusEnum;
import com.ejianc.business.jlcost.payout.enums.ChangeTypeEnum;
import com.ejianc.business.jlcost.payout.enums.PayoutTypeEnum;
import com.ejianc.business.jlcost.payout.service.IContractChangeService;
import com.ejianc.business.jlcost.payout.service.IContractClauseService;
import com.ejianc.business.jlcost.payout.service.IContractRecordService;
import com.ejianc.business.jlcost.payout.service.IContractService;
import com.ejianc.business.jlcost.payout.vo.ContractChangeVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Date;
import java.util.Map;
import java.util.stream.Collectors;

@Service("contractChange")
public class ContractChangeBpmServiceImpl implements ICommonBusinessService {

    /**
     * 外协加工合同
     */
    private static final String WXJG_BILL_CODE = "WXJG_BILL_CODE";
    /**
     * 成品采购合同
     */
    private static final String CPCG_BILL_CODE = "CPCG_BILL_CODE";
    /**
     * 整体外包合同
     */
    private static final String ZTWB_BILL_CODE = "ZTWB_BILL_CODE";
    /**
     * 场地或设备租赁合同
     */
    private static final String CDZL_BILL_CODE = "CDZL_BILL_CODE";
    /**
     * 外部检测合同
     */
    private static final String WBJC_BILL_CODE = "WBJC_BILL_CODE";
    /**
     * 外部设计合同
     */
    private static final String WBSJ_BILL_CODE = "WBSJ_BILL_CODE";
    /**
     * 外部产品认证合同
     */
    private static final String WBRZ_BILL_CODE = "WBRZ_BILL_CODE";
    /**
     * 劳务分包合同
     */
    private static final String LWFB_BILL_CODE = "LWFB_BILL_CODE";
    /**
     * 设备或材料采购合同
     */
    private static final String CLCG_BILL_CODE = "CLCG_BILL_CODE";
    /**
     * 设备租赁合同
     */
    private static final String SBZL_BILL_CODE = "SBZL_BILL_CODE";


    /**
     * 外协加工合同
     */
    private static final String WXJG_BILL_TYPE = "EJCBT202405000009";
    /**
     * 成品采购合同
     */
    private static final String CPCG_BILL_TYPE = "EJCBT202405000010";
    /**
     * 整体外包合同
     */
    private static final String ZTWB_BILL_TYPE = "EJCBT202405000013";
    /**
     * 场地或设备租赁合同
     */
    private static final String CDZL_BILL_TYPE = "EJCBT202405000016";
    /**
     * 外部检测合同
     */
    private static final String WBJC_BILL_TYPE = "EJCBT202405000019";
    /**
     * 外部设计合同
     */
    private static final String WBSJ_BILL_TYPE = "EJCBT202405000022";
    /**
     * 外部产品认证合同
     */
    private static final String WBRZ_BILL_TYPE = "EJCBT202405000025";
    /**
     * 劳务分包合同
     */
    private static final String LWFB_BILL_TYPE = "EJCBT202405000028";
    /**
     * 设备或材料采购合同
     */
    private static final String CLCG_BILL_TYPE = "EJCBT202405000032";
    /**
     * 设备租赁合同
     */
    private static final String SBZL_BILL_TYPE = "EJCBT202405000036";

    /**
     * 外协加工合同
     */
    private static final String WXJG_CHANGE_BILL_TYPE = "EJCBT202405000007";
    /**
     * 成品采购合同
     */
    private static final String CPCG_CHANGE_BILL_TYPE = "EJCBT202405000011";
    /**
     * 整体外包合同
     */
    private static final String ZTWB_CHANGE_BILL_TYPE = "EJCBT202405000014";
    /**
     * 场地或设备租赁合同
     */
    private static final String CDZL_CHANGE_BILL_TYPE = "EJCBT202405000017";
    /**
     * 外部检测合同
     */
    private static final String WBJC_CHANGE_BILL_TYPE = "EJCBT202405000020";
    /**
     * 外部设计合同
     */
    private static final String WBSJ_CHANGE_BILL_TYPE = "EJCBT202405000023";
    /**
     * 外部产品认证合同
     */
    private static final String WBRZ_CHANGE_BILL_TYPE = "EJCBT202405000026";
    /**
     * 劳务分包合同
     */
    private static final String LWFB_CHANGE_BILL_TYPE = "EJCBT202405000029";
    /**
     * 设备或材料采购合同
     */
    private static final String CLCG_CHANGE_BILL_TYPE = "EJCBT202405000034";
    /**
     * 设备租赁合同
     */
    private static final String SBZL_CHANGE_BILL_TYPE = "EJCBT202405000037";

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IContractService contractService;

    @Autowired
    private IContractChangeService contractChangeService;

    @Autowired
    private IContractClauseService contractClauseService;


    @Autowired
    private IContractRecordService contractRecordService;

    /**
     * 提交前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    ;

    /**
     * 提交完回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    /**
     * 有审批流的撤回前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {

        return CommonResponse.success();
    }

    ;

    /**
     * 有审批流的撤回后回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    ;

    /**
     * 审批节点审批中时节点审批前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    ;

    /**
     * 终审审核前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    /**
     * 终审审核完回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        logger.info("进入审批同意后回写--- billId:" + billId + "  state:" + state);
        ContractChangeEntity changeEntity = contractChangeService.selectById(billId);
        //1，先复制合同表到合同历史表
        ContractEntity contractEntity = contractService.selectById(changeEntity.getContractId());
        ContractRecordEntity recordEntity = BeanMapper.map(contractEntity, ContractRecordEntity.class);
        logger.info("进入审批同意后回写--- changeEntity:" + changeEntity + "  contractEntity:" + contractEntity);
        recordEntity.setContractId(recordEntity.getId());
        recordEntity.setId(null);
//		recordEntity.setContractUndiscountMny(contractEntity.getContractUndiscountMny());
//		recordEntity.setDiscountMny(contractEntity.getDiscountMny());
        if (CollectionUtils.isNotEmpty(recordEntity.getContractDetailList())) {
            recordEntity.getContractDetailList().forEach(vo -> {
                vo.setContractDetailId(vo.getId());
                vo.setId(null);
            });
        }
        if (CollectionUtils.isNotEmpty(recordEntity.getContractClauseList())) {
            recordEntity.getContractClauseList().forEach(vo -> {
                vo.setContractClauseId(vo.getId());
                vo.setId(null);
            });
        }
        contractRecordService.saveOrUpdate(recordEntity, false);
//		LambdaUpdateWrapper<ContractChangeEntity> updateWrapper = new LambdaUpdateWrapper<>();
//		updateWrapper.eq(ContractChangeEntity::getId,changeEntity.getId());
//		updateWrapper.set(ContractChangeEntity::getChangeTime,new Date());
//		purchaseChangeService.update(updateWrapper);
        logger.info("进入审批同意后回写--2");
        //2，回写合同，变更状态改为已变更，并回写字段
        contractEntity.setChangeStatus(ChangeStatusEnum.已变更.getCode());
        contractEntity.setContractMny(contractEntity.getChangingMny());
        contractEntity.setContractTaxMny(contractEntity.getChangingTaxMny());
        contractEntity.setMemo(changeEntity.getMemo());
        contractEntity.setSignDate(changeEntity.getSignDate());
        contractEntity.setCustomerId(changeEntity.getCustomerId());
        contractEntity.setCustomerName(changeEntity.getCustomerName());
        contractEntity.setSupplierId(changeEntity.getSupplierId());
        contractEntity.setSupplierName(changeEntity.getSupplierName());
        contractEntity.setContractName(changeEntity.getContractName());
        contractEntity.setBillCode(changeEntity.getBillCode());
        contractEntity.setTaxRate(changeEntity.getTaxRate());
        contractEntity.setPerformanceStatus(changeEntity.getPerformanceStatus());
        contractEntity.setEmployeeId(changeEntity.getEmployeeId());
        contractEntity.setEmployeeName(changeEntity.getEmployeeName());
//		contractEntity.setContractUndiscountMny(changeEntity.getContractUndiscountMny());
//		contractEntity.setDiscountMny(changeEntity.getDiscountMny());

//		contractEntity.setInvoiceType(changeEntity.getInvoiceType());
//		contractEntity.setInvoiceTypeName(changeEntity.getInvoiceTypeName());

        QueryWrapper<ContractClauseEntity> deleteWrapper = new QueryWrapper<>();
        deleteWrapper.eq("contract_id", changeEntity.getContractId());
        contractClauseService.remove(deleteWrapper);
        contractEntity.setContractClauseList(null);
        if (CollectionUtils.isNotEmpty(changeEntity.getContractDetailList())) {
            logger.info("复制子表开始--" + changeEntity.getContractDetailList());
            changeEntity.getContractDetailList().forEach(vo -> {
                logger.info("复制子表--" + vo.getContractDetailId() + "---type" + vo.getChangeType());
                if (null != vo.getContractDetailId()) {
                    Map<Long, Integer> map = contractEntity.getContractDetailList().stream().collect(Collectors.toMap(ContractDetailEntity::getId, ContractDetailEntity::getVersion));
                    vo.setId(vo.getContractDetailId());
                    vo.setVersion(map.get(vo.getContractDetailId()));
                }
            });
            contractEntity.setContractDetailList(BeanMapper.mapList(changeEntity.getContractDetailList(), ContractDetailEntity.class));
        }
        if (CollectionUtils.isNotEmpty(changeEntity.getContractClauseList())) {
            changeEntity.getContractClauseList().forEach(vo -> {
                vo.setId(null);
            });
            contractEntity.setContractClauseList(BeanMapper.mapList(changeEntity.getContractClauseList(), ContractClauseEntity.class));
        }
        boolean flag = contractService.saveOrUpdate(contractEntity, false);
        logger.info("业务逻辑完成--返回" + flag);
        if (flag) {
            //变更合同附件复制到主合同
            //todo 复制附件
            BillData billData = ContractChangeServiceImpl.getContractBillCodeAndType(BeanMapper.map(contractEntity, ContractChangeVO.class));
            attachmentApi.copyFiles(String.valueOf(billId), billData.getChangeBillTypeStr(), "contractChange", String.valueOf(contractEntity.getId()), billData.getBillTypeStr(), "payoutContract", true);
            return CommonResponse.success();
        } else {
            return CommonResponse.error("审批回写异常!");
        }
    }

    /**
     * 弃审前事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.error("合同变更单暂不支持回退功能!");
    }

    /**
     * 弃审后事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        // 参数是单据类型编码字符串 根据需求是否打开下面代码
        /**CommonResponse<String> resp = billTypeApi.checkQuote(billTypeCode, billId);
         if(!resp.isSuccess()){
         return CommonResponse.error("无法撤回！"+resp.getMsg());
         }*/
        return CommonResponse.success();
    }


}
