package com.ejianc.business.jlcost.finance.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.jlcost.finance.bean.CollectDetailEntity;
import com.ejianc.business.jlcost.finance.bean.CollectEntity;
import com.ejianc.business.jlcost.finance.mapper.CollectMapper;
import com.ejianc.business.jlcost.finance.service.ICollectDetailService;
import com.ejianc.business.jlcost.finance.service.ICollectService;
import com.ejianc.business.jlcost.finance.vo.CollectVO;
import com.ejianc.business.jlcost.payout.bean.ContractEntity;
import com.ejianc.business.jlcost.payout.bean.SettleEntity;
import com.ejianc.business.jlcost.payout.service.IContractService;
import com.ejianc.business.jlcost.payout.service.ISettleService;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 资金管理-收票登记
 *
 * @author generator
 *
 */
@Service("collectService")
public class CollectServiceImpl extends BaseServiceImpl<CollectMapper, CollectEntity> implements ICollectService{

    @Autowired
    private IContractService contractService;
    @Autowired
    private ISettleService settleService;
    @Autowired
    private ICollectDetailService collectDetailService;

    @Override
    public CollectVO querySumMny(Long contractId, Long projectId) {
        LambdaQueryWrapper<CollectEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(CollectEntity::getContractId, contractId);
        queryWrapper.eq(CollectEntity::getProjectId, projectId);
        queryWrapper.in(CollectEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode());
        List<CollectEntity> list = list(queryWrapper);
        CollectVO collectVO = new CollectVO();
        for (CollectEntity entity : list) {
            collectVO.setSumInvoiceMny(ComputeUtil.safeAdd(collectVO.getInvoiceMny(), entity.getInvoiceMny()));
            collectVO.setSumInvoiceTaxMny(ComputeUtil.safeAdd(collectVO.getInvoiceTaxMny(), entity.getInvoiceTaxMny()));
        }
        return collectVO;
    }

    @Override
    public CollectVO contToCollect(Long contractId) {
        ContractEntity contractEntity = contractService.selectById(contractId);
        CollectVO collectVO = BeanMapper.map(contractEntity, CollectVO.class);
        collectVO.setId(null);
        collectVO.setBillCode(null);
        collectVO.setCreateTime(null);
        collectVO.setCreateUserCode(null);
        collectVO.setUpdateTime(null);
        collectVO.setUpdateUserCode(null);
        collectVO.setMemo(null);
        collectVO.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
        collectVO.setSignDate(new Date());
        collectVO.setContractType(String.valueOf(contractEntity.getContractType()));
        collectVO.setContractId(contractId);
        collectVO.setContractCode(contractEntity.getBillCode());
        if (null != contractEntity.getProjectId() && "1".equals(contractEntity.getProjectType())) {
            CollectVO result = querySumMny(contractId, contractEntity.getProjectId());
            collectVO.setSumInvoiceMny(result.getSumInvoiceMny());
            collectVO.setSumInvoiceTaxMny(result.getSumInvoiceTaxMny());
            collectVO.setSumInvoiceAllMny(result.getSumInvoiceMny());
            collectVO.setSumInvoiceAllTaxMny(result.getSumInvoiceTaxMny());
        }
        return collectVO;
    }

    @Override
    public JSONObject queryRecordByContId(Long contractId, boolean hasChildren) {
        ContractEntity contractEntity = contractService.selectById(contractId);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("contractMny", contractEntity.getContractMny());
        jsonObject.put("contractTaxMny", contractEntity.getContractTaxMny());
        jsonObject.put("performanceStatus", contractEntity.getPerformanceStatus());
        jsonObject.put("changeStatus", contractEntity.getChangeStatus());
        jsonObject.put("billState", contractEntity.getBillState());
        LambdaQueryWrapper<SettleEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(SettleEntity::getContractId, contractId);
        queryWrapper.in(SettleEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode());
        queryWrapper.orderByDesc(SettleEntity::getSettleDate);
        List<SettleEntity> settleEntities = settleService.list(queryWrapper);
        if (CollectionUtils.isNotEmpty(settleEntities)) {
            BigDecimal sumSettleMny = BigDecimal.ZERO;
            BigDecimal sumSettleTaxMny = BigDecimal.ZERO;
            for (SettleEntity entity : settleEntities) {
                sumSettleMny = ComputeUtil.safeAdd(sumSettleMny, entity.getSettleMny());
                sumSettleTaxMny = ComputeUtil.safeAdd(sumSettleTaxMny, entity.getSettleTaxMny());
            }
            jsonObject.put("sumSettleAllMny", sumSettleMny);
            jsonObject.put("sumSettleAllTaxMny", sumSettleTaxMny);
        }
        LambdaQueryWrapper<CollectEntity> query = new LambdaQueryWrapper<>();
        query.eq(CollectEntity::getContractId, contractId);
        query.in(CollectEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode());
        List<CollectEntity> list = list(query);
        if (CollectionUtils.isNotEmpty(list)) {
            BigDecimal sumInvoiceAllMny = BigDecimal.ZERO;
            BigDecimal sumInvoiceAllTaxMny = BigDecimal.ZERO;
            List<Long> idList = new ArrayList<>();
            for (CollectEntity entity : list) {
                sumInvoiceAllMny = ComputeUtil.safeAdd(sumInvoiceAllMny, entity.getInvoiceMny());
                sumInvoiceAllTaxMny = ComputeUtil.safeAdd(sumInvoiceAllTaxMny, entity.getInvoiceTaxMny());
                idList.add(entity.getId());
            }
            jsonObject.put("sumInvoiceAllMny", sumInvoiceAllMny);
            jsonObject.put("sumInvoiceAllTaxMny", sumInvoiceAllTaxMny);
            jsonObject.put("settledNoColtMny", ComputeUtil.safeSub(jsonObject.getBigDecimal("sumSettleAllTaxMny"), sumInvoiceAllTaxMny));
            if(hasChildren){
                LambdaQueryWrapper<CollectDetailEntity> qry = new LambdaQueryWrapper<>();
                qry.in(CollectDetailEntity::getCollectId, idList);
                List<CollectDetailEntity> detailEntities = collectDetailService.list(qry);
                if (CollectionUtils.isNotEmpty(detailEntities)) {
                    jsonObject.put("detailList", detailEntities);
                }
            }
        }
        return jsonObject;
    }
}
