/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.jlcost.finance.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.jlcost.finance.bean.CollectEntity;
import com.ejianc.business.jlcost.finance.bean.PaymentEntity;
import com.ejianc.business.jlcost.finance.bean.ReceiveEntity;
import com.ejianc.business.jlcost.finance.service.ICollectService;
import com.ejianc.business.jlcost.finance.service.IPaymentService;
import com.ejianc.business.jlcost.finance.service.IReceiveService;
import com.ejianc.business.jlcost.finance.vo.PaymentRecordVO;
import com.ejianc.business.jlcost.finance.vo.PaymentVO;
import com.ejianc.business.jlcost.payout.bean.ContractEntity;
import com.ejianc.business.jlcost.payout.bean.SettleEntity;
import com.ejianc.business.jlcost.payout.service.IContractService;
import com.ejianc.business.jlcost.payout.service.ISettleService;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import javax.websocket.server.PathParam;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"payment"})
public class PaymentController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "PAYMENT";
    @Autowired
    private IPaymentService service;
    @Autowired
    private ISettleService settleService;
    @Autowired
    private ICollectService collectService;
    @Autowired
    private IContractService contractService;
    @Autowired
    private IReceiveService receiveService;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<PaymentVO> saveOrUpdate(@RequestBody PaymentVO saveOrUpdateVO) {
        PaymentEntity entity = (PaymentEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, PaymentEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        PaymentVO vo = (PaymentVO)BeanMapper.map((Object)((Object)entity), PaymentVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<PaymentVO> queryDetail(Long id) {
        PaymentEntity entity = (PaymentEntity)((Object)this.service.selectById(id));
        PaymentVO vo = (PaymentVO)BeanMapper.map((Object)((Object)entity), PaymentVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PaymentVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (PaymentVO paymentVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<PaymentVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractType");
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("paymentType");
        fuzzyFields.add("paymentMethodName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), PaymentVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/addPaymentByConId"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<PaymentVO> addPaymentByConId(@RequestParam Long id) {
        PaymentVO paymentVO = this.service.addPaymentByConId(id);
        return CommonResponse.success((Object)paymentVO);
    }

    @RequestMapping(value={"/queryDetailRecord"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<PaymentRecordVO> queryDetailRecord(@RequestParam Long id) {
        PaymentRecordVO recordVO = this.service.queryChangeRecord(id);
        return CommonResponse.success((Object)recordVO);
    }

    @RequestMapping(value={"/addProjectTotalIncome"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<PaymentVO> addProjectTotalIncome(@RequestParam Long id, @RequestParam long projectId) {
        PaymentVO paymentVO = this.service.addProjectTotalIncome(id, projectId);
        return CommonResponse.success((Object)paymentVO);
    }

    @RequestMapping(value={"/queryTotal"}, method={RequestMethod.GET})
    @ResponseBody
    public List<BigDecimal> queryTotal(@PathParam(value="contractId") Long contractId, @PathParam(value="projectId") Long projectId) {
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(ReceiveEntity::getProjectId, (Object)projectId);
        HashMap<String, Parameter> map = new HashMap<String, Parameter>();
        map.put("contractId", new Parameter("eq", (Object)contractId));
        map.put("projectId", new Parameter("eq", (Object)projectId));
        param.setParams(map);
        List paymentEntities = this.service.queryList(param);
        List settleEntities = this.settleService.queryList(param);
        List collectEntities = this.collectService.queryList(param);
        List receiveEntities = this.receiveService.list((Wrapper)queryWrapper);
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(ContractEntity::getProjectId, (Object)projectId);
        List contractEntities = this.contractService.list((Wrapper)wrapper);
        BigDecimal addPaymentTaxMny = paymentEntities.stream().map(PaymentEntity::getPaymentTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal addSettleTaxMny = settleEntities.stream().map(SettleEntity::getSettleTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal addCollectTaxMny = collectEntities.stream().map(CollectEntity::getInvoiceTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal addReceiveMny = receiveEntities.stream().map(ReceiveEntity::getReceiveMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal addContractTaxMny = contractEntities.stream().map(ContractEntity::getContractTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        ArrayList<BigDecimal> list = new ArrayList<BigDecimal>();
        list.add(addPaymentTaxMny);
        list.add(addSettleTaxMny);
        list.add(addCollectTaxMny);
        list.add(addReceiveMny);
        list.add(addContractTaxMny);
        return list;
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractType");
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("paymentType");
        fuzzyFields.add("paymentMethodName");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        List resDatas = BeanMapper.mapList((Iterable)list, PaymentVO.class);
        for (PaymentVO resData : resDatas) {
            switch (resData.getBillState()) {
                case 0: {
                    resData.setBillStateName("\u81ea\u7531\u6001");
                    break;
                }
                case 1: {
                    resData.setBillStateName("\u5df2\u63d0\u4ea4");
                    break;
                }
                case 2: 
                case 5: {
                    resData.setBillStateName("\u5ba1\u6279\u4e2d");
                    break;
                }
                case 3: {
                    resData.setBillStateName("\u5ba1\u6279\u901a\u8fc7");
                    break;
                }
                case 4: {
                    resData.setBillStateName("\u5ba1\u6279\u9a73\u56de");
                }
            }
            switch (resData.getContractType()) {
                case 1: {
                    resData.setContractTypeName("\u5916\u534f\u52a0\u5de5\u5408\u540c");
                    break;
                }
                case 2: {
                    resData.setContractTypeName("\u6210\u54c1\u91c7\u8d2d\u5408\u540c");
                    break;
                }
                case 3: {
                    resData.setContractTypeName("\u6574\u4f53\u5916\u5305\u5408\u540c");
                    break;
                }
                case 4: {
                    resData.setContractTypeName("\u573a\u5730\u6216\u8bbe\u5907\u79df\u8d41\u5408\u540c");
                    break;
                }
                case 5: {
                    resData.setContractTypeName("\u5916\u90e8\u68c0\u6d4b\u5408\u540c");
                    break;
                }
                case 6: {
                    resData.setContractTypeName("\u5916\u90e8\u8bbe\u8ba1\u5408\u540c");
                    break;
                }
                case 7: {
                    resData.setContractTypeName("\u5916\u90e8\u4ea7\u54c1\u8ba4\u8bc1\u5408\u540c");
                    break;
                }
                case 8: {
                    resData.setContractTypeName("\u52b3\u52a1\u5206\u5305\u5408\u540c");
                    break;
                }
                case 9: {
                    resData.setContractTypeName("\u8bbe\u5907\u6216\u6750\u6599\u91c7\u8d2d\u5408\u540c");
                    break;
                }
                case 10: {
                    resData.setContractTypeName("\u8bbe\u5907\u79df\u8d41\u5408\u540c");
                }
            }
            switch (resData.getPaymentType()) {
                case 1: {
                    resData.setPaymentTypeName("\u9884\u4ed8\u6b3e");
                    break;
                }
                case 2: {
                    resData.setPaymentTypeName("\u8fc7\u7a0b\u7ed3\u7b97\u6b3e");
                    break;
                }
                case 3: {
                    resData.setPaymentTypeName("\u8d28\u4fdd\u91d1");
                    break;
                }
                case 4: {
                    resData.setPaymentTypeName("\u5176\u4ed6");
                }
            }
        }
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", resDatas);
        ExcelExport.getInstance().export("Payment-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refPaymentData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<PaymentVO>> refPaymentData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), PaymentVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

