/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.jlcost.finance.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.jlcost.finance.bean.CollectEntity;
import com.ejianc.business.jlcost.finance.bean.PaymentEntity;
import com.ejianc.business.jlcost.finance.bean.ReceiveEntity;
import com.ejianc.business.jlcost.finance.mapper.PaymentMapper;
import com.ejianc.business.jlcost.finance.service.ICollectService;
import com.ejianc.business.jlcost.finance.service.IPaymentService;
import com.ejianc.business.jlcost.finance.service.IReceiveService;
import com.ejianc.business.jlcost.finance.vo.PaymentRecordVO;
import com.ejianc.business.jlcost.finance.vo.PaymentVO;
import com.ejianc.business.jlcost.payout.bean.ContractEntity;
import com.ejianc.business.jlcost.payout.bean.SettleEntity;
import com.ejianc.business.jlcost.payout.service.IContractService;
import com.ejianc.business.jlcost.payout.service.ISettleService;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="paymentService")
public class PaymentServiceImpl
extends BaseServiceImpl<PaymentMapper, PaymentEntity>
implements IPaymentService {
    @Autowired
    private ISettleService settleService;
    @Autowired
    private ICollectService collectService;
    @Autowired
    private IContractService contractService;
    @Autowired
    private IReceiveService receiveService;

    @Override
    public PaymentVO addPaymentByConId(Long id) {
        PaymentVO paymentVO = new PaymentVO();
        ContractEntity entity = (ContractEntity)((Object)this.contractService.selectById(id));
        paymentVO.setContractId(entity.getId());
        paymentVO.setContractCode(entity.getBillCode());
        paymentVO.setContractName(entity.getContractName());
        paymentVO.setContractType(entity.getContractType());
        paymentVO.setContractTaxMny(entity.getContractTaxMny());
        paymentVO.setCustomerId(entity.getCustomerId());
        paymentVO.setCustomerName(entity.getCustomerName());
        paymentVO.setSupplierId(entity.getSupplierId());
        paymentVO.setSupplierName(entity.getSupplierName());
        paymentVO.setContractType(entity.getContractType());
        paymentVO.setDepartmentId(entity.getDepartmentId());
        paymentVO.setDepartmentName(entity.getDepartmentName());
        paymentVO.setOrgId(entity.getOrgId());
        paymentVO.setOrgName(entity.getOrgName());
        paymentVO.setOrgCode(entity.getOrgCode());
        paymentVO.setParentOrgId(entity.getParentOrgId());
        paymentVO.setParentOrgName(entity.getParentOrgName());
        paymentVO.setParentOrgCode(entity.getParentOrgCode());
        paymentVO.setProjectId(entity.getProjectId());
        paymentVO.setProjectName(entity.getProjectName());
        paymentVO.setProjectCode(entity.getProjectCode());
        paymentVO.setProjectType(entity.getProjectType());
        LambdaQueryWrapper paymentLambda = new LambdaQueryWrapper();
        paymentLambda.eq(PaymentEntity::getContractId, (Object)id);
        paymentLambda.in(PaymentEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        paymentLambda.orderByDesc(PaymentEntity::getPaymentDate);
        List entities = super.list((Wrapper)paymentLambda);
        if (CollectionUtils.isNotEmpty((Collection)entities)) {
            BigDecimal totalPaymentTaxMny = entities.stream().filter(item -> null != item.getPaymentTaxMny()).map(PaymentEntity::getPaymentTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            paymentVO.setHistoryPaymentTaxMny(totalPaymentTaxMny);
            paymentVO.setTotalPaymentTaxMny(totalPaymentTaxMny);
        } else {
            paymentVO.setHistoryPaymentTaxMny(new BigDecimal(0));
            paymentVO.setTotalPaymentTaxMny(new BigDecimal(0));
        }
        LambdaQueryWrapper settleLambda = new LambdaQueryWrapper();
        settleLambda.eq(SettleEntity::getContractId, (Object)id);
        settleLambda.in(SettleEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        settleLambda.orderByDesc(SettleEntity::getSettleDate);
        List settleEntities = this.settleService.list((Wrapper)settleLambda);
        if (CollectionUtils.isNotEmpty((Collection)settleEntities)) {
            BigDecimal totalSettleTaxMny = settleEntities.stream().filter(item -> null != item.getSettleTaxMny()).map(SettleEntity::getSettleTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            paymentVO.setTotalSettleTaxMny(totalSettleTaxMny);
        } else {
            paymentVO.setTotalSettleTaxMny(new BigDecimal(0));
        }
        LambdaQueryWrapper collectLambda = new LambdaQueryWrapper();
        collectLambda.eq(CollectEntity::getContractId, (Object)id);
        collectLambda.in(CollectEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        collectLambda.orderByDesc(CollectEntity::getSignDate);
        List collectEntities = this.collectService.list((Wrapper)collectLambda);
        if (CollectionUtils.isNotEmpty((Collection)collectEntities)) {
            BigDecimal totalCollectTaxMny = collectEntities.stream().filter(item -> null != item.getInvoiceTaxMny()).map(CollectEntity::getInvoiceTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            paymentVO.setTotalInvoiceTaxMny(totalCollectTaxMny);
        } else {
            paymentVO.setTotalInvoiceTaxMny(new BigDecimal(0));
        }
        return paymentVO;
    }

    @Override
    public PaymentVO addProjectTotalMny(Long id, Long projectId) {
        PaymentVO paymentVO = new PaymentVO();
        LambdaQueryWrapper paymentLambda = new LambdaQueryWrapper();
        LambdaQueryWrapper settleLambda = new LambdaQueryWrapper();
        LambdaQueryWrapper collectLambda = new LambdaQueryWrapper();
        LambdaQueryWrapper receiveLambda = new LambdaQueryWrapper();
        paymentLambda.eq(PaymentEntity::getContractId, (Object)id);
        paymentLambda.eq(PaymentEntity::getProjectId, (Object)projectId);
        paymentLambda.in(PaymentEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        paymentLambda.orderByDesc(PaymentEntity::getPaymentDate);
        List entities = super.list((Wrapper)paymentLambda);
        if (CollectionUtils.isNotEmpty((Collection)entities)) {
            BigDecimal totalPaymentTaxMny = entities.stream().filter(item -> null != item.getPaymentTaxMny()).map(PaymentEntity::getPaymentTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            paymentVO.setHistoryPaymentTaxMny(totalPaymentTaxMny);
            paymentVO.setTotalPaymentTaxMny(totalPaymentTaxMny);
        } else {
            paymentVO.setHistoryPaymentTaxMny(new BigDecimal(0));
            paymentVO.setTotalPaymentTaxMny(new BigDecimal(0));
        }
        settleLambda.eq(SettleEntity::getContractId, (Object)id);
        settleLambda.eq(SettleEntity::getProjectId, (Object)projectId);
        settleLambda.in(SettleEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        settleLambda.orderByDesc(SettleEntity::getSettleDate);
        List settleEntities = this.settleService.list((Wrapper)settleLambda);
        if (CollectionUtils.isNotEmpty((Collection)settleEntities)) {
            BigDecimal totalSettleTaxMny = settleEntities.stream().filter(item -> null != item.getSettleTaxMny()).map(SettleEntity::getSettleTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            paymentVO.setTotalSettleTaxMny(totalSettleTaxMny);
        } else {
            paymentVO.setTotalSettleTaxMny(new BigDecimal(0));
        }
        collectLambda.eq(CollectEntity::getContractId, (Object)id);
        collectLambda.eq(CollectEntity::getProjectId, (Object)projectId);
        collectLambda.in(CollectEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        collectLambda.orderByDesc(CollectEntity::getSignDate);
        List collectEntities = this.collectService.list((Wrapper)collectLambda);
        if (CollectionUtils.isNotEmpty((Collection)collectEntities)) {
            BigDecimal totalCollectTaxMny = collectEntities.stream().filter(item -> null != item.getInvoiceTaxMny()).map(CollectEntity::getInvoiceTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            paymentVO.setTotalInvoiceTaxMny(totalCollectTaxMny);
        } else {
            paymentVO.setTotalInvoiceTaxMny(new BigDecimal(0));
        }
        receiveLambda.eq(ReceiveEntity::getContractId, (Object)id);
        receiveLambda.eq(ReceiveEntity::getProjectId, (Object)projectId);
        receiveLambda.in(ReceiveEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        receiveLambda.orderByDesc(ReceiveEntity::getReceiveTime);
        List receiveEntities = this.receiveService.list((Wrapper)receiveLambda);
        if (CollectionUtils.isNotEmpty((Collection)receiveEntities)) {
            BigDecimal totalReceiveTaxMny = receiveEntities.stream().filter(item -> null != item.getReceiveMny()).map(ReceiveEntity::getReceiveMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            paymentVO.setProjectTotalIncome(totalReceiveTaxMny);
        } else {
            paymentVO.setProjectTotalIncome(new BigDecimal(0));
        }
        return paymentVO;
    }

    @Override
    public PaymentRecordVO queryChangeRecord(Long id) {
        PaymentRecordVO paymentRecordVO = new PaymentRecordVO();
        JSONObject object = this.collectService.queryRecordByContId(id, false);
        BigDecimal totalSettleTaxMny = object.get((Object)"sumSettleAllTaxMny") == null ? BigDecimal.ZERO : new BigDecimal(object.get((Object)"sumSettleAllTaxMny").toString());
        BigDecimal totalInvoiceTaxMny = object.get((Object)"sumInvoiceAllTaxMny") == null ? BigDecimal.ZERO : new BigDecimal(object.get((Object)"sumInvoiceAllTaxMny").toString());
        BigDecimal contractTaxMny = object.get((Object)"contractTaxMny") == null ? BigDecimal.ZERO : new BigDecimal(object.get((Object)"contractTaxMny").toString());
        String performanceStatus = object.get((Object)"performanceStatus") == null ? "0" : object.get((Object)"performanceStatus").toString();
        Integer changeStatus = object.get((Object)"changeStatus") == null ? 0 : Integer.parseInt(object.get((Object)"changeStatus").toString());
        paymentRecordVO.setTotalSettleTaxMny(totalSettleTaxMny);
        paymentRecordVO.setTotalInvoiceTaxMny(totalInvoiceTaxMny);
        paymentRecordVO.setContractTaxMny(contractTaxMny);
        paymentRecordVO.setContractId(id);
        paymentRecordVO.setPerformanceStatus(performanceStatus);
        paymentRecordVO.setChangeStatus(changeStatus);
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(PaymentEntity::getContractId, (Object)id);
        lambda.in(PaymentEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        lambda.orderByDesc(PaymentEntity::getPaymentDate);
        List entities = super.list((Wrapper)lambda);
        if (CollectionUtils.isNotEmpty((Collection)entities)) {
            paymentRecordVO.setPaymentList(BeanMapper.mapList((Iterable)entities, PaymentVO.class));
            BigDecimal totalPaymentTaxMny = entities.stream().filter(item -> null != item.getPaymentTaxMny()).map(PaymentEntity::getPaymentTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            paymentRecordVO.setTotalInvoiceTaxMny(totalPaymentTaxMny);
        }
        return paymentRecordVO;
    }
}

