package com.ejianc.business.jlcost.payout.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.jlcost.payout.bean.ContractDetailEntity;
import com.ejianc.business.jlcost.payout.bean.ContractEntity;
import com.ejianc.business.jlcost.payout.bean.SettleEntity;
import com.ejianc.business.jlcost.payout.enums.SettleSourceTypeEnum;
import com.ejianc.business.jlcost.payout.mapper.SettleMapper;
import com.ejianc.business.jlcost.payout.service.IContractService;
import com.ejianc.business.jlcost.payout.service.ISettleService;
import com.ejianc.business.jlcost.payout.vo.SettleDetailVO;
import com.ejianc.business.jlcost.payout.vo.SettleVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;

/**
 * 支出结算-主表
 *
 * @author generator
 *
 */
@Service("settleService")
public class SettleServiceImpl extends BaseServiceImpl<SettleMapper, SettleEntity> implements ISettleService{

    @Autowired
    private IContractService contractService;

    @Override
    public SettleVO contToSettle(Long contractId) {
        ContractEntity contractEntity = contractService.selectById(contractId);
        SettleVO settleVO = BeanMapper.map(contractEntity, SettleVO.class);
        settleVO.setId(null);
        settleVO.setBillCode(null);
        settleVO.setCreateTime(null);
        settleVO.setCreateUserCode(null);
        settleVO.setUpdateTime(null);
        settleVO.setUpdateUserCode(null);
        settleVO.setMemo(null);
        settleVO.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
        settleVO.setSettleDate(new Date());
        settleVO.setSettleBillType(contractEntity.getContractType());
        settleVO.setContractId(contractId);
        settleVO.setContractCode(contractEntity.getBillCode());
        settleVO.setContractTaxRate(contractEntity.getTaxRate());
        settleVO.setSettleType(1);
        if (null != contractEntity.getProjectId() && "1".equals(contractEntity.getProjectType())) {
            SettleVO result = querySumMny(contractId, contractEntity.getProjectId());
            settleVO.setSumSettleMny(result.getSumSettleMny());
            settleVO.setSumSettleTaxMny(result.getSumSettleTaxMny());
            settleVO.setSumSettleAllMny(result.getSumSettleMny());
            settleVO.setSumSettleAllTaxMny(result.getSumSettleTaxMny());
        }

        List<SettleDetailVO> detailList = new ArrayList<>();
        for (ContractDetailEntity detailEntity : contractEntity.getContractDetailList()) {
            SettleDetailVO detailVO = BeanMapper.map(detailEntity, SettleDetailVO.class);
            detailVO.setId(IdWorker.getId());
            detailVO.setCreateTime(null);
            detailVO.setCreateUserCode(null);
            detailVO.setUpdateTime(null);
            detailVO.setUpdateUserCode(null);
            detailVO.setCode(detailEntity.getMaterialCode());
            detailVO.setName(detailEntity.getMaterialName());
            detailVO.setNum(null);
            detailVO.setPrice(detailEntity.getDetailPrice());
            detailVO.setTaxPrice(detailEntity.getDetailTaxPrice());
            detailVO.setTaxRate(contractEntity.getTaxRate());
            detailVO.setSourceId(String.valueOf(detailEntity.getId()));
            detailVO.setSourceType(String.valueOf(SettleSourceTypeEnum.合同清单.getCode()));
            detailVO.setRowState("add");
            detailList.add(detailVO);
        }
        settleVO.setDetailList(detailList);
        return settleVO;
    }

    @Override
    public SettleVO querySumMny(Long contractId, Long projectId) {
        LambdaQueryWrapper<SettleEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(SettleEntity::getContractId, contractId);
        queryWrapper.eq(SettleEntity::getProjectId, projectId);
        queryWrapper.in(SettleEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode());
        List<SettleEntity> list = list(queryWrapper);
        SettleVO settleVO = new SettleVO();
        BigDecimal sumSettleMny = BigDecimal.ZERO;
        BigDecimal sumSettleTaxMny = BigDecimal.ZERO;
        for (SettleEntity entity : list) {
            sumSettleMny = ComputeUtil.safeAdd(sumSettleMny, entity.getSettleMny());
            sumSettleTaxMny = ComputeUtil.safeAdd(sumSettleTaxMny, entity.getSettleTaxMny());
        }
        settleVO.setSumSettleMny(sumSettleMny);
        settleVO.setSumSettleTaxMny(sumSettleTaxMny);
        return settleVO;
    }

    @Override
    public JSONObject queryRecordByContId(Long contractId) {
        ContractEntity contractEntity = contractService.selectById(contractId);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("contractMny", contractEntity.getContractMny());
        jsonObject.put("contractTaxMny", contractEntity.getContractTaxMny());
        jsonObject.put("performanceStatus", contractEntity.getPerformanceStatus());
        jsonObject.put("changeStatus", contractEntity.getChangeStatus());
        jsonObject.put("billState", contractEntity.getBillState());
        LambdaQueryWrapper<SettleEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(SettleEntity::getContractId, contractId);
        queryWrapper.in(SettleEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode());
        queryWrapper.orderByDesc(SettleEntity::getSettleDate);
        List<SettleEntity> list = list(queryWrapper);
        if (CollectionUtils.isNotEmpty(list)) {
            List<SettleVO> settleVOS = BeanMapper.mapList(list, SettleVO.class);
            settleVOS.sort(Comparator.comparing(SettleVO::getSettleDate));
            BigDecimal sumSettleMny = BigDecimal.ZERO;
            BigDecimal sumSettleTaxMny = BigDecimal.ZERO;
            for (SettleEntity entity : list) {
                sumSettleMny = ComputeUtil.safeAdd(sumSettleMny, entity.getSettleMny());
                sumSettleTaxMny = ComputeUtil.safeAdd(sumSettleTaxMny, entity.getSettleTaxMny());
            }
            jsonObject.put("sumSettleAllMny", sumSettleMny);
            jsonObject.put("sumSettleAllTaxMny", sumSettleTaxMny);
            jsonObject.put("settleTaxScale", ComputeUtil.safeMultiply(ComputeUtil.safeDiv(sumSettleTaxMny, contractEntity.getContractTaxMny()), BigDecimal.valueOf(100)));
            jsonObject.put("detailList", settleVOS);
        }
        return jsonObject;
    }
}
