
package com.ejianc.business.jlcost.payout.enums;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 结算类型对应的单据编号枚举
 */
public enum SettleBillCodeEnum {
    外协加工(1, "SETTLE_PROCESS"),
    成品采购(2, "SETTLE_CPCG"),
    整体外包(3, "SETTLE_ZTWB"),
    场地或设备租赁(4, "SETTLE_CDSB"),
    外部检测(5, "SETTLE_WBJC"),
    外部设计(6, "SETTLE_WBSJ"),
    外部产品认证(7, "SETTLE_WBCPRZ"),
    劳务分包(8, "SETTLE_LWFB"),
    设备或材料采购(9, "SETTLE_SBCL"),
    设备租赁(10, "SETTLE_SBZL");

    private final Integer type;
    private final String billCode;
    private static Map<Integer, SettleBillCodeEnum> enumMap = new HashMap();

    private SettleBillCodeEnum(Integer type, String billCode) {
        this.type = type;
        this.billCode = billCode;
    }

    public Integer getType() {
        return type;
    }

    public String getBillCode() {
        return billCode;
    }

    public static SettleBillCodeEnum getEnumByType(Integer type) {
        return (SettleBillCodeEnum)enumMap.get(type);
    }

    static {
        enumMap = (Map)EnumSet.allOf(SettleBillCodeEnum.class).stream().collect(Collectors.toMap(SettleBillCodeEnum::getType, Function.identity(), (k1, k2) -> {
            return k2;
        }));
    }
}
