package com.ejianc.business.jlcost.finance.controller.api;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.jlcost.finance.service.IInvoiceService;
import com.ejianc.business.jlcost.finance.service.IReceiveService;
import com.ejianc.business.jlcost.finance.vo.InvoiceListVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.math.BigDecimal;


@RestController
@RequestMapping("/api/invoiceReceiveApi/")
public class InvoiceReceiveApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IInvoiceService invoiceService;
    @Autowired
    private IReceiveService receiveService;
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IBillCodeApi billCodeApi;



    /**
     * 获取合同登记下游业务 开票记录、回款记录信息
     *
     */
    @GetMapping(value = "getInvoiceReceiveDataByContractId")
    CommonResponse<JSONObject> getInvoiceReceiveDataByContractId(@RequestParam Long contractId){
        logger.info("接收参数-contractId-{}", contractId);
        JSONObject returnObject = receiveService.queryRecordByContId(contractId);
        if (null != returnObject){
            returnObject.put("receiveDetailList", returnObject.get("detailList"));
            returnObject.remove("detailList");
        }else {
            returnObject.put("receiveDetailList", null);
            returnObject.put("sumReceiveTaxMny", BigDecimal.ZERO);
        }

        InvoiceListVO invoiceListVO = invoiceService.getContractInvoice(contractId);
        logger.info("获取到开票信息-" + JSONObject.toJSONString(invoiceListVO));
        returnObject.put("sumInvoiceTaxMny", invoiceListVO.getCumulativeMny());
        returnObject.put("invoiceDetailList", invoiceListVO.getInvoiceDetailList());
        logger.info("根据合同登记id获取到开票、收款信息-" + JSONObject.toJSONString(returnObject));
        return CommonResponse.success(returnObject);
    }


}
