package com.ejianc.business.jlcost.finance.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ComputeUtil;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.jlcost.finance.mapper.ReimburseMapper;
import com.ejianc.business.jlcost.finance.bean.ReimburseEntity;
import com.ejianc.business.jlcost.finance.service.IReimburseService;

import java.math.BigDecimal;
import java.util.List;

/**
 * 资金管理-借款报销
 *
 * @author generator
 */
@Service("reimburseService")
public class ReimburseServiceImpl extends BaseServiceImpl<ReimburseMapper, ReimburseEntity> implements IReimburseService {

    @Override
    public BigDecimal getCumulativeMny(Long applyId) {
        LambdaQueryWrapper<ReimburseEntity> wrapper = new LambdaQueryWrapper<ReimburseEntity>();
        wrapper.eq(ReimburseEntity::getApplyId, applyId);
        wrapper.in(ReimburseEntity::getBillState, BillStateEnum.COMMITED_STATE, BillStateEnum.PASSED_STATE);
        List<ReimburseEntity> list = this.list(wrapper);
        BigDecimal cumulativeMny = BigDecimal.ZERO;
        if (CollectionUtils.isNotEmpty(list)) {
            for (ReimburseEntity entity : list) {
                cumulativeMny = ComputeUtil.safeAdd(cumulativeMny, entity.getCumulativeMny());
            }
        }
        return cumulativeMny;
    }

}
