package com.ejianc.business.jlcost.finance.controller.api;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.ejianc.business.jlcost.finance.bean.InvoiceEntity;
import com.ejianc.business.jlcost.finance.bean.ReceiveEntity;
import com.ejianc.business.jlcost.finance.service.IInvoiceService;
import com.ejianc.business.jlcost.finance.service.IReceiveService;
import com.ejianc.business.jlcost.finance.vo.DataPoolVO;
import com.ejianc.business.jlcost.finance.vo.InvoiceListVO;
import com.ejianc.business.jlcost.finance.vo.InvoiceVO;
import com.ejianc.business.jlcost.finance.vo.ReceiveVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;


@RestController
@RequestMapping("/api/invoiceReceiveApi/")
public class InvoiceReceiveApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IInvoiceService invoiceService;
    @Autowired
    private IReceiveService receiveService;
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IBillCodeApi billCodeApi;



    /**
     * 获取合同登记下游业务 开票记录、回款记录信息
     *
     */
    @GetMapping(value = "getInvoiceReceiveDataByContractId")
    CommonResponse<JSONObject> getInvoiceReceiveDataByContractId(@RequestParam Long contractId){
        logger.info("接收参数-contractId-{}", contractId);
        JSONObject returnObject = receiveService.queryRecordByContId(contractId);
        if (null != returnObject){
            returnObject.put("receiveDetailList", returnObject.get("detailList"));
            returnObject.remove("detailList");
        }else {
            returnObject.put("receiveDetailList", null);
            returnObject.put("sumReceiveTaxMny", BigDecimal.ZERO);
        }

        InvoiceListVO invoiceListVO = invoiceService.getContractInvoice(contractId);
        logger.info("获取到开票信息-" + JSONObject.toJSONString(invoiceListVO));
        returnObject.put("sumInvoiceTaxMny", invoiceListVO.getCumulativeMny());
        returnObject.put("invoiceDetailList", invoiceListVO.getInvoiceDetailList());
        logger.info("根据合同登记id获取到开票、收款信息-" + JSONObject.toJSONString(returnObject));
        return CommonResponse.success(returnObject);
    }



    /**
     * 开票记录、收款记录
     *
     */
    @GetMapping(value = "getDataPool")
    CommonResponse<DataPoolVO> getDataPool(){
        DataPoolVO dataPoolVO = new DataPoolVO();
        JSONObject returnObject = new JSONObject();
        LambdaQueryWrapper<InvoiceEntity> lambda = new LambdaQueryWrapper<InvoiceEntity>();
        lambda.in(InvoiceEntity::getBillState, BillStateEnum.COMMITED_STATE.getBillStateCode(),BillStateEnum.PASSED_STATE.getBillStateCode());
        List<InvoiceEntity> invoiceEntities = invoiceService.list(lambda);
        if(CollectionUtils.isNotEmpty(invoiceEntities)){
            dataPoolVO.setInvoiceDetailList(BeanMapper.mapList(invoiceEntities,InvoiceVO.class));
        }

        LambdaQueryWrapper<ReceiveEntity> lambda2 = new LambdaQueryWrapper<ReceiveEntity>();
        lambda2.in(ReceiveEntity::getBillState, BillStateEnum.COMMITED_STATE.getBillStateCode(),BillStateEnum.PASSED_STATE.getBillStateCode());
        List<ReceiveEntity> receiveEntities = receiveService.list(lambda2);
        if(CollectionUtils.isNotEmpty(receiveEntities)){
            dataPoolVO.setReceiveDetailList(BeanMapper.mapList(receiveEntities,ReceiveVO.class));
        }
        return CommonResponse.success(dataPoolVO);
    }


    /**
     * 开票记录、收款记录
     *
     */
    @GetMapping(value = "getInvoicePool")
    CommonResponse<List<InvoiceVO>> getInvoicePool(){
        List<InvoiceVO> resList = new ArrayList<>();
        LambdaQueryWrapper<InvoiceEntity> lambda = new LambdaQueryWrapper<InvoiceEntity>();
        lambda.in(InvoiceEntity::getBillState, BillStateEnum.COMMITED_STATE.getBillStateCode(),BillStateEnum.PASSED_STATE.getBillStateCode());
        List<InvoiceEntity> invoiceEntities = invoiceService.list(lambda);
        if(CollectionUtils.isNotEmpty(invoiceEntities)){
            resList = BeanMapper.mapList(invoiceEntities,InvoiceVO.class);
        }
        return CommonResponse.success(resList);
    }


    /**
     * 开票记录、收款记录
     *
     */
    @GetMapping(value = "getReceivePool")
    CommonResponse<List<ReceiveVO>> getReceivePool(){
        List<ReceiveVO> resList = new ArrayList<>();
        LambdaQueryWrapper<ReceiveEntity> lambda2 = new LambdaQueryWrapper<ReceiveEntity>();
        lambda2.in(ReceiveEntity::getBillState, BillStateEnum.COMMITED_STATE.getBillStateCode(),BillStateEnum.PASSED_STATE.getBillStateCode());
        List<ReceiveEntity> receiveEntities = receiveService.list(lambda2);
        if(CollectionUtils.isNotEmpty(receiveEntities)){
            resList = BeanMapper.mapList(receiveEntities,ReceiveVO.class);
        }
        return CommonResponse.success(resList);
    }
    /**
     * 获取合同登记下游业务 开票记录、回款记录信息
     *
     */
    @PostMapping(value = "getInvoiceReceiveDataByContractIdList")
    CommonResponse<JSONObject> getInvoiceReceiveDataByContractIdList(@RequestBody List<Long> ids){
        JSONObject returnObject = new JSONObject();

        logger.info("接收参数-ids-{}", JSONObject.toJSONString(ids));

        Map<Long, JSONObject> receiveDataMap = receiveService.queryRecordByContIdList(ids);
        Map<Long, InvoiceListVO> invoiceDataMap = invoiceService.getContractInvoiceByContractIdList(ids);

        for (Long contractId : ids) {
            JSONObject dataObject = new JSONObject();

            if (receiveDataMap.containsKey(contractId)){
                dataObject.put("sumReceiveTaxMny", receiveDataMap.get(contractId).get("sumReceiveTaxMny"));
                dataObject.put("receiveDetailList", receiveDataMap.get(contractId).get("receiveDetailList"));
            }
            if (invoiceDataMap.containsKey(contractId)){

                dataObject.put("sumInvoiceTaxMny", invoiceDataMap.get(contractId).getCumulativeMny());
                dataObject.put("invoiceDetailList", invoiceDataMap.get(contractId).getInvoiceDetailList());
            }
            returnObject.put(contractId.toString(), dataObject);
        }
        logger.info("获得合同下开票记录、回款记录信息-returnObject-{}", JSONObject.toJSONString(returnObject));

        return CommonResponse.success(returnObject);
    }


}
