/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.jlcost.finance.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.jlcost.finance.bean.ReimburseEntity;
import com.ejianc.business.jlcost.finance.mapper.ReimburseMapper;
import com.ejianc.business.jlcost.finance.service.IReimburseService;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

@Service(value="reimburseService")
public class ReimburseServiceImpl
extends BaseServiceImpl<ReimburseMapper, ReimburseEntity>
implements IReimburseService {
    @Override
    public BigDecimal getCumulativeMny(Long applyId) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(ReimburseEntity::getApplyId, (Object)applyId);
        wrapper.in(ReimburseEntity::getBillState, new Object[]{BillStateEnum.COMMITED_STATE, BillStateEnum.PASSED_STATE});
        List list = this.list((Wrapper)wrapper);
        BigDecimal cumulativeMny = BigDecimal.ZERO;
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            for (ReimburseEntity entity : list) {
                cumulativeMny = ComputeUtil.safeAdd((BigDecimal)cumulativeMny, (BigDecimal)entity.getReimburseMny());
            }
        }
        return cumulativeMny;
    }
}

