/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.jlcost.payout.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.jlcost.payout.bean.ContractDetailEntity;
import com.ejianc.business.jlcost.payout.bean.ContractEntity;
import com.ejianc.business.jlcost.payout.bean.SettleEntity;
import com.ejianc.business.jlcost.payout.enums.SettleSourceTypeEnum;
import com.ejianc.business.jlcost.payout.mapper.SettleMapper;
import com.ejianc.business.jlcost.payout.service.IContractService;
import com.ejianc.business.jlcost.payout.service.ISettleService;
import com.ejianc.business.jlcost.payout.vo.SettleDetailVO;
import com.ejianc.business.jlcost.payout.vo.SettleVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="settleService")
public class SettleServiceImpl
extends BaseServiceImpl<SettleMapper, SettleEntity>
implements ISettleService {
    @Autowired
    private IContractService contractService;

    @Override
    public SettleVO contToSettle(Long contractId) {
        ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.selectById(contractId));
        SettleVO settleVO = (SettleVO)BeanMapper.map((Object)((Object)contractEntity), SettleVO.class);
        settleVO.setId(null);
        settleVO.setBillCode(null);
        settleVO.setCreateTime(null);
        settleVO.setCreateUserCode(null);
        settleVO.setUpdateTime(null);
        settleVO.setUpdateUserCode(null);
        settleVO.setMemo(null);
        settleVO.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
        settleVO.setSettleDate(new Date());
        settleVO.setSettleBillType(contractEntity.getContractType());
        settleVO.setContractId(contractId);
        settleVO.setContractCode(contractEntity.getBillCode());
        settleVO.setContractTaxRate(contractEntity.getTaxRate());
        settleVO.setSettleType(Integer.valueOf(1));
        if (null != contractEntity.getProjectId() && "1".equals(contractEntity.getProjectType())) {
            SettleVO result = this.querySumMny(contractId, contractEntity.getProjectId());
            settleVO.setSumSettleMny(result.getSumSettleMny());
            settleVO.setSumSettleTaxMny(result.getSumSettleTaxMny());
            settleVO.setSumSettleAllMny(result.getSumSettleMny());
            settleVO.setSumSettleAllTaxMny(result.getSumSettleTaxMny());
        }
        ArrayList<SettleDetailVO> detailList = new ArrayList<SettleDetailVO>();
        for (ContractDetailEntity detailEntity : contractEntity.getContractDetailList()) {
            SettleDetailVO detailVO = (SettleDetailVO)BeanMapper.map((Object)((Object)detailEntity), SettleDetailVO.class);
            detailVO.setId(Long.valueOf(IdWorker.getId()));
            detailVO.setCreateTime(null);
            detailVO.setCreateUserCode(null);
            detailVO.setUpdateTime(null);
            detailVO.setUpdateUserCode(null);
            detailVO.setCode(detailEntity.getMaterialCode());
            detailVO.setName(detailEntity.getMaterialName());
            detailVO.setNum(null);
            detailVO.setPrice(detailEntity.getDetailPrice());
            detailVO.setTaxPrice(detailEntity.getDetailTaxPrice());
            detailVO.setTaxRate(contractEntity.getTaxRate());
            detailVO.setSourceId(String.valueOf(detailEntity.getId()));
            detailVO.setSourceType(String.valueOf(SettleSourceTypeEnum.\u5408\u540c\u6e05\u5355.getCode()));
            detailVO.setRowState("add");
            detailList.add(detailVO);
        }
        settleVO.setDetailList(detailList);
        return settleVO;
    }

    @Override
    public SettleVO querySumMny(Long contractId, Long projectId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SettleEntity::getContractId, (Object)contractId);
        queryWrapper.eq(SettleEntity::getProjectId, (Object)projectId);
        queryWrapper.in(SettleEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        List list = this.list((Wrapper)queryWrapper);
        SettleVO settleVO = new SettleVO();
        BigDecimal sumSettleMny = BigDecimal.ZERO;
        BigDecimal sumSettleTaxMny = BigDecimal.ZERO;
        for (SettleEntity entity : list) {
            sumSettleMny = ComputeUtil.safeAdd((BigDecimal)sumSettleMny, (BigDecimal)entity.getSettleMny());
            sumSettleTaxMny = ComputeUtil.safeAdd((BigDecimal)sumSettleTaxMny, (BigDecimal)entity.getSettleTaxMny());
        }
        settleVO.setSumSettleMny(sumSettleMny);
        settleVO.setSumSettleTaxMny(sumSettleTaxMny);
        return settleVO;
    }

    @Override
    public JSONObject queryRecordByContId(Long contractId) {
        ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.selectById(contractId));
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("contractMny", (Object)contractEntity.getContractMny());
        jsonObject.put("contractTaxMny", (Object)contractEntity.getContractTaxMny());
        jsonObject.put("performanceStatus", (Object)contractEntity.getPerformanceStatus());
        jsonObject.put("changeStatus", (Object)contractEntity.getChangeStatus());
        jsonObject.put("billState", (Object)contractEntity.getBillState());
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SettleEntity::getContractId, (Object)contractId);
        queryWrapper.in(SettleEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        queryWrapper.orderByDesc(SettleEntity::getSettleDate);
        List list = this.list((Wrapper)queryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            List settleVOS = BeanMapper.mapList((Iterable)list, SettleVO.class);
            settleVOS.sort(Comparator.comparing(SettleVO::getSettleDate));
            BigDecimal sumSettleMny = BigDecimal.ZERO;
            BigDecimal sumSettleTaxMny = BigDecimal.ZERO;
            for (SettleEntity entity : list) {
                sumSettleMny = ComputeUtil.safeAdd((BigDecimal)sumSettleMny, (BigDecimal)entity.getSettleMny());
                sumSettleTaxMny = ComputeUtil.safeAdd((BigDecimal)sumSettleTaxMny, (BigDecimal)entity.getSettleTaxMny());
            }
            jsonObject.put("sumSettleAllMny", (Object)sumSettleMny);
            jsonObject.put("sumSettleAllTaxMny", (Object)sumSettleTaxMny);
            jsonObject.put("settleTaxScale", (Object)ComputeUtil.safeMultiply((BigDecimal)ComputeUtil.safeDiv((BigDecimal)sumSettleTaxMny, (BigDecimal)contractEntity.getContractTaxMny()), (BigDecimal)BigDecimal.valueOf(100L)));
            jsonObject.put("detailList", (Object)settleVOS);
        }
        return jsonObject;
    }
}

