/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.jlcost.finance.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.jlcost.finance.bean.LoadApplyEntity;
import com.ejianc.business.jlcost.finance.service.IBackService;
import com.ejianc.business.jlcost.finance.service.ILoadApplyService;
import com.ejianc.business.jlcost.finance.service.IReimburseService;
import com.ejianc.business.jlcost.finance.vo.LoadApplyVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.permission.api.IRoleApi;
import com.ejianc.foundation.permission.vo.RoleVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.vo.ParamRegisterSetVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"loadApply"})
public class LoadApplyController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String PARAM_LOAD_APPLY_VIEW_CODE = "P-cG7Q1355";
    @Autowired
    private IRoleApi roleApi;
    @Autowired
    private IParamConfigApi paramConfigApi;
    private static final String BILL_CODE = "LoadApply";
    @Autowired
    private ILoadApplyService service;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IBackService backService;
    @Autowired
    private IReimburseService reimburseService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<LoadApplyVO> saveOrUpdate(@RequestBody LoadApplyVO saveOrUpdateVO) {
        LoadApplyEntity entity = (LoadApplyEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, LoadApplyEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        LoadApplyVO vo = (LoadApplyVO)BeanMapper.map((Object)((Object)entity), LoadApplyVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<LoadApplyVO> queryDetail(Long id) {
        LoadApplyEntity entity = (LoadApplyEntity)((Object)this.service.selectById(id));
        BigDecimal backedMny = this.backService.addBackMny(entity.getId());
        BigDecimal cumulativeMny = this.reimburseService.getCumulativeMny(entity.getId());
        entity.setBackedMny(backedMny);
        entity.setCumulativeMny(cumulativeMny);
        LoadApplyVO vo = (LoadApplyVO)BeanMapper.map((Object)((Object)entity), LoadApplyVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<LoadApplyVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (LoadApplyVO loadApplyVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<LoadApplyVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (!this.canViewAll().booleanValue()) {
            param.getParams().put("applyEmployeeId", new Parameter("eq", (Object)this.sessionManager.getUserContext().getEmployeeId()));
        }
        IPage page = this.service.queryPage(param, false);
        List records = page.getRecords();
        for (LoadApplyEntity record : records) {
            BigDecimal backedMny = this.backService.addBackMny(record.getId());
            BigDecimal cumulativeMny = this.reimburseService.getCumulativeMny(record.getId());
            record.setBackedMny(backedMny);
            record.setCumulativeMny(cumulativeMny);
        }
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List loadApplyVOS = BeanMapper.mapList((Iterable)records, LoadApplyVO.class);
        for (LoadApplyVO vo : loadApplyVOS) {
            if (vo.getBillState() == 0 || vo.getBillState() == 2 || vo.getBillState() == 4 || vo.getBillState() == 5) {
                vo.setLoanStatus("\u7533\u8bf7\u4e2d");
            }
            if (vo.getBillState() != 1 && vo.getBillState() != 3) continue;
            if (vo.getApplyMny().compareTo(vo.getBackedMny().add(vo.getCumulativeMny())) == 1) {
                vo.setLoanStatus("\u4f7f\u7528\u4e2d");
            }
            if (vo.getApplyMny().compareTo(vo.getBackedMny().add(vo.getCumulativeMny())) != 0) continue;
            vo.setLoanStatus("\u5df2\u62a5\u9500");
        }
        pageData.setRecords(loadApplyVOS);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        if (!this.canViewAll().booleanValue()) {
            param.getParams().put("applyEmployeeId", new Parameter("eq", (Object)this.sessionManager.getUserContext().getEmployeeId()));
        }
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("LoadApply-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refLoadApplyData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<LoadApplyVO>> refLoadApplyData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        List records = page.getRecords();
        for (LoadApplyEntity record : records) {
            BigDecimal backedMny = this.backService.addBackMny(record.getId());
            BigDecimal cumulativeMny = this.reimburseService.getCumulativeMny(record.getId());
            record.setBackedMny(backedMny);
            record.setCumulativeMny(cumulativeMny);
        }
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)records, LoadApplyVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    public Boolean canViewAll() {
        Long userid;
        CommonResponse roleRes;
        ParamRegisterSetVO paramRegisterSetVO;
        String valueData;
        CommonResponse byCode = this.paramConfigApi.getByCode(PARAM_LOAD_APPLY_VIEW_CODE);
        if (byCode.isSuccess() && null != byCode.getData() && StringUtils.isNotEmpty((CharSequence)(valueData = (paramRegisterSetVO = (ParamRegisterSetVO)byCode.getData()).getValueData())) && (roleRes = this.roleApi.queryRoleByUserId(userid = InvocationInfoProxy.getUserid())).isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)roleRes.getData()))) {
            List<String> valList = Arrays.asList(valueData.split(",|\uff0c"));
            for (RoleVO roleVO : (List)roleRes.getData()) {
                if (!valList.contains(roleVO.getCode())) continue;
                return Boolean.TRUE;
            }
        }
        return Boolean.FALSE;
    }
}

