/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.jlcost.finance.controller.api;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.ejianc.business.jlcost.finance.bean.InvoiceEntity;
import com.ejianc.business.jlcost.finance.bean.ReceiveEntity;
import com.ejianc.business.jlcost.finance.service.IInvoiceService;
import com.ejianc.business.jlcost.finance.service.IReceiveService;
import com.ejianc.business.jlcost.finance.vo.InvoiceListVO;
import com.ejianc.business.jlcost.finance.vo.InvoicePoolVO;
import com.ejianc.business.jlcost.finance.vo.InvoiceVO;
import com.ejianc.business.jlcost.finance.vo.ReceivePoolVO;
import com.ejianc.business.jlcost.finance.vo.ReceiveVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/invoiceReceiveApi/"})
public class InvoiceReceiveApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IInvoiceService invoiceService;
    @Autowired
    private IReceiveService receiveService;
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IBillCodeApi billCodeApi;

    @GetMapping(value={"getInvoiceReceiveDataByContractId"})
    CommonResponse<JSONObject> getInvoiceReceiveDataByContractId(@RequestParam Long contractId) {
        this.logger.info("\u63a5\u6536\u53c2\u6570-contractId-{}", (Object)contractId);
        JSONObject returnObject = this.receiveService.queryRecordByContId(contractId);
        if (null != returnObject) {
            returnObject.put("receiveDetailList", returnObject.get((Object)"detailList"));
            returnObject.remove((Object)"detailList");
        } else {
            returnObject.put("receiveDetailList", null);
            returnObject.put("sumReceiveTaxMny", (Object)BigDecimal.ZERO);
        }
        InvoiceListVO invoiceListVO = this.invoiceService.getContractInvoice(contractId);
        this.logger.info("\u83b7\u53d6\u5230\u5f00\u7968\u4fe1\u606f-" + JSONObject.toJSONString((Object)invoiceListVO));
        returnObject.put("sumInvoiceTaxMny", (Object)invoiceListVO.getCumulativeMny());
        returnObject.put("invoiceDetailList", (Object)invoiceListVO.getInvoiceDetailList());
        this.logger.info("\u6839\u636e\u5408\u540c\u767b\u8bb0id\u83b7\u53d6\u5230\u5f00\u7968\u3001\u6536\u6b3e\u4fe1\u606f-" + JSONObject.toJSONString((Object)returnObject));
        return CommonResponse.success((Object)returnObject);
    }

    @GetMapping(value={"getDataPool"})
    CommonResponse<JSONObject> getDataPool() {
        JSONObject returnObject = new JSONObject();
        LambdaQueryWrapper lambda = new LambdaQueryWrapper();
        lambda.in(InvoiceEntity::getBillState, new Object[]{BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()});
        List invoiceEntities = this.invoiceService.list((Wrapper)lambda);
        if (CollectionUtils.isNotEmpty((Collection)invoiceEntities)) {
            returnObject.put("invoiceDetailList", (Object)BeanMapper.mapList((Iterable)invoiceEntities, InvoicePoolVO.class));
        }
        LambdaQueryWrapper lambda2 = new LambdaQueryWrapper();
        lambda2.in(ReceiveEntity::getBillState, new Object[]{BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()});
        List receiveEntities = this.receiveService.list((Wrapper)lambda2);
        if (CollectionUtils.isNotEmpty((Collection)receiveEntities)) {
            returnObject.put("receiveDetailList", (Object)BeanMapper.mapList((Iterable)receiveEntities, ReceivePoolVO.class));
        }
        return CommonResponse.success((Object)returnObject);
    }

    @GetMapping(value={"getInvoicePool"})
    CommonResponse<List<InvoiceVO>> getInvoicePool() {
        List resList = new ArrayList();
        LambdaQueryWrapper lambda = new LambdaQueryWrapper();
        lambda.in(InvoiceEntity::getBillState, new Object[]{BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()});
        List invoiceEntities = this.invoiceService.list((Wrapper)lambda);
        if (CollectionUtils.isNotEmpty((Collection)invoiceEntities)) {
            resList = BeanMapper.mapList((Iterable)invoiceEntities, InvoiceVO.class);
        }
        return CommonResponse.success(resList);
    }

    @GetMapping(value={"getReceivePool"})
    CommonResponse<List<ReceiveVO>> getReceivePool() {
        List resList = new ArrayList();
        LambdaQueryWrapper lambda2 = new LambdaQueryWrapper();
        lambda2.in(ReceiveEntity::getBillState, new Object[]{BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()});
        List receiveEntities = this.receiveService.list((Wrapper)lambda2);
        if (CollectionUtils.isNotEmpty((Collection)receiveEntities)) {
            resList = BeanMapper.mapList((Iterable)receiveEntities, ReceiveVO.class);
        }
        return CommonResponse.success(resList);
    }

    @PostMapping(value={"getInvoiceReceiveDataByContractIdList"})
    CommonResponse<JSONObject> getInvoiceReceiveDataByContractIdList(@RequestBody List<Long> ids) {
        JSONObject returnObject = new JSONObject();
        this.logger.info("\u63a5\u6536\u53c2\u6570-ids-{}", (Object)JSONObject.toJSONString(ids));
        Map<Long, JSONObject> receiveDataMap = this.receiveService.queryRecordByContIdList(ids);
        Map<Long, InvoiceListVO> invoiceDataMap = this.invoiceService.getContractInvoiceByContractIdList(ids);
        for (Long contractId : ids) {
            JSONObject dataObject = new JSONObject();
            if (receiveDataMap.containsKey(contractId)) {
                dataObject.put("sumReceiveTaxMny", receiveDataMap.get(contractId).get((Object)"sumReceiveTaxMny"));
                dataObject.put("receiveDetailList", receiveDataMap.get(contractId).get((Object)"receiveDetailList"));
            }
            if (invoiceDataMap.containsKey(contractId)) {
                dataObject.put("sumInvoiceTaxMny", (Object)invoiceDataMap.get(contractId).getCumulativeMny());
                dataObject.put("invoiceDetailList", (Object)invoiceDataMap.get(contractId).getInvoiceDetailList());
            }
            returnObject.put(contractId.toString(), (Object)dataObject);
        }
        this.logger.info("\u83b7\u5f97\u5408\u540c\u4e0b\u5f00\u7968\u8bb0\u5f55\u3001\u56de\u6b3e\u8bb0\u5f55\u4fe1\u606f-returnObject-{}", (Object)JSONObject.toJSONString((Object)returnObject));
        return CommonResponse.success((Object)returnObject);
    }
}

