package com.ejianc.business.jlcost.finance.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.jlcost.finance.bean.ReimburseEntity;
import com.ejianc.business.jlcost.finance.service.ILoadApplyService;
import com.ejianc.business.jlcost.finance.service.IReimburseService;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ComputeUtil;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

@Service("reimburse")
public class ReimburseBpmServiceImpl implements ICommonBusinessService {
    @Autowired
    private IReimburseService service;
    @Autowired
    private ILoadApplyService applyService;

    /**
     * 提交前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    ;

    /**
     * 提交完回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    /**
     * 有审批流的撤回前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    ;

    /**
     * 有审批流的撤回后回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        ReimburseEntity entity = service.getById(billId);
        LambdaQueryWrapper<ReimburseEntity> wrapper = new LambdaQueryWrapper<ReimburseEntity>();
        wrapper.eq(ReimburseEntity::getApplyId, entity.getApplyId());
        wrapper.in(ReimburseEntity::getBillState, BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode());
        List<ReimburseEntity> list = service.list(wrapper);
        BigDecimal cumulativeMny = BigDecimal.ZERO;
        if (CollectionUtils.isNotEmpty(list)) {
            for (ReimburseEntity reimburse : list) {
                cumulativeMny = ComputeUtil.safeAdd(cumulativeMny, reimburse.getReimburseMny());
            }
        }
        applyService.upodateCumulativeMny(entity.getApplyId(), cumulativeMny);

        //TODO
        return CommonResponse.success();
    }

    ;

    /**
     * 审批节点审批中时节点审批前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    ;

    /**
     * 审批节点审批中时节点审批后回调
     *
     * @param billId       //单据id
     * @param state        //单据状态
     * @param billTypeCode //单据类型code
     * @param taskId       //该流程id
     * @param isEnd        //该节点是否结束
     * @return
     */
    @Override
    public CommonResponse<String> afterInApprovalBack(Long billId, Integer state, String billTypeCode, String taskId, Boolean isEnd, String sign, Map<String, Object> other) {
        return CommonResponse.success();
    }

    ;

    /**
     * 终审审核前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    /**
     * 终审审核完回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        ReimburseEntity entity = service.getById(billId);
        LambdaQueryWrapper<ReimburseEntity> wrapper = new LambdaQueryWrapper<ReimburseEntity>();
        wrapper.eq(ReimburseEntity::getApplyId, entity.getApplyId());
        wrapper.in(ReimburseEntity::getBillState, BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode());
        List<ReimburseEntity> list = service.list(wrapper);
        BigDecimal cumulativeMny = BigDecimal.ZERO;
        if (CollectionUtils.isNotEmpty(list)) {
            for (ReimburseEntity reimburse : list) {
                cumulativeMny = ComputeUtil.safeAdd(cumulativeMny, reimburse.getReimburseMny());
            }
        }
        applyService.upodateCumulativeMny(entity.getApplyId(), cumulativeMny);

        //TODO
        return CommonResponse.success();
    }

    /**
     * 弃审前事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    /**
     * 弃审后事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

}
