package com.ejianc.business.jlcost.finance.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.ejianc.framework.core.response.BillStateEnum;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.jlcost.finance.mapper.BackMapper;
import com.ejianc.business.jlcost.finance.bean.BackEntity;
import com.ejianc.business.jlcost.finance.service.IBackService;

import java.math.BigDecimal;
import java.util.List;

/**
 * 资金管理-借款退还
 * 
 * @author generator
 * 
 */
@Service("backService")
public class BackServiceImpl extends BaseServiceImpl<BackMapper, BackEntity> implements IBackService{

    @Override
    public BigDecimal addBackMny(Long applyId) {
        //计算已退还金额
        BigDecimal totalBackMny = BigDecimal.ZERO;
                LambdaQueryWrapper<BackEntity> lambda = new LambdaQueryWrapper<>();
        lambda.eq(BackEntity::getApplyId, applyId);
        lambda.in(BackEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode());
        List<BackEntity> entities = super.list(lambda);
        if (CollectionUtils.isNotEmpty(entities)) {
            totalBackMny = entities.stream().filter(item -> null != item.getBackMny()).map(BackEntity::getBackMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            return totalBackMny;
        }else {
            return totalBackMny;
        }
    }
}
