/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.jlcost.finance.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.jlcost.finance.bean.ReimburseEntity;
import com.ejianc.business.jlcost.finance.service.ILoadApplyService;
import com.ejianc.business.jlcost.finance.service.IReimburseService;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="reimburse")
public class ReimburseBpmServiceImpl
implements ICommonBusinessService {
    @Autowired
    private IReimburseService service;
    @Autowired
    private ILoadApplyService applyService;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        ReimburseEntity entity = (ReimburseEntity)((Object)this.service.getById(billId));
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(ReimburseEntity::getApplyId, (Object)entity.getApplyId());
        wrapper.in(ReimburseEntity::getBillState, new Object[]{BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()});
        List list = this.service.list((Wrapper)wrapper);
        BigDecimal cumulativeMny = BigDecimal.ZERO;
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            for (ReimburseEntity reimburse : list) {
                cumulativeMny = ComputeUtil.safeAdd((BigDecimal)cumulativeMny, (BigDecimal)reimburse.getReimburseMny());
            }
        }
        this.applyService.updateCumulativeMny(entity.getApplyId(), cumulativeMny);
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterInApprovalBack(Long billId, Integer state, String billTypeCode, String taskId, Boolean isEnd, String sign, Map<String, Object> other) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        ReimburseEntity entity = (ReimburseEntity)((Object)this.service.getById(billId));
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(ReimburseEntity::getApplyId, (Object)entity.getApplyId());
        wrapper.in(ReimburseEntity::getBillState, new Object[]{BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()});
        List list = this.service.list((Wrapper)wrapper);
        BigDecimal cumulativeMny = BigDecimal.ZERO;
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            for (ReimburseEntity reimburse : list) {
                cumulativeMny = ComputeUtil.safeAdd((BigDecimal)cumulativeMny, (BigDecimal)reimburse.getReimburseMny());
            }
        }
        this.applyService.updateCumulativeMny(entity.getApplyId(), cumulativeMny);
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }
}

