package com.ejianc.business.jlcost.finance.controller;

import java.io.Serializable;

import cn.hutool.Hutool;
import com.alibaba.fastjson.JSONArray;
import com.ejianc.business.jlcost.finance.consts.ArchiveProjectStatusEnum;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.permission.api.IRoleApi;
import com.ejianc.foundation.permission.vo.RoleVO;
import com.ejianc.foundation.share.api.IProjectArchiveApi;
import com.ejianc.foundation.share.vo.ProjectArchiveVO;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.ParamRegisterSetVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.jlcost.finance.bean.PayReimburseEntity;
import com.ejianc.business.jlcost.finance.service.IPayReimburseService;
import com.ejianc.business.jlcost.finance.vo.PayReimburseVO;

/**
 * 资金管理-费用报销单
 *
 * @author generator
 */
@Controller
@RequestMapping("payReimburse")
public class PayReimburseController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Payreimburse_Code";// 此处需要根据实际修改

    @Autowired
    private IPayReimburseService service;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private IParamConfigApi paramConfigApi;

    @Autowired
    private IRoleApi roleApi;

    private static final String PARAM_LOAD_APPLY_VIEW_CODE = "P-cG7Q1355";

    @Autowired
    private IProjectArchiveApi projectArchiveApi;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<PayReimburseVO> saveOrUpdate(@RequestBody PayReimburseVO saveOrUpdateVO) {
        PayReimburseEntity entity = BeanMapper.map(saveOrUpdateVO, PayReimburseEntity.class);
        if (entity.getId() == null || entity.getId() == 0) {
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());// 此处需要根据实际修改 删除本行或者上一行
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        service.saveOrUpdate(entity, false);
        PayReimburseVO vo = BeanMapper.map(entity, PayReimburseVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<PayReimburseVO> queryDetail(Long id) {
        PayReimburseEntity entity = service.selectById(id);
        PayReimburseVO vo = BeanMapper.map(entity, PayReimburseVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PayReimburseVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (PayReimburseVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(PayReimburseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @param param
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<PayReimburseVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        //根据当前用户角色判断是都可以查看全部备用金报销单
        if (!canViewAll()) {
            param.getParams().put("employeeId", new Parameter(QueryParam.EQ, sessionManager.getUserContext().getEmployeeId()));
        }

        IPage<PayReimburseEntity> page = service.queryPage(param, false);
        IPage<PayReimburseVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<PayReimburseVO> list = BeanMapper.mapList(page.getRecords(), PayReimburseVO.class);

        // 获取项目ID集合 不重复
        Set<Long> projectIds = new HashSet<>();
        list.forEach(vo -> {
            projectIds.add(vo.getProjectId());
        });
        // Set集合转为List
        ArrayList<Long> projectIdList = new ArrayList<>(projectIds);
        // 根据项目id集合查询项目阶段
        CommonResponse<List<ProjectArchiveVO>> projectArchiveByIds = projectArchiveApi.getProjectArchiveByIds(projectIdList);
        List<ProjectArchiveVO> projectArchiveVOList = projectArchiveByIds.getData();
        // 项目中标状态map Map<项目id,项目中标状态>
        Map<Long, String> stageMap = new HashMap<>();
        // 遍历项目阶段集合，设置stageMap的key-value <项目id,项目中标状态>
        for (ProjectArchiveVO projectArchiveVO : projectArchiveVOList) {
            if (projectArchiveVO.getProjectStatus().equals(ArchiveProjectStatusEnum.未中标.getCode())) {
                stageMap.put(projectArchiveVO.getId(), "未中标");
            } else if (projectArchiveVO.getProjectStatus().equals(ArchiveProjectStatusEnum.商机阶段.getCode()) || projectArchiveVO.getProjectStatus().equals(ArchiveProjectStatusEnum.投标阶段.getCode())) {
                stageMap.put(projectArchiveVO.getId(), "投标中");
            } else {
                stageMap.put(projectArchiveVO.getId(), "已中标");
            }
        }
        // 遍历list，设置项目中标状态
        for (PayReimburseVO vo : list) {
            vo.setProjectStatusName(stageMap.get(vo.getProjectId()));
        }

        // 判断筛选栏项目中标状态是否被选择
        System.out.println("params");
        if (null != param.getParams().get("projectStatus")) {
            System.out.println(param.getParams().get("projectStatus").getValue().toString());
        }

        pageData.setRecords(list);
        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @param param
     * @Description 导出
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        if (!canViewAll()) {
            param.getParams().put("employeeId", new Parameter(QueryParam.EQ, sessionManager.getUserContext().getEmployeeId()));
        }
        param.setPageIndex(1);
        param.setPageSize(-1);
        List<PayReimburseEntity> list = service.queryList(param);
        // 字段翻译
        List<PayReimburseVO> resDatas = BeanMapper.mapList(list, PayReimburseVO.class);

        for (PayReimburseVO resData : resDatas) {
            switch (resData.getBillState()) {
                case 0:
                    resData.setBillStateName("自由态");
                    break;
                case 1:
                    resData.setBillStateName("已提交");
                    break;
                case 2:
                case 5:
                    resData.setBillStateName("审批中");
                    break;
                case 3:
                    resData.setBillStateName("审批通过");
                    break;
                case 4:
                    resData.setBillStateName("审批驳回");
                    break;
            }
        }

        Map<String, Object> beans = new HashMap<>();
        beans.put("records", resDatas);
        ExcelExport.getInstance().export("PayReimburse-export.xlsx", beans, response);
    }

    /**
     * @param param
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refPayReimburseData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<PayReimburseVO>> refPayReimburseData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                     String condition,
                                                                     String searchObject,
                                                                     String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<PayReimburseEntity> page = service.queryPage(param, false);
        IPage<PayReimburseVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), PayReimburseVO.class));

        return CommonResponse.success("查询参照数据成功！", pageData);
    }

    /**
     * @description: 根据当前用户角色判断是都可以查看全部备用金报销单
     * @return: java.lang.Boolean
     * @author songlx
     * @date: 2022/7/26
     */
    public Boolean canViewAll() {
        CommonResponse<ParamRegisterSetVO> byCode = paramConfigApi.getByCode(PARAM_LOAD_APPLY_VIEW_CODE);
        if (byCode.isSuccess() && null != byCode.getData()) {
            ParamRegisterSetVO paramRegisterSetVO = byCode.getData();
            String valueData = paramRegisterSetVO.getValueData();
            if (StringUtils.isNotEmpty(valueData)) {
                Long userid = InvocationInfoProxy.getUserid();
                CommonResponse<List<RoleVO>> roleRes = roleApi.queryRoleByUserId(userid);
                if (roleRes.isSuccess() && CollectionUtils.isNotEmpty(roleRes.getData())) {
                    List<String> valList = Arrays.asList(valueData.split(",|，"));
                    for (RoleVO roleVO : roleRes.getData()) {
                        if (valList.contains(roleVO.getCode())) {
                            return Boolean.TRUE;
                        }
                    }
                }
            }
        }
        return Boolean.FALSE;
    }


    /**
     * @Description 定时任务-抽取数据，计算实际完成业绩
     */
    @RequestMapping(value = "/savePoolDate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> savePoolDate(HttpServletRequest request) {
        String param = request.getParameter("param");
        JSONArray json = JSONArray.parseArray(param);
        logger.info("抽取数据，计算实际完成业绩  获取到的参数JSON是：" + param + "----");
//        service.saveInitPoolDate();

        //1,查找你数据里的项目id
        //2,掉接口 --》list<项目信息>
        //3， list--map<projectId,阶段>
        //4，循环自己表的数据，根据项目   到map里取阶段值 判断后 复制给  状态字段
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        return CommonResponse.success("数据加载成功",simpleDateFormat.format(new Date()));
    }
}
