package com.ejianc.business.jlcost.finance.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.jlcost.finance.consts.ArchiveProjectStatusEnum;
import com.ejianc.foundation.share.api.IProjectArchiveApi;
import com.ejianc.foundation.share.vo.ProjectArchiveVO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.jlcost.finance.mapper.PayReimburseMapper;
import com.ejianc.business.jlcost.finance.bean.PayReimburseEntity;
import com.ejianc.business.jlcost.finance.service.IPayReimburseService;

import java.util.*;

/**
 * 资金管理-费用报销单
 *
 * @author generator
 */
@Service("payReimburseService")
public class PayReimburseServiceImpl extends BaseServiceImpl<PayReimburseMapper, PayReimburseEntity> implements IPayReimburseService {

    @Autowired
    private IProjectArchiveApi projectArchiveApi;

    @Override
    public void updateProjectStatus() {
        // 查询所有报销单
        List<PayReimburseEntity> reimburseList = this.list();
        // 遍历报销单 将项目id存入集合 不重复
        HashSet<Long> projectIds = new HashSet<>();
        reimburseList.forEach(reimburse -> {
            projectIds.add(reimburse.getProjectId());
        });
        // Set转List
        ArrayList<Long> projectIdList = new ArrayList<>(projectIds);
        // 调rpc接口 根据id集合查询项目信息
        List<ProjectArchiveVO> projectList = projectArchiveApi.getProjectArchiveByIds(projectIdList).getData();
        // 遍历项目集合，使用Map集合保存项目中标状态，为Map赋值 statusMap<项目id,项目中标状态>  statusIdMap<项目中标状态,项目中标状态id>
        Map<Long, String> statusMap = new HashMap<>();
        Map<String, Integer> statusIdMap = new HashMap<>();
        for (ProjectArchiveVO projectArchiveVO : projectList) {
            if (projectArchiveVO.getProjectStatus().equals(ArchiveProjectStatusEnum.未中标.getCode())) {
                statusMap.put(projectArchiveVO.getId(), "未中标");
                statusIdMap.put("未中标", 2);
            } else if (projectArchiveVO.getProjectStatus().equals(ArchiveProjectStatusEnum.商机阶段.getCode()) || projectArchiveVO.getProjectStatus().equals(ArchiveProjectStatusEnum.投标阶段.getCode())) {
                statusMap.put(projectArchiveVO.getId(), "投标中");
                statusIdMap.put("投标中", 1);
            } else {
                statusMap.put(projectArchiveVO.getId(), "已中标");
                statusIdMap.put("已中标", 3);
            }
        }

        // 遍历项目id集合 根据项目id 更新项目中标状态到数据库
        projectIdList.forEach(projectId -> {
            LambdaUpdateWrapper<PayReimburseEntity> updateWrapper = new LambdaUpdateWrapper<>();
            updateWrapper.eq(PayReimburseEntity::getProjectId, projectId);
            updateWrapper.set(PayReimburseEntity::getProjectStatusName, statusMap.get(projectId));
            updateWrapper.set(PayReimburseEntity::getProjectStatus,statusIdMap.get(statusMap.get(projectId)));
            this.update(updateWrapper);
        });
    }
}
